/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.BinaryOperatorNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class AndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public AndNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position, NodeType.ANDNODE);
        assert (firstNode != null) : "AndNode.first == null";
        assert (secondNode != null) : "AndNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitAndNode(this);
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.firstNode.interpret(runtime, context, self, aBlock);
        if (!result.isTrue()) {
            return result;
        }
        return this.secondNode.interpret(runtime, context, self, aBlock);
    }
}

