/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.errors.ExtensionErrorReporterAspect;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MavenPluginDiscoverer;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginManagerSupport;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.realm.RealmManagementException;
import org.apache.maven.realm.RealmScanningUtils;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultPluginManagerSupport
implements PluginManagerSupport,
LogEnabled,
Contextualizable {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private RuntimeInformation runtimeInformation;
    private PluginVersionManager pluginVersionManager;
    private Logger logger;
    private Context containerContext;

    public Artifact resolvePluginArtifact(Plugin plugin, MavenProject project, MavenSession session) throws PluginManagerException, InvalidPluginException, PluginVersionResolutionException, ArtifactResolutionException, ArtifactNotFoundException {
        VersionRange versionRange;
        ArtifactRepository localRepository = session.getLocalRepository();
        try {
            versionRange = VersionRange.createFromVersionSpec(plugin.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new PluginManagerException(plugin, e);
        }
        ArrayList<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();
        remoteRepositories.addAll(project.getRemoteArtifactRepositories());
        MavenProject pluginProject = this.buildPluginProject(plugin, localRepository, remoteRepositories);
        try {
            this.checkRequiredMavenVersion(plugin, pluginProject, localRepository, remoteRepositories);
        }
        catch (PluginVersionResolutionException pluginVersionResolutionException) {
            if (ExtensionErrorReporterAspect.ajc$cflowStack$4.isValid() && ExtensionErrorReporterAspect.ajc$cflowStack$5.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$17$5075f78c((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$5.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(0), (List)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(1), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(2), pluginVersionResolutionException);
            }
            throw pluginVersionResolutionException;
        }
        this.checkPluginDependencySpec(plugin, pluginProject);
        Artifact pluginArtifact = this.artifactFactory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
        pluginArtifact = project.replaceWithActiveArtifact(pluginArtifact);
        this.artifactResolver.resolve(pluginArtifact, remoteRepositories, localRepository);
        return pluginArtifact;
    }

    public MavenProject buildPluginProject(Plugin plugin, ArtifactRepository localRepository, List remoteRepositories) throws InvalidPluginException {
        Artifact artifact = this.artifactFactory.createProjectArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
        try {
            return this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new InvalidPluginException("Unable to build project for plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
        }
    }

    public void checkRequiredMavenVersion(Plugin plugin, MavenProject pluginProject, ArtifactRepository localRepository, List remoteRepositories) throws PluginVersionResolutionException, InvalidPluginException {
        if (pluginProject.getPrerequisites() != null && pluginProject.getPrerequisites().getMaven() != null) {
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(pluginProject.getPrerequisites().getMaven());
            if (this.runtimeInformation.getApplicationVersion().compareTo(requiredVersion) < 0) {
                throw new PluginVersionResolutionException(plugin.getGroupId(), plugin.getArtifactId(), "Plugin requires Maven version " + requiredVersion);
            }
        }
    }

    public void checkPluginDependencySpec(Plugin plugin, MavenProject pluginProject) throws InvalidPluginException {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        try {
            pluginProject.createArtifacts(this.artifactFactory, null, filter);
        }
        catch (InvalidDependencyVersionException e) {
            InvalidDependencyVersionException invalidDependencyVersionException = e;
            String string = "Plugin: " + plugin.getKey() + " has a dependency with an invalid version.";
            if (ExtensionErrorReporterAspect.ajc$cflowStack$4.isValid() && ExtensionErrorReporterAspect.ajc$cflowStack$5.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                ExtensionErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_errors_ExtensionErrorReporterAspect$18$b02f8dba((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$5.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(0), (List)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(1), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$4.get(2), invalidDependencyVersionException);
            }
            throw new InvalidPluginException(string, invalidDependencyVersionException);
        }
    }

    public PluginDescriptor loadIsolatedPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) {
        if (plugin.getVersion() == null) {
            try {
                plugin.setVersion(this.pluginVersionManager.resolvePluginVersion(plugin.getGroupId(), plugin.getArtifactId(), project, session));
            }
            catch (PluginVersionResolutionException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
            }
            catch (InvalidPluginException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
            }
            catch (PluginVersionNotFoundException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
            }
        }
        if (plugin.getVersion() == null) {
            return null;
        }
        Artifact artifact = null;
        try {
            artifact = this.resolvePluginArtifact(plugin, project, session);
        }
        catch (ArtifactResolutionException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
        }
        catch (ArtifactNotFoundException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
        }
        catch (PluginManagerException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
        }
        catch (InvalidPluginException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
        }
        catch (PluginVersionResolutionException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), e);
        }
        if (artifact == null) {
            return null;
        }
        MavenPluginDiscoverer discoverer = new MavenPluginDiscoverer();
        discoverer.setManager(RealmScanningUtils.getDummyComponentDiscovererManager());
        try {
            List componentSetDescriptors = RealmScanningUtils.scanForComponentSetDescriptors(artifact, discoverer, this.containerContext, "Plugin: " + plugin.getKey());
            if (!componentSetDescriptors.isEmpty()) {
                return (PluginDescriptor)componentSetDescriptors.get(0);
            }
        }
        catch (RealmManagementException e) {
            this.logger.debug("Failed to scan plugin artifact: " + artifact.getId() + " for descriptors.", e);
        }
        return null;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        this.containerContext = context;
    }
}

