/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PlatformTypes;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class CompilerLineConvertor
implements LineConvertor {
    private final List<ErrorParserProvider.ErrorParser> parsers = new ArrayList<ErrorParserProvider.ErrorParser>();
    private static final int LENGTH_TRESHOLD = 2048;

    public CompilerLineConvertor(CompilerSet set, ExecutionEnvironment execEnv, FileObject relativeTo) {
        List<CompilerFlavor> flavors = this.getCompilerSet(set, execEnv);
        for (CompilerFlavor flavor : flavors) {
            ErrorParserProvider.ErrorParser parser = ErrorParserProvider.getDefault().getErorParser(flavor, execEnv, relativeTo);
            if (parser == null) continue;
            this.parsers.add(parser);
        }
    }

    public List<ConvertedLine> convert(String line) {
        try {
            return this.handleLine(line);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private List<ConvertedLine> handleLine(String line) throws IOException {
        if (line.length() < 2048) {
            for (ErrorParserProvider.ErrorParser parser : this.parsers) {
                ErrorParserProvider.Result res = parser.handleLine(line);
                if (res == null || !res.result()) continue;
                return res.converted();
            }
        }
        return null;
    }

    private List<CompilerFlavor> getCompilerSet(CompilerSet set, ExecutionEnvironment execEnv) {
        int platform = PlatformTypes.getDefaultPlatform();
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            switch (hostInfo.getOSFamily()) {
                case SUNOS: {
                    if (hostInfo.getCpuFamily() == HostInfo.CpuFamily.SPARC) {
                        platform = 0;
                        break;
                    }
                    platform = 1;
                    break;
                }
                case WINDOWS: {
                    platform = 3;
                    break;
                }
                case LINUX: {
                    platform = 2;
                    break;
                }
                case MACOSX: {
                    platform = 4;
                    break;
                }
                default: {
                    platform = 5;
                    break;
                }
            }
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        ArrayList<CompilerFlavor> flavors = new ArrayList<CompilerFlavor>();
        flavors.add(set.getCompilerFlavor());
        for (CompilerFlavor flavor : CompilerFlavorImpl.getFlavors(platform)) {
            if (flavors.contains(flavor)) continue;
            boolean found = false;
            for (CompilerFlavor f : flavors) {
                if (!this.isScannerEquals(f, flavor)) continue;
                found = true;
                break;
            }
            if (found) continue;
            flavors.add(flavor);
        }
        return flavors;
    }

    private boolean isScannerEquals(CompilerFlavor flavor1, CompilerFlavor flavor2) {
        int i;
        ToolchainManager.ScannerDescriptor scanner1 = flavor1.getToolchainDescriptor().getScanner();
        ToolchainManager.ScannerDescriptor scanner2 = flavor2.getToolchainDescriptor().getScanner();
        if (scanner1.getPatterns().size() != scanner2.getPatterns().size()) {
            return false;
        }
        for (i = 0; i < scanner1.getPatterns().size(); ++i) {
            if (scanner1.getPatterns().get(i).getPattern().equals(scanner2.getPatterns().get(i).getPattern())) continue;
            return false;
        }
        if (!this.isEquals(scanner1.getEnterDirectoryPattern(), scanner2.getEnterDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scanner1.getLeaveDirectoryPattern(), scanner2.getLeaveDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scanner1.getChangeDirectoryPattern(), scanner2.getChangeDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scanner1.getMakeAllInDirectoryPattern(), scanner2.getMakeAllInDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scanner1.getStackHeaderPattern(), scanner2.getStackHeaderPattern())) {
            return false;
        }
        if (!this.isEquals(scanner1.getStackNextPattern(), scanner2.getStackNextPattern())) {
            return false;
        }
        if (scanner1.getFilterOutPatterns().size() != scanner2.getFilterOutPatterns().size()) {
            return false;
        }
        for (i = 0; i < scanner1.getFilterOutPatterns().size(); ++i) {
            if (scanner1.getFilterOutPatterns().get(i).equals(scanner2.getFilterOutPatterns().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

