/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.openide.util.NbBundle;

public final class PropertyEditorComboBoxNoUserCode
extends DesignPropertyEditor {
    private final Map<String, PropertyValue> values;
    private String[] tags;
    private TypeID enableTypeID;

    private PropertyEditorComboBoxNoUserCode(Map<String, PropertyValue> values, TypeID enableTypeID) {
        this.values = values;
        this.enableTypeID = enableTypeID;
        this.createTags();
    }

    public static PropertyEditorComboBoxNoUserCode createInstance(Map<String, PropertyValue> values, TypeID typeID) {
        if (values == null) {
            throw new IllegalArgumentException("Argument values can't be null");
        }
        for (String key : values.keySet()) {
            PropertyValue value = values.get(key);
            if (value != null) continue;
            throw new IllegalArgumentException("PropertyValue for " + key + " key can't be null");
        }
        return new PropertyEditorComboBoxNoUserCode(values, typeID);
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        this.tags = null;
        this.enableTypeID = null;
    }

    public void setAsText(String text) {
        if (this.canWrite()) {
            this.saveValue(text);
        }
    }

    private void saveValue(String text) {
        PropertyValue value;
        if (text.length() > 0 && (value = this.values.get(text)) != null) {
            super.setValue((Object)value);
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public String getAsText() {
        PropertyValue value = (PropertyValue)super.getValue();
        if (this.values == null) {
            return null;
        }
        for (String key : this.values.keySet()) {
            PropertyValue tmpValue = this.values.get(key);
            if (!value.getPrimitiveValue().equals(tmpValue.getPrimitiveValue())) continue;
            return key;
        }
        return NbBundle.getMessage(PropertyEditorComboBoxNoUserCode.class, (String)"LBL_MULTIPLE");
    }

    public String[] getTags() {
        return this.tags;
    }

    private void createTags() {
        int i = 0;
        this.tags = new String[this.values.size()];
        for (String valueAsText : this.values.keySet()) {
            this.tags[i++] = valueAsText;
        }
    }

    public Boolean canEditAsText() {
        return null;
    }
}

