/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.QualifierChecker;

public class AnnotationObjectProvider
implements ObjectProvider<BindingQualifier> {
    private static final String SPECILIZES_ANNOTATION = "javax.enterprise.inject.Specializes";
    static final Logger LOGGER = Logger.getLogger(AnnotationObjectProvider.class.getName());
    private AnnotationModelHelper myHelper;
    private String myAnnotationName;

    AnnotationObjectProvider(AnnotationModelHelper annotationModelHelper, String string) {
        this.myHelper = annotationModelHelper;
        this.myAnnotationName = string;
    }

    public List<BindingQualifier> createInitialObjects() throws InterruptedException {
        final LinkedList linkedList = new LinkedList();
        final HashSet hashSet = new HashSet();
        this.getHelper().getAnnotationScanner().findAnnotations(this.getAnnotationName(), AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

            public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                if (!hashSet.contains(typeElement)) {
                    linkedList.add(new BindingQualifier(AnnotationObjectProvider.this.getHelper(), typeElement, AnnotationObjectProvider.this.getAnnotationName()));
                }
                hashSet.add(typeElement);
                if (!AnnotationObjectProvider.this.getHelper().hasAnnotation(annotationMirror.getAnnotationType().asElement().getAnnotationMirrors(), Inherited.class.getCanonicalName())) {
                    AnnotationObjectProvider.this.collectSpecializedImplementors(typeElement, hashSet, linkedList);
                }
            }
        });
        return new ArrayList<BindingQualifier>(linkedList);
    }

    public List<BindingQualifier> createObjects(TypeElement typeElement) {
        ArrayList<BindingQualifier> arrayList = new ArrayList<BindingQualifier>();
        Map map = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(typeElement));
        AnnotationMirror annotationMirror = (AnnotationMirror)map.get(this.getAnnotationName());
        if (annotationMirror != null) {
            arrayList.add(new BindingQualifier(this.getHelper(), typeElement, this.getAnnotationName()));
        }
        if (!(annotationMirror != null && this.getHelper().hasAnnotation(annotationMirror.getAnnotationType().asElement().getAnnotationMirrors(), Inherited.class.getCanonicalName()) || AnnotationObjectProvider.checkSuper(typeElement, this.getAnnotationName(), this.getHelper()) == null)) {
            arrayList.add(new BindingQualifier(this.getHelper(), typeElement, this.getAnnotationName()));
        }
        return arrayList;
    }

    public boolean modifyObjects(TypeElement typeElement, List<BindingQualifier> list) {
        assert (list.size() == 1);
        BindingQualifier bindingQualifier = list.get(0);
        assert (bindingQualifier != null);
        if (!bindingQualifier.refresh(typeElement)) {
            list.remove(0);
            return true;
        }
        return false;
    }

    static TypeElement checkSuper(TypeElement typeElement, String string, AnnotationModelHelper annotationModelHelper) {
        if (!AnnotationObjectProvider.hasSpecializes(typeElement, annotationModelHelper)) {
            return null;
        }
        TypeElement typeElement2 = annotationModelHelper.getSuperclass(typeElement);
        if ("javax.enterprise.inject.Default".equals(string) && AnnotationObjectProvider.checkSpecializedDefault(typeElement2, annotationModelHelper)) {
            return typeElement2;
        }
        if (AnnotationObjectProvider.hasAnnotation(typeElement2, string, annotationModelHelper)) {
            return typeElement2;
        }
        TypeElement typeElement3 = AnnotationObjectProvider.checkSuper(typeElement2, string, annotationModelHelper);
        if (typeElement3 != null) {
            return typeElement3;
        }
        List<? extends TypeMirror> list = typeElement.getInterfaces();
        for (TypeMirror typeMirror : list) {
            Element element = annotationModelHelper.getCompilationController().getTypes().asElement(typeMirror);
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement4 = (TypeElement)element;
            if ("javax.enterprise.inject.Default".equals(string) && AnnotationObjectProvider.checkSpecializedDefault(typeElement4, annotationModelHelper)) {
                return typeElement2;
            }
            if (AnnotationObjectProvider.hasAnnotation(typeElement4, string, annotationModelHelper)) {
                return typeElement4;
            }
            typeElement3 = AnnotationObjectProvider.checkSuper(typeElement4, string, annotationModelHelper);
            if (typeElement3 == null) continue;
            return typeElement3;
        }
        return null;
    }

    static boolean checkSpecializedDefault(Element element, AnnotationModelHelper annotationModelHelper) {
        return annotationModelHelper.hasAnnotation(annotationModelHelper.getCompilationController().getElements().getAllAnnotationMirrors(element), "javax.enterprise.inject.Default");
    }

    static boolean checkDefault(Element element, AnnotationModelHelper annotationModelHelper) {
        Set<String> set = AnnotationObjectProvider.getQualifiers(element, annotationModelHelper);
        if (set.contains("javax.enterprise.inject.Default")) {
            return true;
        }
        set.remove("javax.inject.Named");
        set.remove("javax.enterprise.inject.Any");
        return set.size() == 0;
    }

    static Set<String> getQualifiers(Element element, AnnotationModelHelper annotationModelHelper) {
        HashSet<String> hashSet = new HashSet<String>();
        List<? extends AnnotationMirror> list = annotationModelHelper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (!AnnotationObjectProvider.isQualifier(typeElement, annotationModelHelper)) continue;
            hashSet.add(typeElement.getQualifiedName().toString());
        }
        return hashSet;
    }

    static boolean isQualifier(TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        QualifierChecker qualifierChecker = QualifierChecker.get();
        qualifierChecker.init(typeElement, annotationModelHelper);
        return qualifierChecker.check();
    }

    public static boolean hasSpecializes(Element element, AnnotationModelHelper annotationModelHelper) {
        return AnnotationObjectProvider.hasAnnotation(element, SPECILIZES_ANNOTATION, annotationModelHelper);
    }

    static boolean hasAnnotation(Element element, String string, AnnotationModelHelper annotationModelHelper) {
        List<? extends AnnotationMirror> list = annotationModelHelper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        return annotationModelHelper.hasAnnotation(list, string);
    }

    private String getAnnotationName() {
        return this.myAnnotationName;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    private void collectSpecializedImplementors(TypeElement typeElement, Set<TypeElement> set, List<BindingQualifier> list) {
        HashSet hashSet = new HashSet();
        HashSet<TypeElement> hashSet2 = new HashSet<TypeElement>();
        hashSet2.add(typeElement);
        while (hashSet2.size() > 0) {
            TypeElement typeElement2 = (TypeElement)hashSet2.iterator().next();
            hashSet2.remove(typeElement2);
            Object object = this.doCollectSpecializedImplementors(typeElement2, list);
            if (object.size() == 0) continue;
            hashSet.addAll(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TypeElement typeElement3 = (TypeElement)iterator.next();
                hashSet2.add(typeElement3);
            }
        }
        for (Object object : hashSet) {
            if (!AnnotationObjectProvider.hasSpecializes((Element)object, this.getHelper())) continue;
            this.handleSuper(typeElement, (TypeElement)object, list, set);
        }
    }

    private Set<TypeElement> doCollectSpecializedImplementors(TypeElement typeElement, List<BindingQualifier> list) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
        Set set = this.getHelper().getClasspathInfo().getClassIndex().getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (set == null) {
            LOGGER.log(Level.WARNING, "ClassIndex.getElements() was interrupted");
            return Collections.emptySet();
        }
        for (ElementHandle elementHandle2 : set) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle2.getQualifiedName());
            TypeElement typeElement2 = (TypeElement)elementHandle2.resolve((CompilationInfo)this.getHelper().getCompilationController());
            if (typeElement2 == null) continue;
            hashSet.add(typeElement2);
        }
        return hashSet;
    }

    private boolean handleInterface(TypeElement typeElement, TypeElement typeElement2, Set<TypeElement> set, Set<TypeElement> set2) {
        List<? extends TypeMirror> list = typeElement2.getInterfaces();
        for (TypeMirror typeMirror : list) {
            if (this.getHelper().getCompilationController().getTypes().isSameType(typeElement.asType(), typeMirror)) {
                return true;
            }
            if (!this.getHelper().getCompilationController().getTypes().isAssignable(typeMirror, typeElement.asType())) continue;
            Element element = this.getHelper().getCompilationController().getTypes().asElement(typeMirror);
            if (!(element instanceof TypeElement)) {
                return false;
            }
            TypeElement typeElement3 = (TypeElement)element;
            if (set2.contains(typeElement3)) {
                return true;
            }
            set.add(typeElement3);
            if (!AnnotationObjectProvider.hasSpecializes(typeElement3, this.getHelper())) {
                return false;
            }
            return this.handleInterface(typeElement, typeElement3, set, set2);
        }
        return false;
    }

    private void handleSuper(TypeElement typeElement, TypeElement typeElement2, List<BindingQualifier> list, Set<TypeElement> set) {
        TypeElement typeElement32;
        if (!this.getHelper().getCompilationController().getTypes().isAssignable(typeElement2.asType(), typeElement.asType())) {
            return;
        }
        List list2 = this.getHelper().getSuperclasses(typeElement2);
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        hashSet.add(typeElement2);
        boolean bl = true;
        TypeElement typeElement4 = typeElement2;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext() && !(typeElement32 = (TypeElement)iterator.next()).equals(typeElement) && !set.contains(typeElement32)) {
            if (this.getHelper().getCompilationController().getTypes().isAssignable(typeElement32.asType(), typeElement.asType())) {
                typeElement4 = typeElement32;
                continue;
            }
            if (!AnnotationObjectProvider.hasSpecializes(typeElement32, this.getHelper())) {
                bl = false;
                break;
            }
            hashSet.add(typeElement32);
            bl = this.handleInterface(typeElement, typeElement4, hashSet, set);
            break;
        }
        if (bl) {
            for (TypeElement typeElement32 : hashSet) {
                if (set.contains(typeElement32)) continue;
                set.add(typeElement32);
                list.add(new BindingQualifier(this.getHelper(), typeElement32, this.getAnnotationName()));
            }
        }
    }
}

