/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.debug.BSFDebugManager;
import org.apache.bsf.debug.BSFDebugger;
import org.apache.bsf.debug.serverImpl.ObjectServer;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.debug.util.RemoteService;
import org.apache.bsf.debug.util.RemoteServiceListener;
import org.apache.bsf.debug.util.Skeleton;
import org.apache.bsf.util.DocumentCell;
import org.apache.bsf.util.LangCell;

public class BSFDebugManagerImpl
extends Skeleton
implements BSFDebugManager,
RemoteServiceListener {
    static BSFDebugManagerImpl self;
    private long m_fnOrScriptIdGenerator = 1L;
    private long m_documentIdGenerator = 0x100000000L;
    private Hashtable m_langcells;
    private Hashtable m_documents;
    private ObjectServer m_server;

    public BSFDebugManagerImpl() throws RemoteException {
        super(104, 8);
        self = this;
        this.m_langcells = new Hashtable();
        this.m_documents = new Hashtable();
        Integer n = Integer.getInteger("org.apache.bsf.serverPort", -1);
        this.m_server = new ObjectServer(this, n);
    }

    public void revokedNotify(RemoteService remoteService) {
        Enumeration enumeration = this.m_langcells.elements();
        while (enumeration.hasMoreElements()) {
            LangCell langCell = (LangCell)enumeration.nextElement();
            DebugLog.stderrPrintln("Disconnecting the debugger", 1);
            langCell.disconnectDebugger();
            DebugLog.stderrPrintln("Debugger disconnected.", 1);
        }
        DebugLog.stderrPrintln("Dropping all breakpoints...", 1);
        this.removeAllBreakpoints();
        DebugLog.stderrPrintln("All breakpoints dropped.", 1);
    }

    public void finalize() {
        this.terminate();
    }

    long generateDocumentId() {
        long l = this.m_documentIdGenerator;
        this.m_documentIdGenerator += 0x100000000L;
        return l;
    }

    public String getLangFromFilename(String string) throws RemoteException {
        try {
            return BSFManager.getLangFromFilename(string);
        }
        catch (BSFException bSFException) {
            return null;
        }
    }

    public boolean isLanguageRegistered(String string) {
        return BSFManager.isLanguageRegistered(string);
    }

    public boolean supportBreakpointAtOffset(String string) throws RemoteException {
        return false;
    }

    public boolean supportBreakpointAtLine(String string) throws RemoteException {
        return true;
    }

    public synchronized void placeBreakpointAtLine(int n, String string, int n2) throws RemoteException {
        DebugLog.stdoutPrintln("Placing breakpoint in " + string + " at " + n2, 1);
        DocumentCell documentCell = this.getDocumentCell(string);
        documentCell.addBreakpointAtLine(n, n2);
    }

    public synchronized void placeBreakpointAtOffset(int n, String string, int n2) throws RemoteException {
        DocumentCell documentCell = this.getDocumentCell(string);
        documentCell.addBreakpointAtOffset(n, n2);
    }

    public synchronized void removeBreakpoint(String string, int n) throws RemoteException {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        if (documentCell != null) {
            documentCell.removeBreakpoint(n);
        }
    }

    public synchronized void setEntryExit(String string, boolean bl) throws RemoteException {
        DocumentCell documentCell = this.getDocumentCell(string);
        if (documentCell != null) {
            documentCell.setEntryExit(bl);
        }
    }

    public synchronized void removeAllBreakpoints() {
        Enumeration enumeration = this.m_documents.elements();
        while (enumeration.hasMoreElements()) {
            DocumentCell documentCell = (DocumentCell)enumeration.nextElement();
            documentCell.removeAllBreakpoints();
        }
    }

    public synchronized void registerDebugger(String string, BSFDebugger bSFDebugger) throws RemoteException {
        DebugLog.stdoutPrintln("Registering debugger for " + string, 1);
        try {
            LangCell langCell = (LangCell)this.m_langcells.get(string);
            if (langCell == null) {
                langCell = new LangCell(string);
                this.m_langcells.put(string, langCell);
            } else {
                langCell.disconnectDebugger();
            }
            langCell.setDebugger(bSFDebugger);
            bSFDebugger.addListener(this);
        }
        catch (Exception exception) {
            DebugLog.stdoutPrintln("Error:", 0);
            DebugLog.stdoutPrintln(exception.getMessage(), 0);
            exception.printStackTrace(DebugLog.getDebugStream());
        }
    }

    public synchronized DocumentCell loadDocumentNotify(BSFEngine bSFEngine, String string) {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        if (documentCell == null) {
            documentCell = new DocumentCell(this, string);
            this.m_documents.put(string, documentCell);
        }
        documentCell.loadNotify(bSFEngine);
        return documentCell;
    }

    synchronized DocumentCell getDocumentCell(String string) {
        DocumentCell documentCell = (DocumentCell)this.m_documents.get(string);
        if (documentCell == null) {
            documentCell = new DocumentCell(this, string);
            this.m_documents.put(string, documentCell);
        }
        return documentCell;
    }

    public synchronized void registerEngine(BSFManager bSFManager, BSFEngine bSFEngine, String string) {
        LangCell langCell = (LangCell)this.m_langcells.get(string);
        if (langCell == null) {
            langCell = new LangCell(string);
            this.m_langcells.put(string, langCell);
        }
        langCell.addEngine(bSFEngine);
    }

    public synchronized void registerManager(BSFManager bSFManager) {
    }

    public synchronized void terminateManagerNotify(BSFManager bSFManager) {
    }

    public void terminate() {
        Enumeration enumeration = this.m_langcells.elements();
        while (enumeration.hasMoreElements()) {
            LangCell langCell = (LangCell)enumeration.nextElement();
            langCell.terminateNotify();
        }
        this.m_langcells = new Hashtable();
    }

    public synchronized void unregisterDebugger(String string) throws RemoteException {
        LangCell langCell = (LangCell)this.m_langcells.get(string);
        if (langCell == null) {
            return;
        }
        langCell.disconnectDebugger();
    }

    public synchronized void terminateEngineNotify(BSFManager bSFManager, BSFEngine bSFEngine, String string) {
        LangCell langCell = (LangCell)this.m_langcells.get(string);
        if (langCell == null) {
            return;
        }
        langCell.removeEngine(bSFEngine);
        Enumeration enumeration = this.m_documents.elements();
        while (enumeration.hasMoreElements()) {
            DocumentCell documentCell = (DocumentCell)enumeration.nextElement();
            documentCell.terminateEngineNotify(bSFEngine);
        }
    }
}

