/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

public class DataType {
    public static final byte _undefined = 0;
    public static final byte _byte = 1;
    public static final byte _short = 2;
    public static final byte _int = 3;
    public static final byte _long = 4;
    public static final byte _float = 5;
    public static final byte _double = 6;
    public static final byte _boolean = 7;
    public static final byte _char = 8;
    public static final byte _void = 9;
    public static final byte _reference = 10;
    public static final byte _string = 20;

    public static final boolean isPrimitiveType(String string) {
        if (string.startsWith("L")) {
            return false;
        }
        return !string.startsWith("[");
    }

    public static final boolean isBooleanType(String string) {
        return string.equals("Z");
    }

    public static final boolean isArrayType(String string) {
        return string.startsWith("[");
    }

    public static final int getSize(String string) {
        if (DataType.getType(string) == 3) {
            return 2;
        }
        return 1;
    }

    public static final int getType(String string) {
        if (string.startsWith("L")) {
            return 10;
        }
        if (string.startsWith("[")) {
            return 10;
        }
        if (string.equals("B")) {
            return 1;
        }
        if (string.equals("S")) {
            return 2;
        }
        if (string.equals("I")) {
            return 3;
        }
        if (string.equals("J")) {
            return 4;
        }
        if (string.equals("F")) {
            return 5;
        }
        if (string.equals("D")) {
            return 6;
        }
        if (string.equals("Z")) {
            return 1;
        }
        if (string.equals("C")) {
            return 8;
        }
        if (string.equals("V")) {
            return 9;
        }
        return 0;
    }

    public static final String getTypeString(String string) {
        if (string.startsWith("L")) {
            return "reference";
        }
        if (string.startsWith("[")) {
            return "reference";
        }
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.equals("V")) {
            return "void";
        }
        return "undefined";
    }

    public static final int getType(int n) {
        if (n < 128 && n >= -128) {
            return 1;
        }
        if (n < 32768 && n >= Short.MIN_VALUE) {
            return 2;
        }
        return 3;
    }

    public static final boolean isMultiDimensionArray(String string) {
        return string.startsWith("[[");
    }
}

