/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class NativeWith
implements Scriptable,
IdFunctionMaster {
    private static final int Id_constructor = 1;
    private Scriptable prototype;
    private Scriptable parent;
    private Scriptable constructor;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeWith obj = new NativeWith();
        obj.prototypeFlag = true;
        IdFunction ctor = new IdFunction(obj, "constructor", 1);
        ctor.initAsConstructor(scope, obj);
        if (sealed) {
            ctor.sealObject();
        }
        obj.setParentScope(ctor);
        obj.setPrototype(ScriptableObject.getObjectPrototype(scope));
        ScriptableObject.defineProperty(scope, "With", ctor, 2);
    }

    private NativeWith() {
    }

    NativeWith(Scriptable parent, Scriptable prototype) {
        this.parent = parent;
        this.prototype = prototype;
    }

    public String getClassName() {
        return "With";
    }

    public boolean has(String id, Scriptable start) {
        if (start == this) {
            start = this.prototype;
        }
        return this.prototype.has(id, start);
    }

    public boolean has(int index, Scriptable start) {
        if (start == this) {
            start = this.prototype;
        }
        return this.prototype.has(index, start);
    }

    public Object get(String id, Scriptable start) {
        if (start == this) {
            start = this.prototype;
        }
        return this.prototype.get(id, start);
    }

    public Object get(int index, Scriptable start) {
        if (start == this) {
            start = this.prototype;
        }
        return this.prototype.get(index, start);
    }

    public void put(String id, Scriptable start, Object value) {
        if (start == this) {
            start = this.prototype;
        }
        this.prototype.put(id, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        if (start == this) {
            start = this.prototype;
        }
        this.prototype.put(index, start, value);
    }

    public void delete(String id) {
        this.prototype.delete(id);
    }

    public void delete(int index) {
        this.prototype.delete(index);
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public Object[] getIds() {
        return this.prototype.getIds();
    }

    public Object getDefaultValue(Class typeHint) {
        return this.prototype.getDefaultValue(typeHint);
    }

    public boolean hasInstance(Scriptable value) {
        return this.prototype.hasInstance(value);
    }

    public Object execMethod(int methodId, IdFunction function, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag && methodId == 1) {
            throw Context.reportRuntimeError1("msg.cant.call.indirect", "With");
        }
        throw IdFunction.onBadMethodId(this, methodId);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag && methodId == 1) {
            return 0;
        }
        return -1;
    }

    static boolean isWithFunction(Object functionObj) {
        if (functionObj instanceof IdFunction) {
            IdFunction function = (IdFunction)functionObj;
            if (function.master instanceof NativeWith && function.getMethodId() == 1) {
                return true;
            }
        }
        return false;
    }

    static Object newWithSpecial(Context cx, Scriptable scope, Object[] args) {
        ScriptRuntime.checkDeprecated(cx, "With");
        scope = ScriptableObject.getTopLevelScope(scope);
        NativeWith thisObj = new NativeWith();
        thisObj.setPrototype(args.length == 0 ? ScriptableObject.getClassPrototype(scope, "Object") : ScriptRuntime.toObject(cx, scope, args[0]));
        thisObj.setParentScope(scope);
        return thisObj;
    }
}

