/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.lucene.core;

import com.knowledgetree.lucene.KTLuceneServer;
import com.knowledgetree.lucene.core.QueryHit;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.TokenGroup;

public class IndexerManager
implements Formatter {
    public static final String KnowledgeTreeLoggingProperties = "KnowledgeTreeIndexer.Logging.properties";
    private static IndexerManager indexingManager;
    private IndexReader queryReader;
    private Searcher querySearcher;
    private Analyzer analyzer;
    private ReentrantReadWriteLock locker;
    private Logger logger = Logger.getLogger("com.knowledgetree");
    private String indexDirectory = "c:/kt/ktlucene/indexes";
    private String propertiesFilename = "KnowledgeTreeIndexer.properties";
    private int port = 8875;
    private String clientIps = "127.0.0.1,192.168.1.1";
    private boolean paranoid = true;
    private int maxQueryResult = 100;
    private Date startDate;
    private int documentsAddCount = 0;
    private int documentsDeleteCount = 0;
    private int queryCount = 0;
    private int optimiseCount = 0;
    private int resultFragments = 3;
    private String resultSeperator = "...";
    private int resultFragmentSize = 40;
    private String authenticationToken = "";
    static final char[] numc;
    static final char[] alphac;

    public int getPort() {
        return this.port;
    }

    public boolean isParanoid() {
        return this.paranoid;
    }

    public String[] getAcceptableIps() {
        return this.clientIps.split(",");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean authenticate(String string) {
        return this.authenticationToken.equals(string);
    }

    public static IndexerManager get() throws Exception {
        if (null == indexingManager) {
            indexingManager = new IndexerManager();
        }
        return indexingManager;
    }

    public String getStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.queryReader.numDocs();
        stringBuilder.append('{').append("\"dateStarted\":\"").append(this.startDate).append("\",").append("\"dateNow\":\"").append(new Date()).append("\",").append("\"indexDirectory\":\"").append(this.indexDirectory).append("\",").append("\"clientIpAddrs\":\"").append(this.clientIps).append("\",").append("\"queryResultMax\":").append(this.maxQueryResult).append(",").append("\"countAdded\":").append(this.documentsAddCount).append(",").append("\"countDeleted\":").append(this.documentsDeleteCount).append(",").append("\"countOptimised\":").append(this.optimiseCount).append(",").append("\"countQuery\":").append(this.queryCount).append(",").append("\"countDocuments\":").append(n).append('}');
        return stringBuilder.toString();
    }

    private IndexerManager() throws Exception {
        Object object;
        this.logger.info("Indexing Server starting up...");
        this.analyzer = new StandardAnalyzer();
        this.locker = new ReentrantReadWriteLock();
        this.startDate = new Date();
        this.logger.info("Loading properties file: " + this.propertiesFilename);
        Properties properties = new Properties();
        try {
            object = new FileInputStream(this.propertiesFilename);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            this.logger.error("Problem loading properties: " + exception.getMessage());
            throw exception;
        }
        this.indexDirectory = properties.getProperty("indexer.directory", this.indexDirectory);
        this.logger.info("Using index directory: " + this.indexDirectory);
        object = new File(this.indexDirectory);
        if (!((File)object).isDirectory()) {
            throw new Exception("Invalid index directory specified: " + this.indexDirectory);
        }
        if (!((File)object).canWrite() || !((File)object).canRead()) {
            throw new Exception("Index directory must be read and writable: " + this.indexDirectory);
        }
        this.port = Integer.parseInt(properties.getProperty("server.port", Integer.toString(this.port)));
        this.paranoid = Boolean.parseBoolean(properties.getProperty("server.paranoid", Boolean.toString(this.paranoid)));
        this.clientIps = properties.getProperty("server.accept", this.clientIps);
        this.maxQueryResult = Integer.parseInt(properties.getProperty("query.max.results", Integer.toString(this.maxQueryResult)));
        this.resultFragments = Integer.parseInt(properties.getProperty("result.fragments", Integer.toString(this.resultFragments)));
        this.resultSeperator = properties.getProperty("result.fragment.seperator", this.resultSeperator);
        this.resultFragmentSize = Integer.parseInt(properties.getProperty("result.fragment.size", Integer.toString(this.resultFragmentSize)));
        this.authenticationToken = properties.getProperty("auth.token", this.authenticationToken);
        this.logger.info("Starting: " + this.startDate);
        this.logger.info("Client IPs: " + this.clientIps);
        this.logger.info("Max query result: " + this.maxQueryResult);
        this.logger.info("Result fragments: " + this.resultFragments);
        this.logger.info("Result fragment seperator: " + this.resultSeperator);
        this.logger.info("Result fragment size: " + this.resultFragmentSize);
        try {
            this.reopenIndex();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = fileNotFoundException.getMessage();
            if (string.indexOf("no segments* file found") == 0) {
                this.logger.info("Suspect that this is first time that indexing is run. Will attempt to create segments in " + this.indexDirectory);
                this.create();
                this.reopenIndex();
            }
            throw fileNotFoundException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopenIndex() throws Exception {
        this.logger.debug("Reopenning index");
        ReentrantReadWriteLock.WriteLock writeLock = this.locker.writeLock();
        writeLock.lock();
        try {
            if (null != this.queryReader) {
                this.querySearcher.close();
                this.queryReader.close();
            }
            this.queryReader = IndexReader.open(this.indexDirectory);
            this.querySearcher = new IndexSearcher(this.queryReader);
            this.logger.debug("Timestamp: " + new Date());
            this.logger.debug("Documents in index: " + this.queryReader.numDocs());
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String longToString(long l) {
        String string = Long.toString(l);
        for (int i = 0; i < 10; ++i) {
            string = string.replace(numc[i], alphac[i]);
        }
        return string;
    }

    public static long stringToLong(String string) {
        for (int i = 0; i < 10; ++i) {
            string = string.replace(alphac[i], numc[i]);
        }
        return Long.parseLong(string);
    }

    public boolean documentExists(int n) throws IOException {
        QueryParser queryParser = new QueryParser("Content", this.analyzer);
        ReentrantReadWriteLock.ReadLock readLock = this.locker.readLock();
        readLock.lock();
        try {
            Query query = queryParser.parse("documentid:" + IndexerManager.longToString(n));
            Hits hits = this.querySearcher.search(query);
            boolean bl = hits.length() > 0;
            this.logger.debug("Checking document exists documentId=" + n + " result=" + bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (ParseException parseException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDocument(int n) throws Exception {
        Object object = this;
        synchronized (object) {
            ++this.documentsDeleteCount;
        }
        this.logger.debug("Deleting document: " + n);
        object = IndexReader.open(this.indexDirectory);
        int n2 = ((IndexReader)object).deleteDocuments(new Term("DocumentID", IndexerManager.longToString(n)));
        ((IndexReader)object).close();
        this.logger.debug("Deleted " + n2 + " documents.");
        this.reopenIndex();
    }

    public void create() throws Exception {
        IndexWriter indexWriter = new IndexWriter(this.indexDirectory, this.analyzer, true);
        indexWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimise() throws Exception {
        Object object = this;
        synchronized (object) {
            ++this.optimiseCount;
        }
        this.logger.debug("Optimise index");
        object = this.locker.writeLock();
        ((ReentrantReadWriteLock.WriteLock)object).lock();
        try {
            if (null != this.queryReader) {
                this.querySearcher.close();
                this.queryReader.close();
            }
            IndexWriter indexWriter = new IndexWriter(this.indexDirectory, this.analyzer, false);
            indexWriter.optimize();
            indexWriter.close();
            this.queryReader = IndexReader.open(this.indexDirectory);
            this.querySearcher = new IndexSearcher(this.queryReader);
        }
        finally {
            ((ReentrantReadWriteLock.WriteLock)object).unlock();
        }
    }

    public QueryHit[] query(String string) throws Exception {
        return this.query(string, this.maxQueryResult, false);
    }

    public QueryHit[] query(String string, boolean bl) throws Exception {
        return this.query(string, this.maxQueryResult, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHit[] query(String string, int n, boolean bl) throws Exception {
        int n2;
        Object object = this;
        synchronized (object) {
            ++this.queryCount;
        }
        object = string.toLowerCase();
        boolean bl2 = ((String)object).indexOf("content") != -1;
        boolean bl3 = ((String)object).indexOf("discussion") != -1;
        QueryParser queryParser = new QueryParser("Content", this.analyzer);
        Query query = queryParser.parse(string);
        query = query.rewrite(this.queryReader);
        Hits hits = this.querySearcher.search(query);
        int n3 = n2 = n == -1 ? hits.length() : n;
        if (hits.length() < n2) {
            n2 = hits.length();
        }
        QueryHit[] queryHitArray = new QueryHit[n2];
        Highlighter highlighter = new Highlighter(this, new QueryScorer(query));
        highlighter.setTextFragmenter(new SimpleFragmenter(this.resultFragmentSize));
        for (int i = 0; i < hits.length(); ++i) {
            Document document = hits.doc(i);
            QueryHit queryHit = new QueryHit();
            queryHit.DocumentID = IndexerManager.stringToLong(document.get("DocumentID"));
            queryHit.Rank = hits.score(i);
            queryHit.Title = document.get("Title");
            if (bl) {
                String string2 = "";
                if (bl2) {
                    string2 = string2 + document.get("Content");
                }
                if (bl3) {
                    string2 = string2 + document.get("Discussion");
                }
                TokenStream tokenStream = this.analyzer.tokenStream("contents", new StringReader(string2));
                queryHit.Content = highlighter.getBestFragments(tokenStream, string2, this.resultFragments, this.resultSeperator);
            } else {
                queryHit.Content = "";
            }
            queryHit.Version = document.get("Version");
            queryHitArray[i] = queryHit;
        }
        return queryHitArray;
    }

    public String getText(int n) throws Exception {
        QueryHit[] queryHitArray = this.query("DocumentID:" + IndexerManager.longToString(n), true);
        return QueryHit.toJSON(queryHitArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocument(int n, String string, String string2, String string3, String string4) throws Exception {
        Object object = this;
        synchronized (object) {
            ++this.documentsAddCount;
        }
        this.logger.debug("Indexing document: documentid=" + n);
        this.deleteDocument(n);
        object = new File(string);
        long l = ((File)object).length();
        byte[] byArray = new byte[(int)l];
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        dataInputStream.read(byArray, 0, (int)l);
        dataInputStream.close();
        String string5 = new String(byArray, "UTF-8");
        this.addLuceneDocument(n, string5, string2, string3, string4);
        ((File)object).delete();
    }

    private void addLuceneDocument(int n, String string, String string2, String string3, String string4) throws Exception {
        Document document = new Document();
        document.add(new Field("DocumentID", IndexerManager.longToString(n), Field.Store.YES, Field.Index.UN_TOKENIZED));
        document.add(new Field("Content", string, Field.Store.YES, Field.Index.TOKENIZED));
        document.add(new Field("Discussion", string2, Field.Store.YES, Field.Index.TOKENIZED));
        document.add(new Field("Title", string3, Field.Store.YES, Field.Index.TOKENIZED));
        document.add(new Field("Version", string4, Field.Store.YES, Field.Index.UN_TOKENIZED));
        try {
            this.logger.debug("Opening index writer: documentid=" + n);
            IndexWriter indexWriter = new IndexWriter(this.indexDirectory, this.analyzer, false);
            indexWriter.addDocument(document);
            indexWriter.close();
            this.logger.debug("Closing index writer: documentid=" + n);
        }
        catch (IOException iOException) {
            this.logger.error("Problem indexing document: documentid=" + n + " with exception: " + iOException.getMessage());
        }
        this.reopenIndex();
    }

    public void updateDiscussion(int n, String string) throws Exception {
        block0: {
            this.logger.debug("updateDiscussion: documentid=" + n);
            QueryParser queryParser = new QueryParser("Content", this.analyzer);
            Query query = queryParser.parse("DocumentID: " + IndexerManager.longToString(n));
            Hits hits = this.querySearcher.search(query);
            int n2 = 0;
            if (n2 >= hits.length()) break block0;
            Document document = hits.doc(n2);
            String string2 = document.get("Content");
            String string3 = document.get("Title");
            String string4 = document.get("Version");
            this.deleteDocument(n);
            this.addLuceneDocument(n, string2, string, string3, string4);
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down...");
        KTLuceneServer.webServer.shutdown();
    }

    public String highlightTerm(String string, TokenGroup tokenGroup) {
        if (tokenGroup.getTotalScore() <= 0.0f) {
            return string;
        }
        return "<b>" + string + "</b>";
    }

    static {
        numc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        alphac = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
    }
}

