/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class Secmod {
    private static final boolean DEBUG = false;
    private static final Secmod INSTANCE;
    private static final String NSS_LIB_NAME = "nss3";
    private static final String SOFTTOKEN_LIB_NAME = "softokn3";
    private static final String TRUST_LIB_NAME = "nssckbi";
    private long nssHandle;
    private boolean supported;
    private List<Module> modules;
    private String configDir;
    private String nssLibDir;
    static final String TEMPLATE_EXTERNAL = "library = %s\nname = \"%s\"\nslotListIndex = %d\n";
    static final String TEMPLATE_TRUSTANCHOR = "library = %s\nname = \"NSS Trust Anchors\"\nslotListIndex = 0\nenabledMechanisms = { KeyStore }\nnssUseSecmodTrust = true\n";
    static final String TEMPLATE_CRYPTO = "library = %s\nname = \"NSS SoftToken Crypto\"\nslotListIndex = 0\ndisabledMechanisms = { KeyStore }\n";
    static final String TEMPLATE_KEYSTORE = "library = %s\nname = \"NSS SoftToken KeyStore\"\nslotListIndex = 1\nnssUseSecmodTrust = true\n";
    static final String TEMPLATE_FIPS = "library = %s\nname = \"NSS FIPS SoftToken\"\nslotListIndex = 0\nnssUseSecmodTrust = true\n";

    private Secmod() {
    }

    public static Secmod getInstance() {
        return INSTANCE;
    }

    private boolean isLoaded() {
        if (this.nssHandle == 0L) {
            this.nssHandle = Secmod.nssGetLibraryHandle(System.mapLibraryName(NSS_LIB_NAME));
            if (this.nssHandle != 0L) {
                this.fetchVersions();
            }
        }
        return this.nssHandle != 0L;
    }

    private void fetchVersions() {
        this.supported = Secmod.nssVersionCheck(this.nssHandle, "3.7");
    }

    public synchronized boolean isInitialized() throws IOException {
        if (!this.isLoaded()) {
            return false;
        }
        if (!this.supported) {
            throw new IOException("An incompatible version of NSS is already loaded, 3.7 or later required");
        }
        return true;
    }

    String getConfigDir() {
        return this.configDir;
    }

    String getLibDir() {
        return this.nssLibDir;
    }

    public void initialize(String string, String string2) throws IOException {
        this.initialize(DbMode.READ_WRITE, string, string2);
    }

    public synchronized void initialize(DbMode dbMode, String string, String string2) throws IOException {
        File file;
        File file2;
        String string3;
        if (this.isInitialized()) {
            throw new IOException("NSS is already initialized");
        }
        if (dbMode == null) {
            throw new NullPointerException();
        }
        if (dbMode != DbMode.NO_DB && string == null) {
            throw new NullPointerException();
        }
        String string4 = System.mapLibraryName(NSS_LIB_NAME);
        if (string2 == null) {
            string3 = string4;
        } else {
            file2 = new File(string2);
            if (!file2.isDirectory()) {
                throw new IOException("nssLibDir must be a directory:" + string2);
            }
            file = new File(file2, string4);
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getPath());
            }
            string3 = file.getPath();
        }
        if (string != null) {
            file2 = new File(string);
            if (!file2.isDirectory()) {
                throw new IOException("configDir must be a directory: " + string);
            }
            file = new File(file2, "secmod.db");
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getPath());
            }
        }
        this.nssHandle = Secmod.nssLoadLibrary(string3);
        this.fetchVersions();
        if (!this.supported) {
            throw new IOException("The specified version of NSS is incompatible, 3.7 or later required");
        }
        boolean bl = Secmod.nssInit(dbMode.functionName, this.nssHandle, string);
        if (!bl) {
            throw new IOException("NSS initialization failed");
        }
        this.configDir = string;
        this.nssLibDir = string2;
    }

    public synchronized List<Module> getModules() {
        try {
            if (!this.isInitialized()) {
                throw new IllegalStateException("NSS not initialized");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        if (this.modules == null) {
            List list = (List)Secmod.nssGetModuleList(this.nssHandle, this.nssLibDir);
            this.modules = Collections.unmodifiableList(list);
        }
        return this.modules;
    }

    private static byte[] getDigest(X509Certificate x509Certificate, String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return messageDigest.digest(x509Certificate.getEncoded());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    boolean isTrusted(X509Certificate x509Certificate, TrustType trustType) {
        Bytes bytes = new Bytes(Secmod.getDigest(x509Certificate, "SHA-1"));
        TrustAttributes trustAttributes = this.getModuleTrust(ModuleType.KEYSTORE, bytes);
        if (trustAttributes == null && (trustAttributes = this.getModuleTrust(ModuleType.FIPS, bytes)) == null) {
            trustAttributes = this.getModuleTrust(ModuleType.TRUSTANCHOR, bytes);
        }
        return trustAttributes == null ? false : trustAttributes.isTrusted(trustType);
    }

    private TrustAttributes getModuleTrust(ModuleType moduleType, Bytes bytes) {
        Module module = this.getModule(moduleType);
        TrustAttributes trustAttributes = module == null ? null : module.getTrust(bytes);
        return trustAttributes;
    }

    public Module getModule(ModuleType moduleType) {
        for (Module module : this.getModules()) {
            if (module.getType() != moduleType) continue;
            return module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Bytes, TrustAttributes> getTrust(SunPKCS11 sunPKCS11) throws PKCS11Exception {
        HashMap<Bytes, TrustAttributes> hashMap = new HashMap<Bytes, TrustAttributes>();
        Token token = sunPKCS11.getToken();
        Session session = null;
        try {
            session = token.getOpSession();
            int n = 8192;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3461563219L)};
            token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
            long[] lArray = token.p11.C_FindObjects(session.id(), n);
            token.p11.C_FindObjectsFinal(session.id());
            for (long l : lArray) {
                TrustAttributes trustAttributes = new TrustAttributes(token, session, l);
                hashMap.put(trustAttributes.getHash(), trustAttributes);
            }
        }
        finally {
            token.releaseSession(session);
        }
        return hashMap;
    }

    private static native long nssGetLibraryHandle(String var0);

    private static native long nssLoadLibrary(String var0) throws IOException;

    private static native boolean nssVersionCheck(long var0, String var2);

    private static native boolean nssInit(String var0, long var1, String var3);

    private static native Object nssGetModuleList(long var0, String var2);

    static {
        PKCS11.loadNative();
        INSTANCE = new Secmod();
    }

    private static class Bytes {
        final byte[] b;

        Bytes(byte[] byArray) {
            this.b = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.b);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Bytes)) {
                return false;
            }
            Bytes bytes = (Bytes)object;
            return Arrays.equals(this.b, bytes.b);
        }
    }

    static class TrustAttributes {
        final long handle;
        final long clientAuth;
        final long serverAuth;
        final long codeSigning;
        final long emailProtection;
        final byte[] shaHash;

        TrustAttributes(Token token, X509Certificate x509Certificate, Bytes bytes, long l) {
            Session session = null;
            try {
                session = token.getOpSession();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3461563219L), new CK_ATTRIBUTE(3461571416L, l), new CK_ATTRIBUTE(3461571418L, l), new CK_ATTRIBUTE(3461571419L, l), new CK_ATTRIBUTE(3461571417L, l), new CK_ATTRIBUTE(3461571508L, bytes.b), new CK_ATTRIBUTE(3461571509L, Secmod.getDigest(x509Certificate, "MD5")), new CK_ATTRIBUTE(129L, x509Certificate.getIssuerX500Principal().getEncoded()), new CK_ATTRIBUTE(130L, x509Certificate.getSerialNumber().toByteArray())};
                this.handle = token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
                this.shaHash = bytes.b;
                this.clientAuth = l;
                this.serverAuth = l;
                this.codeSigning = l;
                this.emailProtection = l;
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("Could not create trust object", pKCS11Exception);
            }
            finally {
                token.releaseSession(session);
            }
        }

        TrustAttributes(Token token, Session session, long l) throws PKCS11Exception {
            long l2;
            this.handle = l;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3461571416L), new CK_ATTRIBUTE(3461571418L), new CK_ATTRIBUTE(3461571419L), new CK_ATTRIBUTE(3461571508L)};
            token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            this.serverAuth = cK_ATTRIBUTEArray[0].getLong();
            this.codeSigning = cK_ATTRIBUTEArray[1].getLong();
            this.emailProtection = cK_ATTRIBUTEArray[2].getLong();
            this.shaHash = cK_ATTRIBUTEArray[3].getByteArray();
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3461571417L)};
            try {
                token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
                l2 = cK_ATTRIBUTEArray[0].getLong();
            }
            catch (PKCS11Exception pKCS11Exception) {
                l2 = this.serverAuth;
            }
            this.clientAuth = l2;
        }

        Bytes getHash() {
            return new Bytes(this.shaHash);
        }

        boolean isTrusted(TrustType trustType) {
            switch (trustType) {
                case CLIENT_AUTH: {
                    return this.isTrusted(this.clientAuth);
                }
                case SERVER_AUTH: {
                    return this.isTrusted(this.serverAuth);
                }
                case CODE_SIGNING: {
                    return this.isTrusted(this.codeSigning);
                }
                case EMAIL_PROTECTION: {
                    return this.isTrusted(this.emailProtection);
                }
                case ALL: {
                    return this.isTrusted(TrustType.CLIENT_AUTH) && this.isTrusted(TrustType.SERVER_AUTH) && this.isTrusted(TrustType.CODE_SIGNING) && this.isTrusted(TrustType.EMAIL_PROTECTION);
                }
            }
            return false;
        }

        private boolean isTrusted(long l) {
            return l == 3461563218L;
        }
    }

    public static final class KeyStoreLoadParameter
    implements KeyStore.LoadStoreParameter {
        final TrustType trustType;
        final KeyStore.ProtectionParameter protection;

        public KeyStoreLoadParameter(TrustType trustType, char[] cArray) {
            this(trustType, new KeyStore.PasswordProtection(cArray));
        }

        public KeyStoreLoadParameter(TrustType trustType, KeyStore.ProtectionParameter protectionParameter) {
            if (trustType == null) {
                throw new NullPointerException("trustType must not be null");
            }
            this.trustType = trustType;
            this.protection = protectionParameter;
        }

        @Override
        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }

        public TrustType getTrustType() {
            return this.trustType;
        }
    }

    public static enum DbMode {
        READ_WRITE("NSS_InitReadWrite"),
        READ_ONLY("NSS_Init"),
        NO_DB("NSS_NoDB_Init");

        final String functionName;

        private DbMode(String string2) {
            this.functionName = string2;
        }
    }

    public static enum TrustType {
        ALL,
        CLIENT_AUTH,
        SERVER_AUTH,
        CODE_SIGNING,
        EMAIL_PROTECTION;

    }

    public static final class Module {
        final String libraryName;
        final String commonName;
        final int slot;
        final ModuleType type;
        private String config;
        private SunPKCS11 provider;
        private Map<Bytes, TrustAttributes> trust;

        Module(String string, String string2, String string3, boolean bl, int n) {
            ModuleType moduleType;
            if (string2 == null || string2.length() == 0) {
                string2 = System.mapLibraryName(Secmod.SOFTTOKEN_LIB_NAME);
                if (!bl) {
                    moduleType = n == 0 ? ModuleType.CRYPTO : ModuleType.KEYSTORE;
                } else {
                    moduleType = ModuleType.FIPS;
                    if (n != 0) {
                        throw new RuntimeException("Slot index should be 0 for FIPS slot");
                    }
                }
            } else {
                moduleType = string2.endsWith(System.mapLibraryName(Secmod.TRUST_LIB_NAME)) || string3.equals("Builtin Roots Module") ? ModuleType.TRUSTANCHOR : ModuleType.EXTERNAL;
                if (bl) {
                    throw new RuntimeException("FIPS flag set for non-internal module: " + string2 + ", " + string3);
                }
            }
            this.libraryName = new File(string, string2).getPath();
            this.commonName = string3;
            this.slot = n;
            this.type = moduleType;
            this.initConfiguration();
        }

        private void initConfiguration() {
            switch (this.type) {
                case EXTERNAL: {
                    this.config = String.format(Secmod.TEMPLATE_EXTERNAL, this.libraryName, this.commonName + " " + this.slot, this.slot);
                    break;
                }
                case CRYPTO: {
                    this.config = String.format(Secmod.TEMPLATE_CRYPTO, this.libraryName);
                    break;
                }
                case KEYSTORE: {
                    this.config = String.format(Secmod.TEMPLATE_KEYSTORE, this.libraryName);
                    break;
                }
                case FIPS: {
                    this.config = String.format(Secmod.TEMPLATE_FIPS, this.libraryName);
                    break;
                }
                case TRUSTANCHOR: {
                    this.config = String.format(Secmod.TEMPLATE_TRUSTANCHOR, this.libraryName);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown module type: " + (Object)((Object)this.type));
                }
            }
        }

        @Deprecated
        public synchronized String getConfiguration() {
            return this.config;
        }

        @Deprecated
        public synchronized void setConfiguration(String string) {
            if (this.provider != null) {
                throw new IllegalStateException("Provider instance already created");
            }
            this.config = string;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public ModuleType getType() {
            return this.type;
        }

        @Deprecated
        public synchronized Provider getProvider() {
            if (this.provider == null) {
                this.provider = this.newProvider();
            }
            return this.provider;
        }

        synchronized boolean hasInitializedProvider() {
            return this.provider != null;
        }

        void setProvider(SunPKCS11 sunPKCS11) {
            if (this.provider != null) {
                throw new ProviderException("Secmod provider already initialized");
            }
            this.provider = sunPKCS11;
        }

        private SunPKCS11 newProvider() {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.config.getBytes("UTF8"));
                return new SunPKCS11(byteArrayInputStream);
            }
            catch (Exception exception) {
                throw new ProviderException(exception);
            }
        }

        synchronized void setTrust(Token token, X509Certificate x509Certificate) {
            Bytes bytes = new Bytes(Secmod.getDigest(x509Certificate, "SHA-1"));
            TrustAttributes trustAttributes = this.getTrust(bytes);
            if (trustAttributes == null) {
                trustAttributes = new TrustAttributes(token, x509Certificate, bytes, 3461563218L);
                this.trust.put(bytes, trustAttributes);
            } else if (!trustAttributes.isTrusted(TrustType.ALL)) {
                throw new ProviderException("Cannot change existing trust attributes");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TrustAttributes getTrust(Bytes bytes) {
            if (this.trust == null) {
                Module module = this;
                synchronized (module) {
                    SunPKCS11 sunPKCS11 = this.provider;
                    if (sunPKCS11 == null) {
                        sunPKCS11 = this.newProvider();
                    }
                    try {
                        this.trust = Secmod.getTrust(sunPKCS11);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        throw new RuntimeException(pKCS11Exception);
                    }
                }
            }
            return this.trust.get(bytes);
        }

        public String toString() {
            return this.commonName + " (" + (Object)((Object)this.type) + ", " + this.libraryName + ", slot " + this.slot + ")";
        }
    }

    public static enum ModuleType {
        CRYPTO,
        KEYSTORE,
        FIPS,
        TRUSTANCHOR,
        EXTERNAL;

    }
}

