/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspection;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerializationMethodsInspection
extends SerializableInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (!hasReadObject && !hasWriteObject) {
            string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        if (hasReadObject) {
            string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor1", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor2", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerializationMethodsVisitor();
    }

    private class SerializableHasSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/SerializableHasSerializationMethodsInspection$SerializableHasSerializationMethodsVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject && hasReadObject) {
                return;
            }
            if (SerializableHasSerializationMethodsInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }
    }
}

