/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class ContainsAssertionVisitor
extends JavaRecursiveElementVisitor {
    private boolean containsAssertion = false;

    ContainsAssertionVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/ContainsAssertionVisitor.visitElement must not be null");
        }
        if (!this.containsAssertion) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/ContainsAssertionVisitor.visitMethodCallExpression must not be null");
        }
        if (this.containsAssertion) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName == null) {
            return;
        }
        if (methodName.startsWith("assert") || methodName.startsWith("fail")) {
            this.containsAssertion = true;
        }
    }

    public boolean containsAssertion() {
        return this.containsAssertion;
    }
}

