/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsFieldAccessReplaceableByMethodCallInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/CollectionsFieldAccessReplaceableByMethodCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.problem.descriptor", infos[1]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/CollectionsFieldAccessReplaceableByMethodCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression expression = (PsiReferenceExpression)infos[0];
        return new CollectionsFieldAccessReplaceableByMethodCallFix(expression.getReferenceName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionsFieldAccessReplaceableByMethodCallVisitor();
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallVisitor
    extends BaseInspectionVisitor {
        private CollectionsFieldAccessReplaceableByMethodCallVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            String replacement;
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return;
            }
            super.visitReferenceExpression(expression);
            String name = expression.getReferenceName();
            if ("EMPTY_LIST".equals(name)) {
                replacement = "emptyList()";
            } else if ("EMPTY_MAP".equals(name)) {
                replacement = "emptyMap()";
            } else if ("EMPTY_SET".equals(name)) {
                replacement = "emptySet()";
            } else {
                return;
            }
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.util.Collections".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, replacement);
        }
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        private CollectionsFieldAccessReplaceableByMethodCallFix(String referenceName) {
            this.replacementText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.quickfix", this.replacementText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/CollectionsFieldAccessReplaceableByMethodCallInspection$CollectionsFieldAccessReplaceableByMethodCallFix.getName must not return null");
            }
            return string;
        }

        private static String getCollectionsMethodCallText(PsiReferenceExpression referenceExpression) {
            String referenceName = referenceExpression.getReferenceName();
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiType type = ExpectedTypeUtils.findExpectedType((PsiExpression)referenceExpression, false);
            if (!(type instanceof PsiClassType)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiClassType classType = (PsiClassType)type;
            PsiType[] parameterTypes = classType.getParameters();
            boolean useTypeParameter = false;
            String[] canonicalTexts = new String[parameterTypes.length];
            for (PsiType parameterType : parameterTypes) {
                if (!parameterType.equalsToText("java.lang.Object")) {
                    useTypeParameter = true;
                }
                canonicalTexts[i] = parameterType.getCanonicalText();
            }
            if (useTypeParameter) {
                return "Collections.<" + StringUtil.join((String[])canonicalTexts, (String)",") + ">" + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
            }
            return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
        }

        private static String getUntypedCollectionsMethodCallText(String referenceName) {
            return "Collections." + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceName);
        }

        private static String getCollectionsMethodCallText(String referenceName) {
            if ("EMPTY_LIST".equals(referenceName)) {
                return "emptyList()";
            }
            if ("EMPTY_MAP".equals(referenceName)) {
                return "emptyMap()";
            }
            if ("EMPTY_SET".equals(referenceName)) {
                return "emptySet()";
            }
            throw new AssertionError((Object)("unknown collections field name: " + referenceName));
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newMethodCallText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceExpression);
            CollectionsFieldAccessReplaceableByMethodCallFix.replaceExpression((PsiExpression)referenceExpression, "java.util." + newMethodCallText);
        }
    }
}

