/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ReflectionForUnavailableAnnotationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReflectionForUnavailableAnnotationVisitor();
    }

    private static class ReflectionForUnavailableAnnotationVisitor
    extends BaseInspectionVisitor {
        private ReflectionForUnavailableAnnotationVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiNameValuePair[] attributes;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$ReflectionForUnavailableAnnotationVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isAnnotationPresent".equals(methodName) && !"getAnnotation".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (arg == null) {
                return;
            }
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiMethod calledMethod = expression.resolveMethod();
            if (calledMethod == null) {
                return;
            }
            PsiClass containingClass = calledMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!"java.lang.Class".equals(containingClass.getQualifiedName())) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)arg;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiClassType annotationClassType = (PsiClassType)operand.getType();
            PsiClass annotationClass = annotationClassType.resolve();
            if (annotationClass == null) {
                return;
            }
            PsiModifierList modifierList = annotationClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiAnnotation retentionAnnotation = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnnotation == null) {
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
            PsiAnnotationParameterList parameters = retentionAnnotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameters.getAttributes()) {
                PsiAnnotationMemberValue value;
                String text;
                String name = attribute.getName();
                if (name != null && !"value".equals(name) || (text = (value = attribute.getValue()).getText()).contains("RUNTIME")) continue;
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
        }
    }
}

