/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.bugs.Validator;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedFormatStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        Object value = infos[0];
        if (value instanceof Exception) {
            string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedFormatStringInspection.buildErrorString must not return null");
            return string;
        }
        Validator[] validators = (Validator[])value;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedFormatStringInspection.buildErrorString must not return null");
            return string;
        }
        if (validators.length > argumentCount) {
            string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedFormatStringInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedFormatStringInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private static class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Set<String> formatMethodNames = new HashSet<String>(2);
        private static final Set<String> formatClassNames = new HashSet<String>(4);

        private MalformedFormatStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            Validator[] validators;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MalformedFormatStringInspection$MalformedFormatStringVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType type = firstArgument.getType();
            if (type == null) {
                return;
            }
            int formatArgPosition = "java.util.Locale".equals(type.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
            PsiExpression formatArgument = arguments[formatArgPosition];
            if (!TypeUtils.expressionHasType("java.lang.String", formatArgument)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            String value = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)formatArgument, (PsiType)formatType);
            if (value == null) {
                return;
            }
            if (!MalformedFormatStringVisitor.callTakesFormatString(expression)) {
                return;
            }
            int argumentCount = arguments.length - (formatArgPosition + 1);
            try {
                validators = FormatDecode.decode(value, argumentCount);
            }
            catch (Exception e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (validators.length != argumentCount) {
                PsiExpression argument;
                PsiType argumentType;
                if (argumentCount == 1 && (argumentType = (argument = arguments[formatArgPosition + 1]).getType()) instanceof PsiArrayType) {
                    return;
                }
                this.registerError((PsiElement)formatArgument, validators, argumentCount);
                return;
            }
            for (int i = 0; i < validators.length; ++i) {
                Validator validator = validators[i];
                PsiType argType = arguments[i + formatArgPosition + 1].getType();
                if (validator.valid(argType)) continue;
                this.registerError((PsiElement)formatArgument, validators, argumentCount);
                return;
            }
        }

        private static boolean callTakesFormatString(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!formatMethodNames.contains(name)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            return formatClassNames.contains(className);
        }

        static {
            formatMethodNames.add("format");
            formatMethodNames.add("printf");
            formatClassNames.add("java.io.PrintWriter");
            formatClassNames.add("java.io.PrintStream");
            formatClassNames.add("java.util.Formatter");
            formatClassNames.add("java.lang.String");
        }
    }
}

