/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyFoldingBuilder
implements FoldingBuilder,
GroovyElementTypes,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder.buildFoldRegions must not be null");
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        this.appendDescriptors(node.getPsi(), document, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder.buildFoldRegions must not return null");
        }
        return foldingDescriptorArray;
    }

    private void appendDescriptors(PsiElement element, Document document, List<FoldingDescriptor> descriptors) {
        ASTNode node = element.getNode();
        if (node == null) {
            return;
        }
        IElementType type = node.getElementType();
        if ((BLOCK_SET.contains(type) || type == CLOSABLE_BLOCK) && GroovyFoldingBuilder.isMultiline(element)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        if ((type.equals(mML_COMMENT) || type.equals(GROOVY_DOC_COMMENT)) && GroovyFoldingBuilder.isMultiline(element) && this.isWellEndedComment(element)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.appendDescriptors(child, document, descriptors);
        }
        if (element instanceof GroovyFile) {
            GroovyFile file = (GroovyFile)element;
            GroovyFoldingBuilder.addFoldingsForImports(descriptors, file);
        }
    }

    private static void addFoldingsForImports(List<FoldingDescriptor> descriptors, GroovyFile file) {
        GrImportStatement[] statements = file.getImportStatements();
        if (statements.length > 1) {
            GrImportStatement first = statements[0];
            while (first != null) {
                GrImportStatement marker = first;
                PsiElement next = first.getNextSibling();
                while (next instanceof GrImportStatement || next instanceof LeafPsiElement) {
                    if (next instanceof GrImportStatement) {
                        marker = next;
                    }
                    next = next.getNextSibling();
                }
                if (marker != first) {
                    int start = first.getTextRange().getStartOffset();
                    int end = marker.getTextRange().getEndOffset();
                    int tail = "import ".length();
                    if (start + tail < end) {
                        descriptors.add(new FoldingDescriptor(first.getNode(), new TextRange(start + tail, end)));
                    }
                }
                while (!(next instanceof GrImportStatement) && next != null) {
                    next = next.getNextSibling();
                }
                first = next;
            }
        }
    }

    private boolean isWellEndedComment(PsiElement element) {
        PsiComment comment;
        ASTNode node;
        if (element instanceof PsiComment && (node = (comment = (PsiComment)element).getNode()) != null && node.getElementType() == GroovyTokenTypes.mML_COMMENT && node.getText().endsWith("*/")) {
            return true;
        }
        return true;
    }

    private static boolean isMultiline(PsiElement element) {
        String text = element.getText();
        return text.contains("\n") || text.contains("\r") || text.contains("\r\n");
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder.getPlaceholderText must not be null");
        }
        IElementType elemType = node.getElementType();
        if (BLOCK_SET.contains(elemType) || elemType == CLOSABLE_BLOCK) {
            return "{...}";
        }
        if (elemType.equals(mML_COMMENT)) {
            return "/*...*/";
        }
        if (elemType.equals(GROOVY_DOC_COMMENT)) {
            return "/**...*/";
        }
        if (((Object)((Object)IMPORT_STATEMENT)).equals(elemType)) {
            return "...";
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder.isCollapsedByDefault must not be null");
        }
        return node.getElementType() == IMPORT_STATEMENT && JavaCodeFoldingSettings.getInstance().isCollapseImports();
    }
}

