/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.editor.actions.GroovyEditorActionUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;

public abstract class GroovyIndentProcessor
implements GroovyElementTypes {
    public static final int GDOC_COMMENT_INDENT = 1;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Indent getChildIndent(@NotNull GroovyBlock parent, @Nullable ASTNode prevChildNode, @NotNull ASTNode child) {
        Indent indent;
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not be null");
        }
        ASTNode astNode = parent.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GroovyFileBase) {
            indent = Indent.getNoneIndent();
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (GroovyEditorActionUtil.GSTRING_TOKENS_INNER.contains(child.getElementType()) && mGSTRING_BEGIN != child.getElementType()) {
            indent = Indent.getAbsoluteNoneIndent();
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrListOrMap) {
            if (!(mLBRACK.equals(child.getElementType()) || mRBRACK.equals(child.getElementType()) ? (indent = Indent.getNoneIndent()) != null : (indent = Indent.getContinuationWithoutFirstIndent()) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (BLOCK_SET.contains(astNode.getElementType()) && !((Object)((Object)BLOCK_STATEMENT)).equals(astNode.getElementType())) {
            indent = GroovyIndentProcessor.indentForBlock(psiParent, child);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (((Object)((Object)CASE_SECTION)).equals(astNode.getElementType())) {
            indent = GroovyIndentProcessor.indentForCaseSection(psiParent, child);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (((Object)((Object)SWITCH_STATEMENT)).equals(astNode.getElementType())) {
            indent = GroovyIndentProcessor.indentForSwitchStatement(psiParent, child);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (child.getPsi() instanceof GrLabel) {
            indent = Indent.getLabelIndent();
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrControlStatement) {
            indent = GroovyIndentProcessor.getControlIndent(psiParent, child);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrExpression) {
            indent = GroovyIndentProcessor.getExpressionIndent(psiParent, child);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrParameterList || psiParent instanceof GrExtendsClause || psiParent instanceof GrThrowsClause) {
            if (!(parent.getIndent() != null ? (indent = Indent.getContinuationWithoutFirstIndent()) != null : (indent = Indent.getNoneIndent()) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrArgumentList && child.getElementType() != mLPAREN && child.getElementType() != mRPAREN) {
            indent = Indent.getContinuationIndent();
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        if (psiParent instanceof GrDocComment && child.getElementType() != mGDOC_COMMENT_START || psiParent instanceof GrDocTag && child.getElementType() != mGDOC_TAG_NAME) {
            indent = Indent.getSpaceIndent((int)1);
            if (indent == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
            return indent;
        }
        indent = Indent.getNoneIndent();
        if (indent != null) return indent;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor.getChildIndent must not return null");
    }

    private static Indent getExpressionIndent(PsiElement psiParent, ASTNode child) {
        if (psiParent instanceof GrAssignmentExpression && child.getPsi().equals(((GrAssignmentExpression)psiParent).getRValue())) {
            return Indent.getNormalIndent();
        }
        if (psiParent instanceof GrConditionalExpression && (child.getPsi().equals(((GrConditionalExpression)psiParent).getThenBranch()) || child.getPsi().equals(((GrConditionalExpression)psiParent).getElseBranch()))) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private static Indent getControlIndent(PsiElement parent, ASTNode child) {
        PsiElement psi = child.getPsi();
        IElementType type = child.getElementType();
        if (parent instanceof GrIfStatement) {
            GrIfStatement ifStatement = (GrIfStatement)parent;
            if (!BLOCK_SET.contains(type)) {
                if (psi.equals(ifStatement.getThenBranch())) {
                    return Indent.getNormalIndent();
                }
                if (psi.equals(ifStatement.getElseBranch())) {
                    if (CodeStyleSettingsManager.getSettings((Project)parent.getProject()).SPECIAL_ELSE_IF_TREATMENT && psi instanceof GrIfStatement) {
                        return Indent.getNoneIndent();
                    }
                    return Indent.getNormalIndent();
                }
            }
            if (psi.equals(ifStatement.getCondition())) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        if (parent instanceof GrWhileStatement) {
            if (psi.equals(((GrWhileStatement)parent).getBody()) && !BLOCK_SET.contains(type)) {
                return Indent.getNormalIndent();
            }
            if (psi.equals(((GrWhileStatement)parent).getCondition())) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        if (parent instanceof GrSynchronizedStatement && psi.equals(((GrSynchronizedStatement)parent).getMonitor())) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (parent instanceof GrForStatement) {
            if (psi.equals(((GrForStatement)parent).getBody()) && !BLOCK_SET.contains(type)) {
                return Indent.getNormalIndent();
            }
            if (psi.equals(((GrForStatement)parent).getClause())) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    private static Indent indentForBlock(PsiElement psiBlock, ASTNode child) {
        if (mLCURLY.equals(child.getElementType()) || mRCURLY.equals(child.getElementType())) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    private static Indent indentForCaseSection(PsiElement psiParent, ASTNode child) {
        if (((Object)((Object)CASE_LABEL)).equals(child.getElementType())) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    private static Indent indentForSwitchStatement(PsiElement psiParent, ASTNode child) {
        if (((Object)((Object)CASE_SECTION)).equals(child.getElementType()) && CodeStyleSettingsManager.getSettings((Project)psiParent.getProject()).INDENT_CASE_FROM_SWITCH) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }
}

