/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;

public class AppMain {
    private static final String PROPERTY_PORT_NUMBER = "idea.launcher.port";
    private static final String PROPERTY_BINPATH = "idea.launcher.bin.path";

    private static native void triggerControlBreak();

    public static void main(String[] args) throws Throwable {
        final int portNumber = Integer.getInteger(PROPERTY_PORT_NUMBER);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    ServerSocket socket = new ServerSocket(portNumber);
                    Socket client = socket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                    while (true) {
                        String msg;
                        if ("TERM".equals(msg = reader.readLine())) {
                            return;
                        }
                        if ("BREAK".equals(msg)) {
                            AppMain.triggerControlBreak();
                            continue;
                        }
                        if (!"STOP".equals(msg)) continue;
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    return;
                }
                catch (IllegalArgumentException iae) {
                    return;
                }
                catch (SecurityException se) {
                    return;
                }
            }
        }, "Monitor Ctrl-Break");
        try {
            t.setDaemon(true);
            t.start();
        }
        catch (Exception e) {
            // empty catch block
        }
        String mainClass = args[0];
        String[] parms = new String[args.length - 1];
        for (int j = 1; j < args.length; ++j) {
            parms[j - 1] = args[j];
        }
        Method m = Class.forName(mainClass).getMethod("main", parms.getClass());
        if (!Modifier.isStatic(m.getModifiers())) {
            System.err.println("main method should be static");
            return;
        }
        try {
            AppMain.ensureAccess(m);
            m.invoke(null, new Object[]{parms});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static void ensureAccess(Object reflectionObject) {
        Class<?> aClass = reflectionObject.getClass();
        try {
            Method setAccessibleMethod = aClass.getMethod("setAccessible", Boolean.TYPE);
            setAccessibleMethod.invoke(reflectionObject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String binPath = System.getProperty(PROPERTY_BINPATH) + File.separator;
        String osName = System.getProperty("os.name").toLowerCase();
        String libPath = null;
        if (osName.startsWith("windows")) {
            libPath = System.getProperty("os.arch").equals("amd64") ? binPath + "breakgen64.dll" : binPath + "breakgen.dll";
        } else if (osName.startsWith("linux")) {
            libPath = System.getProperty("os.arch").toLowerCase().equals("amd64") ? binPath + "libbreakgen64.so" : binPath + "libbreakgen.so";
        }
        try {
            if (libPath != null) {
                System.load(libPath);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

