/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.ThrowableConsumer;
import com.intellij.vcsUtil.ActionWithTempFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IgnoredFileInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.SelectIgnorePatternsToRemoveOnDeleteDialog;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnFileSystemListener
extends CommandAdapter
implements LocalFileOperationsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnFileSystemListener");
    private final LocalFileSystem myLfs;
    private final Map<Project, Map<String, IgnoredFileInfo>> myIgnoredInfo = new HashMap<Project, Map<String, IgnoredFileInfo>>();
    private final List<AddedFileInfo> myAddedFiles = new ArrayList<AddedFileInfo>();
    private final List<DeletedFileInfo> myDeletedFiles = new ArrayList<DeletedFileInfo>();
    private final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();
    private final Map<Project, List<VcsException>> myMoveExceptions = new HashMap<Project, List<VcsException>>();
    private final List<VirtualFile> myFilesToRefresh = new ArrayList<VirtualFile>();
    @Nullable
    private File myStorageForUndo;
    private final List<Pair<File, File>> myUndoStorageContents = new ArrayList<Pair<File, File>>();
    private boolean myUndoingMove = false;

    public SvnFileSystemListener() {
        this.myLfs = LocalFileSystem.getInstance();
    }

    private void addToMoveExceptions(Project project, SVNException e) {
        List<VcsException> exceptionList = this.myMoveExceptions.get(project);
        if (exceptionList == null) {
            exceptionList = new ArrayList<VcsException>();
            this.myMoveExceptions.put(project, exceptionList);
        }
        VcsException vcsException = SVNErrorCode.ENTRY_EXISTS.equals((Object)e.getErrorMessage().getErrorCode()) ? new VcsException(Arrays.asList("Target of move operation is already under version control.", "Subversion move had not been performed. ", e.getMessage())) : new VcsException((Throwable)e);
        exceptionList.add(vcsException);
    }

    @Nullable
    public File copy(VirtualFile file, VirtualFile toDir, String copyName) throws IOException {
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        if (vcs == null) {
            vcs = SvnFileSystemListener.getVCS(file);
        }
        if (vcs == null) {
            return null;
        }
        File srcFile = new File(file.getPath());
        File destFile = new File(new File(toDir.getPath()), copyName);
        boolean dstDirUnderControl = SVNWCUtil.isVersionedDirectory((File)destFile.getParentFile());
        if (!dstDirUnderControl && !this.isPendingAdd(toDir)) {
            return null;
        }
        if (!SVNWCUtil.isVersionedDirectory((File)srcFile.getParentFile())) {
            this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), toDir, copyName, null, false));
            return null;
        }
        SVNStatus fileStatus = SvnFileSystemListener.getFileStatus(vcs, srcFile);
        if (fileStatus != null && fileStatus.getContentsStatus() == SVNStatusType.STATUS_ADDED) {
            this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), toDir, copyName, null, false));
            return null;
        }
        if (this.sameRoot(vcs, file.getParent(), toDir)) {
            this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), toDir, copyName, srcFile, false));
            return null;
        }
        this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), toDir, copyName, null, false));
        return null;
    }

    private boolean sameRoot(SvnVcs vcs, VirtualFile srcDir, VirtualFile dstDir) {
        UUIDHelper helper = new UUIDHelper(vcs);
        String srcUUID = helper.getRepositoryUUID(srcDir);
        String dstUUID = helper.getRepositoryUUID(dstDir);
        return srcUUID != null && dstUUID != null && srcUUID.equals(dstUUID);
    }

    public boolean move(VirtualFile file, VirtualFile toDir) throws IOException {
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(SvnFileSystemListener.getIOFile(toDir), file.getName());
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        SvnVcs sourceVcs = SvnFileSystemListener.getVCS(file);
        if (vcs == null && sourceVcs == null) {
            return false;
        }
        if (vcs == null) {
            return false;
        }
        if (sourceVcs == null) {
            return this.createItem(toDir, file.getName(), file.isDirectory(), true);
        }
        if (this.isPendingAdd(toDir)) {
            this.myMovedFiles.add(new MovedFileInfo(sourceVcs.getProject(), srcFile, dstFile));
            return true;
        }
        VirtualFile oldParent = file.getParent();
        this.myFilesToRefresh.add(oldParent);
        this.myFilesToRefresh.add(toDir);
        return this.doMove(sourceVcs, srcFile, dstFile);
    }

    public boolean rename(VirtualFile file, String newName) throws IOException {
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(srcFile.getParentFile(), newName);
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null) {
            this.myFilesToRefresh.add(file.getParent());
            return this.doMove(vcs, srcFile, dstFile);
        }
        return false;
    }

    private boolean doMove(@NotNull SvnVcs vcs, File src, File dst) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnFileSystemListener.doMove must not be null");
        }
        SVNMoveClient mover = vcs.createMoveClient();
        long srcTime = src.lastModified();
        try {
            String list = SvnChangelistListener.getCurrentMapping(vcs.getProject(), src);
            if (SvnFileSystemListener.isUndo(vcs)) {
                this.myUndoingMove = true;
                this.restoreFromUndoStorage(dst);
                mover.undoMove(src, dst);
            } else {
                SVNStatus srcStatus = SvnFileSystemListener.getFileStatus(vcs, src);
                if (srcStatus == null || srcStatus.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED || srcStatus.getContentsStatus() == SVNStatusType.STATUS_EXTERNAL || srcStatus.getContentsStatus() == SVNStatusType.STATUS_MISSING || srcStatus.getContentsStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
                    return false;
                }
                mover.doMove(src, dst);
                if (list != null) {
                    SvnChangelistListener.putUnderList(vcs.getProject(), list, dst);
                }
            }
            dst.setLastModified(srcTime);
        }
        catch (SVNException e) {
            this.addToMoveExceptions(vcs.getProject(), e);
            return false;
        }
        return true;
    }

    private void restoreFromUndoStorage(File dst) {
        File[] files;
        String normPath = FileUtil.toSystemIndependentName((String)dst.getPath());
        Iterator<Pair<File, File>> it = this.myUndoStorageContents.iterator();
        while (it.hasNext()) {
            Pair<File, File> e = it.next();
            String p = FileUtil.toSystemIndependentName((String)((File)e.first).getPath());
            if (!p.startsWith(normPath)) continue;
            try {
                FileUtil.rename((File)((File)e.second), (File)((File)e.first));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
                FileUtil.asyncDelete((File)((File)e.second));
            }
            it.remove();
        }
        if (this.myStorageForUndo != null && ((files = this.myStorageForUndo.listFiles()) == null || files.length == 0)) {
            FileUtil.asyncDelete((File)this.myStorageForUndo);
            this.myStorageForUndo = null;
        }
    }

    public boolean createFile(VirtualFile dir, String name) throws IOException {
        return this.createItem(dir, name, false, false);
    }

    public boolean createDirectory(VirtualFile dir, String name) throws IOException {
        return this.createItem(dir, name, true, false);
    }

    public boolean delete(VirtualFile file) throws IOException {
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null && SvnUtil.isAdminDirectory(file)) {
            return true;
        }
        File ioFile = SvnFileSystemListener.getIOFile(file);
        if (!SVNWCUtil.isVersionedDirectory((File)ioFile.getParentFile())) {
            return false;
        }
        try {
            if (SVNWCUtil.isWorkingCopyRoot((File)ioFile)) {
                return false;
            }
        }
        catch (SVNException e) {
            // empty catch block
        }
        SVNStatus status = SvnFileSystemListener.getFileStatus(ioFile);
        if (status == null || status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED || status.getContentsStatus() == SVNStatusType.STATUS_OBSTRUCTED || status.getContentsStatus() == SVNStatusType.STATUS_MISSING || status.getContentsStatus() == SVNStatusType.STATUS_EXTERNAL) {
            return false;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED) {
            if (vcs != null && file.getParent() != null && !SvnFileSystemListener.isUndoOrRedo(vcs.getProject())) {
                this.putIgnoreInfo(file, vcs, ioFile);
            }
            return false;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
            if (SvnFileSystemListener.isUndo(vcs)) {
                this.moveToUndoStorage(file);
            }
            return true;
        }
        if (vcs != null) {
            if (status.getContentsStatus() == SVNStatusType.STATUS_ADDED) {
                try {
                    SVNWCClient wcClient = vcs.createWCClient();
                    wcClient.doRevert(ioFile, false);
                }
                catch (SVNException e) {}
            } else {
                this.myDeletedFiles.add(new DeletedFileInfo(vcs.getProject(), ioFile));
                if (file.isDirectory() || SvnFileSystemListener.isUndo(vcs)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void putIgnoreInfo(VirtualFile file, SvnVcs vcs, File ioFile) {
        IgnoredFileInfo info;
        String key = file.getParent().getPresentableUrl();
        Map<String, IgnoredFileInfo> map = this.myIgnoredInfo.get(vcs.getProject());
        if (map != null && (info = map.get(key)) != null) {
            info.addFileName(file.getName());
            return;
        }
        Set<String> existingPatterns = SvnPropertyService.getIgnoreStringsUnder(vcs, file.getParent());
        if (existingPatterns != null) {
            if (map == null) {
                map = new HashMap<String, IgnoredFileInfo>();
                this.myIgnoredInfo.put(vcs.getProject(), map);
            }
            File parentIo = ioFile.getParentFile();
            IgnoredFileInfo info2 = new IgnoredFileInfo(parentIo, existingPatterns);
            info2.addFileName(file.getName());
            map.put(key, info2);
        }
    }

    private void moveToUndoStorage(VirtualFile file) {
        if (this.myStorageForUndo == null) {
            try {
                this.myStorageForUndo = FileUtil.createTempDirectory((String)"svnUndoStorage", (String)"");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        File tmpFile = FileUtil.findSequentNonexistentFile((File)this.myStorageForUndo, (String)"tmp", (String)"");
        this.myUndoStorageContents.add(0, (Pair<File, File>)new Pair((Object)new File(file.getPath()), (Object)tmpFile));
        new File(file.getPath()).renameTo(tmpFile);
    }

    private boolean createItem(VirtualFile dir, String name, boolean directory, boolean recursive) {
        SvnVcs vcs = SvnFileSystemListener.getVCS(dir);
        if (vcs == null) {
            return false;
        }
        if (SvnFileSystemListener.isUndo(vcs) && SvnUtil.isAdminDirectory(dir, name)) {
            return false;
        }
        File ioDir = SvnFileSystemListener.getIOFile(dir);
        boolean pendingAdd = this.isPendingAdd(dir);
        if (!SVNWCUtil.isVersionedDirectory((File)ioDir) && !pendingAdd) {
            return false;
        }
        SVNWCClient wcClient = vcs.createWCClient();
        File targetFile = new File(ioDir, name);
        SVNStatus status = SvnFileSystemListener.getFileStatus(vcs, targetFile);
        if (status == null || status.getContentsStatus() == SVNStatusType.STATUS_NONE) {
            this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), dir, name, null, recursive));
            return false;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_MISSING) {
            return false;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
            SVNNodeKind kind = status.getKind();
            if (directory && kind != SVNNodeKind.DIR || !directory && kind != SVNNodeKind.FILE) {
                return false;
            }
            try {
                if (SvnFileSystemListener.isUndo(vcs)) {
                    wcClient.doRevert(targetFile, false);
                    return true;
                }
                this.myAddedFiles.add(new AddedFileInfo(vcs.getProject(), dir, name, null, recursive));
                return false;
            }
            catch (SVNException e) {
                SVNFileUtil.deleteAll((File)targetFile, (boolean)true);
                return false;
            }
        }
        return false;
    }

    private boolean isPendingAdd(VirtualFile dir) {
        for (AddedFileInfo i : this.myAddedFiles) {
            if (i.myDir != dir.getParent() || !i.myName.equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public void commandStarted(CommandEvent event) {
        this.myUndoingMove = false;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandStarted(project);
    }

    void commandStarted(Project project) {
        this.myUndoingMove = false;
        this.myMoveExceptions.remove(project);
        this.myIgnoredInfo.remove(project);
    }

    public void commandFinished(CommandEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandFinished(project);
    }

    void commandFinished(Project project) {
        List<VcsException> exceptionList;
        if (!this.myAddedFiles.isEmpty()) {
            this.processAddedFiles(project);
        }
        this.processMovedFiles(project);
        if (!this.myDeletedFiles.isEmpty()) {
            this.processDeletedFiles(project);
        }
        if ((exceptionList = this.myMoveExceptions.get(project)) != null && !exceptionList.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptionList, SvnBundle.message("move.files.errors.title", new Object[0]));
        }
        this.dealWithIgnorePatterns(project);
        if (!this.myFilesToRefresh.isEmpty()) {
            this.refreshFiles(project);
        }
    }

    private void dealWithIgnorePatterns(Project project) {
        final Map<String, IgnoredFileInfo> map = this.myIgnoredInfo.get(project);
        if (map != null) {
            final SvnVcs vcs = SvnVcs.getInstance(project);
            ProgressManager progressManager = ProgressManager.getInstance();
            Runnable prepare = new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        IgnoredFileInfo info = (IgnoredFileInfo)map.get(key);
                        info.calculatePatterns(vcs);
                        if (!info.getPatterns().isEmpty()) continue;
                        iterator.remove();
                    }
                }
            };
            progressManager.runProcessWithProgressSynchronously(prepare, SvnBundle.message("gather.ignore.patterns.info.progress.title", new Object[0]), false, project);
            if (map.isEmpty()) {
                return;
            }
            SelectIgnorePatternsToRemoveOnDeleteDialog dialog = new SelectIgnorePatternsToRemoveOnDeleteDialog(project, map);
            dialog.show();
            final Collection<IgnoredFileInfo> result = dialog.getResult();
            if (dialog.getExitCode() == 0 && !result.isEmpty()) {
                final ArrayList exceptions = new ArrayList(0);
                Runnable deletePatterns = new Runnable(){

                    @Override
                    public void run() {
                        for (IgnoredFileInfo info : result) {
                            try {
                                info.getOldPatterns().removeAll(info.getPatterns());
                                SvnPropertyService.setIgnores(vcs, info.getOldPatterns(), info.getFile());
                            }
                            catch (SVNException e) {
                                exceptions.add(new VcsException((Throwable)e));
                            }
                        }
                    }
                };
                progressManager.runProcessWithProgressSynchronously(deletePatterns, "Removing selected 'svn:ignore' patterns", false, project);
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("remove.ignore.patterns.errors.title", new Object[0]));
                }
            }
        }
    }

    private void refreshFiles(final Project project) {
        final ArrayList<VirtualFile> toRefreshFiles = new ArrayList<VirtualFile>();
        final ArrayList<VirtualFile> toRefreshDirs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myFilesToRefresh) {
            if (file == null) continue;
            if (file.isDirectory()) {
                toRefreshDirs.add(file);
                continue;
            }
            toRefreshFiles.add(file);
        }
        RefreshSession session = RefreshQueue.getInstance().createSession(true, true, new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                SvnFileSystemListener.filterOutInvalid(toRefreshFiles);
                SvnFileSystemListener.filterOutInvalid(toRefreshDirs);
                VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
                vcsDirtyScopeManager.filesDirty((Collection)toRefreshFiles, (Collection)toRefreshDirs);
            }
        });
        SvnFileSystemListener.filterOutInvalid(this.myFilesToRefresh);
        session.addAllFiles(this.myFilesToRefresh);
        session.launch();
        this.myFilesToRefresh.clear();
    }

    private static void filterOutInvalid(Collection<VirtualFile> files) {
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (file.isValid() && file.exists()) continue;
            LOG.info("Refresh root is not valid: " + file.getPath());
            iterator.remove();
        }
    }

    private void processAddedFiles(Project project) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        ArrayList<VirtualFile> addedVFiles = new ArrayList<VirtualFile>();
        HashMap<VirtualFile, File> copyFromMap = new HashMap<VirtualFile, File>();
        HashSet<VirtualFile> recursiveItems = new HashSet<VirtualFile>();
        Iterator<AddedFileInfo> it = this.myAddedFiles.iterator();
        while (it.hasNext()) {
            boolean isIgnored;
            SVNStatus fileStatus;
            AddedFileInfo addedFileInfo = it.next();
            if (addedFileInfo.myProject != project) continue;
            it.remove();
            File ioFile = new File(SvnFileSystemListener.getIOFile(addedFileInfo.myDir), addedFileInfo.myName);
            VirtualFile addedFile = addedFileInfo.myDir.findChild(addedFileInfo.myName);
            if (addedFile == null) {
                addedFile = this.myLfs.refreshAndFindFileByIoFile(ioFile);
            }
            if (addedFile == null || (fileStatus = SvnFileSystemListener.getFileStatus(vcs, ioFile)) != null && fileStatus.getContentsStatus() == SVNStatusType.STATUS_IGNORED || (isIgnored = ChangeListManager.getInstance((Project)addedFileInfo.myProject).isIgnoredFile(addedFile))) continue;
            addedVFiles.add(addedFile);
            copyFromMap.put(addedFile, addedFileInfo.myCopyFrom);
            if (!addedFileInfo.myRecursive) continue;
            recursiveItems.add(addedFile);
        }
        if (addedVFiles.isEmpty()) {
            return;
        }
        VcsShowConfirmationOption.Value value = vcs.getAddConfirmation().getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            Collection<Object> filesToProcess;
            AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
            if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                filesToProcess = addedVFiles;
            } else {
                String singleFilePrompt = addedVFiles.size() == 1 && ((VirtualFile)addedVFiles.get(0)).isDirectory() ? SvnBundle.getString("confirmation.text.add.dir") : SvnBundle.getString("confirmation.text.add.file");
                filesToProcess = vcsHelper.selectFilesToProcess(addedVFiles, SvnBundle.message("confirmation.title.add.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.add.file", new Object[0]), singleFilePrompt, vcs.getAddConfirmation());
            }
            if (filesToProcess != null) {
                ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
                SVNWCClient wcClient = vcs.createWCClient();
                final SVNCopyClient copyClient = vcs.createCopyClient();
                for (VirtualFile file : filesToProcess) {
                    final File ioFile = new File(file.getPath());
                    try {
                        final File copyFrom = (File)copyFromMap.get(file);
                        if (copyFrom != null) {
                            try {
                                new ActionWithTempFile(ioFile){

                                    protected void executeInternal() throws VcsException {
                                        try {
                                            SVNCopySource[] copySource = new SVNCopySource[]{new SVNCopySource(SVNRevision.WORKING, SVNRevision.WORKING, copyFrom)};
                                            copyClient.doCopy(copySource, ioFile, false, true, true);
                                        }
                                        catch (SVNException e) {
                                            throw new VcsException((Throwable)e);
                                        }
                                    }
                                }.execute();
                            }
                            catch (VcsException e) {
                                exceptions.add(e);
                            }
                        } else {
                            wcClient.doAdd(ioFile, true, false, false, true);
                        }
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                    }
                    catch (SVNException e) {
                        exceptions.add(new VcsException((Throwable)e));
                    }
                }
                if (!exceptions.isEmpty()) {
                    vcsHelper.showErrors(exceptions, SvnBundle.message("add.files.errors.title", new Object[0]));
                }
            }
        }
    }

    private void processDeletedFiles(Project project) {
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>();
        Iterator<DeletedFileInfo> it = this.myDeletedFiles.iterator();
        while (it.hasNext()) {
            DeletedFileInfo deletedFileInfo = it.next();
            if (deletedFileInfo.myProject != project) continue;
            it.remove();
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(deletedFileInfo.myFile);
            deletedFiles.add(filePath);
        }
        if (deletedFiles.isEmpty() || this.myUndoingMove) {
            return;
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            ArrayList filesToProcess;
            AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
            if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                filesToProcess = new ArrayList(deletedFiles);
            } else {
                String singleFilePrompt = deletedFiles.size() == 1 && ((FilePath)deletedFiles.get(0)).isDirectory() ? SvnBundle.getString("confirmation.text.delete.dir") : SvnBundle.getString("confirmation.text.delete.file");
                Collection files = vcsHelper.selectFilePathsToProcess(deletedFiles, SvnBundle.message("confirmation.title.delete.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.delete.file", new Object[0]), singleFilePrompt, vcs.getDeleteConfirmation());
                ArrayList arrayList = filesToProcess = files == null ? null : new ArrayList(files);
            }
            if (filesToProcess != null) {
                ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
                SVNWCClient wcClient = vcs.createWCClient();
                for (FilePath file : filesToProcess) {
                    VirtualFile vFile = file.getVirtualFile();
                    File ioFile = new File(file.getPath());
                    try {
                        wcClient.doDelete(ioFile, true, false);
                        if (vFile != null && vFile.isValid() && vFile.isDirectory()) {
                            vFile.refresh(true, true);
                            VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                            continue;
                        }
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                    }
                    catch (SVNException e) {
                        exceptions.add(new VcsException((Throwable)e));
                    }
                }
                if (!exceptions.isEmpty()) {
                    vcsHelper.showErrors(exceptions, SvnBundle.message("delete.files.errors.title", new Object[0]));
                }
            }
            for (FilePath file : deletedFiles) {
                FilePath parent = file.getParentPath();
                if (parent == null) continue;
                this.myFilesToRefresh.add(parent.getVirtualFile());
            }
            if (filesToProcess != null) {
                deletedFiles.removeAll(filesToProcess);
            }
            for (FilePath file : deletedFiles) {
                FileUtil.delete((File)file.getIOFile());
            }
        }
    }

    private void processMovedFiles(Project project) {
        Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
        while (iterator.hasNext()) {
            MovedFileInfo movedFileInfo = iterator.next();
            if (movedFileInfo.myProject != project) continue;
            this.doMove(SvnVcs.getInstance(project), movedFileInfo.mySrc, movedFileInfo.myDst);
            iterator.remove();
        }
    }

    @Nullable
    private static SvnVcs getVCS(VirtualFile file) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
            if (!(vcs instanceof SvnVcs)) continue;
            return (SvnVcs)vcs;
        }
        return null;
    }

    private static File getIOFile(VirtualFile vf) {
        return new File(vf.getPath()).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SVNStatus getFileStatus(File file) {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        try {
            SVNStatusClient stClient = clientManager.getStatusClient();
            SVNStatus sVNStatus = SvnFileSystemListener.getFileStatus(file, stClient);
            return sVNStatus;
        }
        finally {
            clientManager.dispose();
        }
    }

    @Nullable
    private static SVNStatus getFileStatus(SvnVcs vcs, File file) {
        SVNStatusClient stClient = vcs.createStatusClient();
        return SvnFileSystemListener.getFileStatus(file, stClient);
    }

    @Nullable
    private static SVNStatus getFileStatus(File file, SVNStatusClient stClient) {
        try {
            return stClient.doStatus(file, false);
        }
        catch (SVNException e) {
            return null;
        }
    }

    private static boolean isUndoOrRedo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnFileSystemListener.isUndoOrRedo must not be null");
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        return undoManager.isUndoInProgress() || undoManager.isRedoInProgress();
    }

    private static boolean isUndo(SvnVcs vcs) {
        if (vcs == null || vcs.getProject() == null) {
            return false;
        }
        Project p = vcs.getProject();
        return UndoManager.getInstance((Project)p).isUndoInProgress();
    }

    public void afterDone(ThrowableConsumer<LocalFileOperationsHandler, IOException> invoker) {
    }

    private class UUIDHelper {
        private final SVNWCClient myWcClient;

        private UUIDHelper(SvnVcs vcs) {
            this.myWcClient = vcs.createWCClient();
        }

        @Nullable
        public String getRepositoryUUID(VirtualFile dir) {
            block5: {
                try {
                    SVNInfo info1 = this.myWcClient.doInfo(new File(dir.getPath()), SVNRevision.WORKING);
                    if (info1 == null || info1.getRepositoryUUID() == null) {
                        VirtualFile parent = dir.getParent();
                        if (parent == null) {
                            return null;
                        }
                        if (SvnFileSystemListener.this.isPendingAdd(parent)) {
                            return this.getRepositoryUUID(parent);
                        }
                        break block5;
                    }
                    return info1.getRepositoryUUID();
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class MovedFileInfo {
        private final Project myProject;
        private final File mySrc;
        private final File myDst;

        private MovedFileInfo(Project project, File src, File dst) {
            this.myProject = project;
            this.mySrc = src;
            this.myDst = dst;
        }
    }

    private static class DeletedFileInfo {
        private final Project myProject;
        private final File myFile;

        public DeletedFileInfo(Project project, File file) {
            this.myProject = project;
            this.myFile = file;
        }
    }

    private static class AddedFileInfo {
        private final Project myProject;
        private final VirtualFile myDir;
        private final String myName;
        @Nullable
        private final File myCopyFrom;
        private final boolean myRecursive;

        public AddedFileInfo(Project project, VirtualFile dir, String name, @Nullable File copyFrom, boolean recursive) {
            this.myProject = project;
            this.myDir = dir;
            this.myName = name;
            this.myCopyFrom = copyFrom;
            this.myRecursive = recursive;
        }
    }
}

