/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.AdvancedSettingsUI;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.PatternBasedInjectionHelper;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.MethodParameterInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.MethodParameterPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.configurables.MethodParameterInjectionConfigurable;
import org.intellij.plugins.intelliLang.inject.java.ConcatenationInjector;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    private static final Pattern ourPresentationPattern = Pattern.compile("(.+)(\\(\\S+(?:\\.\\S+)+\\))");

    private static boolean isMine(PsiLanguageInjectionHost psiElement) {
        return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)psiElement);
    }

    @Override
    @NotNull
    public String getId() {
        if ("java" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport.getId must not return null");
        }
        return "java";
    }

    @Override
    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{PsiJavaPatterns.class};
        if (classArray == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport.getPatternClasses must not return null");
        }
        return classArray;
    }

    @Override
    public boolean useDefaultInjector(PsiElement host) {
        return false;
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[]{new AdvancedSettingsUI(project, configuration)};
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        return JavaLanguageInjectionSupport.doInjectInJava(psiElement.getProject(), (PsiElement)psiElement, language.getID());
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        Configuration configuration = Configuration.getInstance();
        final HashMap<BaseInjection, ConcatenationInjector.Info> injectionsMap = new HashMap<BaseInjection, ConcatenationInjector.Info>();
        ArrayList<PsiAnnotation> annotations = new ArrayList<PsiAnnotation>();
        PsiLiteralExpression host = (PsiLiteralExpression)psiElement;
        Project project = host.getProject();
        JavaLanguageInjectionSupport.collectInjections(host, configuration, injectionsMap, annotations);
        if (injectionsMap.isEmpty() && annotations.isEmpty()) {
            return false;
        }
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>(injectionsMap.keySet());
        List newInjections = ContainerUtil.mapNotNull(originalInjections, (Function)new NullableFunction<BaseInjection, BaseInjection>(){

            public BaseInjection fun(BaseInjection injection) {
                ConcatenationInjector.Info info = (ConcatenationInjector.Info)injectionsMap.get(injection);
                String placeText = JavaLanguageInjectionSupport.getPatternStringForJavaPlace(info.method, info.parameterIndex);
                BaseInjection newInjection = injection.copy();
                newInjection.setPlaceEnabled(placeText, false);
                return newInjection;
            }
        });
        Configuration.getInstance().replaceInjectionsWithUndo(project, newInjections, originalInjections, annotations);
        return true;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        Configuration configuration = Configuration.getInstance();
        HashMap<BaseInjection, ConcatenationInjector.Info> injectionsMap = new HashMap<BaseInjection, ConcatenationInjector.Info>();
        ArrayList<PsiAnnotation> annotations = new ArrayList<PsiAnnotation>();
        PsiLiteralExpression host = (PsiLiteralExpression)psiElement;
        Project project = host.getProject();
        JavaLanguageInjectionSupport.collectInjections(host, configuration, injectionsMap, annotations);
        if (injectionsMap.isEmpty() || !annotations.isEmpty()) {
            return false;
        }
        BaseInjection originalInjection = injectionsMap.keySet().iterator().next();
        MethodParameterInjection methodParameterInjection = JavaLanguageInjectionSupport.createFrom(psiElement.getProject(), originalInjection, injectionsMap.get((Object)originalInjection).method, false);
        MethodParameterInjection copy = methodParameterInjection.copy();
        BaseInjection newInjection = this.showInjectionUI(project, methodParameterInjection);
        if (newInjection != null) {
            copy.initializePlaces(false);
            newInjection.mergeOriginalPlacesFrom(copy, false);
            newInjection.mergeOriginalPlacesFrom(originalInjection, true);
            Configuration.getInstance().replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), Collections.singletonList(originalInjection), Collections.emptyList());
        }
        return true;
    }

    private BaseInjection showInjectionUI(Project project, MethodParameterInjection methodParameterInjection) {
        final MethodParameterPanel panel = new MethodParameterPanel(methodParameterInjection, project);
        panel.reset();
        final DialogBuilder builder = new DialogBuilder(project);
        builder.setHelpId("reference.settings.injection.language.injection.settings.java.parameter");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(new Runnable(){

            @Override
            public void run() {
                panel.apply();
                builder.getDialogWrapper().close(0);
            }
        });
        if (builder.show() == 0) {
            methodParameterInjection.initializePlaces(false);
            return new BaseInjection(methodParameterInjection.getSupportId()).copyFrom(methodParameterInjection);
        }
        return null;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        if (element.getName().equals(MethodParameterInjection.class.getSimpleName())) {
            return new MethodParameterInjection();
        }
        return new BaseInjection("java");
    }

    private static boolean doInjectInJava(Project project, PsiElement host, String languageId) {
        PsiElement target = ContextComputationProcessor.getTopLevelInjectionTarget(host);
        PsiElement parent = target.getParent();
        if (parent instanceof PsiReturnStatement || parent instanceof PsiMethod || parent instanceof PsiNameValuePair) {
            return JavaLanguageInjectionSupport.doInjectInJavaMethod(project, JavaLanguageInjectionSupport.findPsiMethod(parent), -1, languageId);
        }
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            return JavaLanguageInjectionSupport.doInjectInJavaMethod(project, JavaLanguageInjectionSupport.findPsiMethod(parent), JavaLanguageInjectionSupport.findParameterIndex(target, (PsiExpressionList)parent), languageId);
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiElement element;
            PsiExpression psiExpression = ((PsiAssignmentExpression)parent).getLExpression();
            if (psiExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)psiExpression).resolve()) != null) {
                return JavaLanguageInjectionSupport.doInjectInJava(project, element, languageId);
            }
        } else if (parent instanceof PsiVariable && JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)parent, languageId)) {
            return true;
        }
        return false;
    }

    static boolean doAddLanguageAnnotation(final Project project, final PsiModifierListOwner modifierListOwner, final String languageId) {
        if (modifierListOwner.getModifierList() == null || !PsiUtil.getLanguageLevel((PsiElement)modifierListOwner).hasEnumKeywordAndAutoboxing()) {
            return false;
        }
        if (!OrderEntryFix.ensureAnnotationsJarInPath((Module)ModuleUtil.findModuleForPsiElement((PsiElement)modifierListOwner), (String)"org.intellij.lang.annotations.Language")) {
            return false;
        }
        new WriteCommandAction(project, new PsiFile[]{modifierListOwner.getContainingFile()}){

            protected void run(Result result) throws Throwable {
                PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@org.intellij.lang.annotations.Language(\"" + languageId + "\")", (PsiElement)modifierListOwner);
                PsiModifierList list = modifierListOwner.getModifierList();
                assert (list != null);
                PsiAnnotation existingAnnotation = list.findAnnotation("org.intellij.lang.annotations.Language");
                if (existingAnnotation != null) {
                    existingAnnotation.replace((PsiElement)annotation);
                } else {
                    list.addAfter((PsiElement)annotation, null);
                }
                JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)list);
            }
        }.execute();
        return true;
    }

    private static boolean doInjectInJavaMethod(Project project, PsiMethod psiMethod, int parameterIndex, String languageId) {
        if (psiMethod == null) {
            return false;
        }
        if (parameterIndex < -1) {
            return false;
        }
        if (parameterIndex >= psiMethod.getParameterList().getParametersCount()) {
            return false;
        }
        PsiModifierList methodModifiers = psiMethod.getModifierList();
        if (methodModifiers.hasModifierProperty("private") || methodModifiers.hasModifierProperty("packageLocal")) {
            return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)(parameterIndex >= 0 ? psiMethod.getParameterList().getParameters()[parameterIndex] : psiMethod), languageId);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        assert (containingClass != null);
        PsiModifierList classModifiers = containingClass.getModifierList();
        if (classModifiers != null && (classModifiers.hasModifierProperty("private") || classModifiers.hasModifierProperty("packageLocal"))) {
            return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)(parameterIndex >= 0 ? psiMethod.getParameterList().getParameters()[parameterIndex] : psiMethod), languageId);
        }
        String className = containingClass.getQualifiedName();
        assert (className != null);
        MethodParameterInjection injection = new MethodParameterInjection();
        injection.setInjectedLanguageId(languageId);
        injection.setClassName(className);
        MethodParameterInjection.MethodInfo info = MethodParameterInjection.createMethodInfo(psiMethod);
        if (parameterIndex < 0) {
            info.setReturnFlag(true);
        } else {
            info.getParamFlags()[parameterIndex] = true;
        }
        injection.setMethodInfos(Collections.singletonList(info));
        JavaLanguageInjectionSupport.doEditInjection(project, injection, psiMethod);
        return true;
    }

    static int findParameterIndex(PsiElement target, PsiExpressionList parent) {
        int idx = Arrays.asList(parent.getExpressions()).indexOf(target);
        return idx < 0 ? -2 : idx;
    }

    @Nullable
    static PsiMethod findPsiMethod(PsiElement parent) {
        PsiMethod[] methods;
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation;
        if (parent instanceof PsiNameValuePair && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiAnnotation.class)) != null && (referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null && (methods = ((PsiClass)resolved).findMethodsByName(((PsiNameValuePair)parent).getName(), false)).length == 1) {
            return methods[0];
        }
        PsiMethod first = parent.getParent() instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)parent.getParent()).resolveMethod() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false);
        if (first == null || first.getContainingClass() == null) {
            return null;
        }
        LinkedList<PsiMethod> methods2 = new LinkedList<PsiMethod>();
        methods2.add(first);
        while (!methods2.isEmpty()) {
            PsiMethod method = (PsiMethod)methods2.removeFirst();
            PsiClass psiClass = method.getContainingClass();
            if (psiClass != null && psiClass.getQualifiedName() != null) {
                return method;
            }
            methods2.addAll(Arrays.asList(method.findSuperMethods()));
        }
        return null;
    }

    private static void doEditInjection(Project project, MethodParameterInjection template, PsiMethod contextMethod) {
        MethodParameterInjection methodParameterInjection;
        Configuration configuration = Configuration.getInstance();
        template.initializePlaces(false);
        BaseInjection baseTemplate = new BaseInjection(template.getSupportId()).copyFrom(template);
        MethodParameterInjection allMethodParameterInjection = JavaLanguageInjectionSupport.createFrom(project, baseTemplate, contextMethod, true);
        allMethodParameterInjection.initializePlaces(false);
        BaseInjection originalInjection = configuration.findExistingInjection(allMethodParameterInjection);
        if (originalInjection == null) {
            methodParameterInjection = template;
        } else {
            BaseInjection originalCopy = originalInjection.copy();
            InjectionPlace currentPlace = template.getInjectionPlaces().get(0);
            String text = currentPlace.getText();
            originalCopy.setPlaceEnabled(text, true);
            methodParameterInjection = JavaLanguageInjectionSupport.createFrom(project, originalCopy, contextMethod, false);
        }
        if (InjectLanguageAction.doEditConfigurable(project, (Configurable)new MethodParameterInjectionConfigurable(methodParameterInjection, null, project))) {
            methodParameterInjection.initializePlaces(false);
            BaseInjection newInjection = new BaseInjection(methodParameterInjection.getSupportId()).copyFrom(methodParameterInjection);
            if (originalInjection != null) {
                newInjection.mergeOriginalPlacesFrom(originalInjection, true);
            }
            Configuration.getInstance().replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
        }
    }

    private static void collectInjections(PsiLiteralExpression host, final Configuration configuration, final Map<BaseInjection, ConcatenationInjector.Info> injectionsToRemove, final ArrayList<PsiAnnotation> annotationsToRemove) {
        ConcatenationInjector.processLiteralExpressionInjectionsInner(configuration, new Processor<ConcatenationInjector.Info>(){

            public boolean process(ConcatenationInjector.Info info) {
                PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(info.owner, configuration.getLanguageAnnotationPair(), true);
                annotationsToRemove.addAll(Arrays.asList(annotations));
                for (BaseInjection injection : info.injections) {
                    injectionsToRemove.put(injection, info);
                }
                return true;
            }
        }, new PsiElement[]{host});
    }

    private static MethodParameterInjection createFrom(Project project, BaseInjection injection, PsiMethod contextMethod, boolean includeAllPlaces) {
        String className;
        PsiClass containingClass;
        if (contextMethod != null) {
            containingClass = contextMethod.getContainingClass();
            className = containingClass == null ? "" : StringUtil.notNullize((String)containingClass.getQualifiedName());
        } else {
            Matcher matcher;
            String found = null;
            Pattern pattern = Pattern.compile(".*definedInClass\\(\"([^\"]*)\"\\)+");
            for (InjectionPlace place : injection.getInjectionPlaces()) {
                Matcher matcher2 = pattern.matcher(place.getText());
                if (!matcher2.matches()) continue;
                found = matcher2.group(1);
            }
            if (found == null && (matcher = ourPresentationPattern.matcher(injection.getDisplayName())).matches()) {
                String pkg = matcher.group(2);
                found = pkg.substring(1, pkg.length() - 1) + "." + matcher.group(1);
            }
            containingClass = found != null && project.isInitialized() ? JavaPsiFacade.getInstance((Project)project).findClass(found, GlobalSearchScope.allScope((Project)project)) : null;
            className = StringUtil.notNullize((String)(containingClass == null ? found : containingClass.getQualifiedName()));
        }
        MethodParameterInjection result = new MethodParameterInjection();
        result.copyFrom(injection);
        result.getInjectionPlaces().clear();
        result.setClassName(className);
        ArrayList<MethodParameterInjection.MethodInfo> infos = new ArrayList<MethodParameterInjection.MethodInfo>();
        if (containingClass != null) {
            for (PsiMethod method : containingClass.getMethods()) {
                PsiModifierList modifiers = method.getModifierList();
                if (modifiers.hasModifierProperty("private") || modifiers.hasModifierProperty("packageLocal")) continue;
                boolean add = false;
                MethodParameterInjection.MethodInfo methodInfo = MethodParameterInjection.createMethodInfo(method);
                if (MethodParameterInjection.isInjectable(method.getReturnType(), method.getProject())) {
                    int parameterIndex = -1;
                    InjectionPlace place = injection.findPlaceByText(JavaLanguageInjectionSupport.getPatternStringForJavaPlace(method, -1));
                    methodInfo.setReturnFlag(place != null && place.isEnabled() || includeAllPlaces);
                    add = true;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter p = parameters[i];
                    if (!MethodParameterInjection.isInjectable(p.getType(), p.getProject())) continue;
                    InjectionPlace place = injection.findPlaceByText(JavaLanguageInjectionSupport.getPatternStringForJavaPlace(method, i));
                    methodInfo.getParamFlags()[i] = place != null && place.isEnabled() || includeAllPlaces;
                    add = true;
                }
                if (!add) continue;
                infos.add(methodInfo);
            }
        }
        result.setMethodInfos(infos);
        return result;
    }

    public static String getPatternStringForJavaPlace(PsiMethod method, int parameterIndex) {
        PsiClass psiClass = method.getContainingClass();
        String className = psiClass == null ? "" : StringUtil.notNullize((String)psiClass.getQualifiedName());
        String signature = MethodParameterInjection.createMethodInfo(method).getMethodSignature();
        return PatternBasedInjectionHelper.getPatternStringForJavaPlace(method.getName(), PatternBasedInjectionHelper.getParameterTypesString(signature), parameterIndex, className);
    }

    @Override
    public AnAction[] createAddActions(final Project project, final Consumer<BaseInjection> consumer) {
        return new AnAction[]{new AnAction("Java Parameter", null, Icons.PARAMETER_ICON){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection injection = JavaLanguageInjectionSupport.this.showInjectionUI(project, new MethodParameterInjection());
                if (injection != null) {
                    consumer.consume((Object)injection);
                }
            }
        }};
    }

    @Override
    public AnAction createEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection originalInjection = (BaseInjection)producer.create();
                MethodParameterInjection injection = JavaLanguageInjectionSupport.createFrom(project, originalInjection, null, false);
                if (injection != null) {
                    boolean mergeEnabled = !project.isInitialized() || JavaPsiFacade.getInstance((Project)project).findClass(injection.getClassName(), GlobalSearchScope.allScope((Project)project)) == null;
                    BaseInjection newInjection = JavaLanguageInjectionSupport.this.showInjectionUI(project, injection);
                    if (newInjection != null) {
                        newInjection.mergeOriginalPlacesFrom(originalInjection, mergeEnabled);
                        originalInjection.copyFrom(newInjection);
                        originalInjection.initializePlaces(true);
                    }
                } else {
                    AbstractLanguageInjectionSupport.createDefaultEditAction(project, (Factory<BaseInjection>)producer).actionPerformed(null);
                }
            }
        };
    }

    @Override
    public void setupPresentation(BaseInjection injection, SimpleColoredText presentation, boolean isSelected) {
        Matcher matcher = ourPresentationPattern.matcher(injection.getDisplayName());
        if (matcher.matches()) {
            presentation.append(matcher.group(1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.append(matcher.group(2), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            super.setupPresentation(injection, presentation, isSelected);
        }
    }
}

