/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    @NonNls
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    @NonNls
    private static final String ID_ATTRIBUTE_NAME = "id";

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider.acceptElement must not be null");
        }
        return e instanceof XmlTag && e.isValid();
    }

    public Language[] getLanguages() {
        return new Language[]{XHTMLLanguage.INSTANCE, HTMLLanguage.INSTANCE};
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        boolean addHtmlInfo;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider.getElementInfo must not be null");
        }
        XmlTag tag = (XmlTag)e;
        StringBuffer sb = new StringBuffer();
        sb.append(tag.getName());
        boolean bl = addHtmlInfo = e.getContainingFile().getLanguage() != XMLLanguage.INSTANCE;
        if (addHtmlInfo) {
            String class_value;
            String id_value = tag.getAttributeValue(ID_ATTRIBUTE_NAME);
            if (null != id_value) {
                sb.append("#").append(id_value);
            }
            if (null != (class_value = tag.getAttributeValue(CLASS_ATTRIBUTE_NAME))) {
                StringTokenizer tokenizer = new StringTokenizer(class_value, " ");
                while (tokenizer.hasMoreTokens()) {
                    sb.append(".").append(tokenizer.nextToken());
                }
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider.getElementInfo must not return null");
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        XmlAttribute[] attributes;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider.getElementTooltip must not be null");
        }
        XmlTag tag = (XmlTag)e;
        StringBuffer result = new StringBuffer("<");
        result.append(tag.getName());
        for (XmlAttribute each : attributes = tag.getAttributes()) {
            result.append(" ").append(each.getText());
        }
        if (tag.isEmpty()) {
            result.append("/>");
        } else {
            result.append(">...</").append(tag.getName()).append(">");
        }
        return result.toString();
    }
}

