/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XValueContainerNode<ValueContainer extends XValueContainer>
extends XDebuggerTreeNode
implements XCompositeNode,
TreeNode {
    private List<XValueContainerNode<?>> myValueChildren;
    private List<MessageTreeNode> myMessageChildren;
    private List<TreeNode> myCachedAllChildren;
    protected final ValueContainer myValueContainer;
    private volatile boolean myObsolete;

    protected XValueContainerNode(XDebuggerTree tree, XDebuggerTreeNode parent, ValueContainer valueContainer) {
        super(tree, parent, true);
        this.myValueContainer = valueContainer;
        this.myText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
    }

    private void loadChildren() {
        if (this.myValueChildren != null || this.myMessageChildren != null) {
            return;
        }
        this.startComputingChildren();
    }

    public void startComputingChildren() {
        this.myCachedAllChildren = null;
        this.setMessageNode(this.createLoadingMessageNode());
        this.myValueContainer.computeChildren((XCompositeNode)this);
    }

    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createLoadingMessage(this.myTree, this);
    }

    public void addChildren(final List<? extends XValue> children, final boolean last) {
        DebuggerUIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (XValueContainerNode.this.myValueChildren == null) {
                    XValueContainerNode.this.myValueChildren = new ArrayList();
                }
                ArrayList newChildren = new ArrayList();
                for (XValue child : children) {
                    XValueContainerNode<?> node = XValueContainerNode.this.createChildNode(child);
                    XValueContainerNode.this.myValueChildren.add(node);
                    newChildren.add(node);
                }
                XValueContainerNode.this.myCachedAllChildren = null;
                XValueContainerNode.this.fireNodesInserted(newChildren);
                if (last) {
                    int[] ints = XValueContainerNode.this.getNodesIndices(XValueContainerNode.this.myMessageChildren);
                    TreeNode[] removed = XValueContainerNode.this.getChildNodes(ints);
                    XValueContainerNode.this.myCachedAllChildren = null;
                    XValueContainerNode.this.myMessageChildren = null;
                    XValueContainerNode.this.fireNodesRemoved(ints, removed);
                }
                XValueContainerNode.this.myTree.childrenLoaded(XValueContainerNode.this, newChildren, last);
            }
        });
    }

    public void tooManyChildren(final int remaining) {
        DebuggerUIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                XValueContainerNode.this.setMessageNode(MessageTreeNode.createEllipsisNode(XValueContainerNode.this.myTree, XValueContainerNode.this, remaining));
            }
        });
    }

    protected XValueContainerNode<?> createChildNode(XValue child) {
        return new XValueNodeImpl(this.myTree, (XDebuggerTreeNode)this, child);
    }

    public boolean isObsolete() {
        return this.myObsolete;
    }

    @Override
    public void clearChildren() {
        this.myCachedAllChildren = null;
        this.myMessageChildren = null;
        this.myValueChildren = null;
        this.fireNodeChildrenChanged();
    }

    public void setErrorMessage(final @NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode.setErrorMessage must not be null");
        }
        DebuggerUIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                XValueContainerNode.this.setMessageNode(MessageTreeNode.createErrorMessage(XValueContainerNode.this.myTree, XValueContainerNode.this, errorMessage));
            }
        });
    }

    protected void setMessageNode(MessageTreeNode messageNode) {
        this.myCachedAllChildren = null;
        int[] indices = this.getNodesIndices(this.myMessageChildren);
        TreeNode[] nodes = this.getChildNodes(indices);
        this.myMessageChildren = Collections.emptyList();
        this.fireNodesRemoved(indices, nodes);
        this.myMessageChildren = Collections.singletonList(messageNode);
        this.myCachedAllChildren = null;
        this.fireNodesInserted(this.myMessageChildren);
    }

    @Override
    protected List<? extends TreeNode> getChildren() {
        this.loadChildren();
        if (this.myCachedAllChildren == null) {
            this.myCachedAllChildren = new ArrayList<TreeNode>();
            if (this.myValueChildren != null) {
                this.myCachedAllChildren.addAll(this.myValueChildren);
            }
            if (this.myMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myMessageChildren);
            }
        }
        return this.myCachedAllChildren;
    }

    public ValueContainer getValueContainer() {
        return this.myValueContainer;
    }

    @Nullable
    public List<XValueContainerNode<?>> getLoadedChildren() {
        return this.myValueChildren;
    }

    public void setObsolete() {
        this.myObsolete = true;
    }
}

