/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomCollectionChildDescription,
AbstractCollectionChildDescription {
    private final Collection<JavaMethod> myGetterMethods;
    private final Collection<JavaMethod> myAdderMethods;
    private final Collection<JavaMethod> myIndexedAdderMethods;
    private final Collection<JavaMethod> myClassAdderMethods;
    private final Collection<JavaMethod> myIndexedClassAdderMethods;
    private final Collection<JavaMethod> myInvertedIndexedClassAdderMethods;
    private final NotNullFunction<DomInvocationHandler, List<XmlTag>> myTagsGetter = new NotNullFunction<DomInvocationHandler, List<XmlTag>>(){

        @NotNull
        public List<XmlTag> fun(DomInvocationHandler handler) {
            List<XmlTag> list = DomImplUtil.findSubTags(handler.getXmlTag(), handler.createEvaluatedXmlName(CollectionChildDescriptionImpl.this.getXmlName()), handler.getFile());
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/CollectionChildDescriptionImpl$1.fun must not return null");
            }
            return list;
        }
    };
    @NonNls
    private static final String ES = "es";

    public CollectionChildDescriptionImpl(XmlName tagName, Type type, Collection<JavaMethod> adderMethods, Collection<JavaMethod> classAdderMethods, Collection<JavaMethod> getterMethods, Collection<JavaMethod> indexedAdderMethods, Collection<JavaMethod> indexedClassAdderMethods, Collection<JavaMethod> invertedIndexedClassAdderMethods) {
        super(tagName, type);
        this.myAdderMethods = adderMethods;
        this.myClassAdderMethods = classAdderMethods;
        this.myGetterMethods = getterMethods;
        this.myIndexedAdderMethods = indexedAdderMethods;
        this.myIndexedClassAdderMethods = indexedClassAdderMethods;
        this.myInvertedIndexedClassAdderMethods = invertedIndexedClassAdderMethods;
    }

    public JavaMethod getClassAdderMethod() {
        return CollectionChildDescriptionImpl.getFirst(this.myClassAdderMethods);
    }

    public NotNullFunction<DomInvocationHandler, List<XmlTag>> getTagsGetter() {
        return this.myTagsGetter;
    }

    @Nullable
    private static JavaMethod getFirst(Collection<JavaMethod> methods) {
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    @Nullable
    public JavaMethod getIndexedClassAdderMethod() {
        return CollectionChildDescriptionImpl.getFirst(this.myIndexedClassAdderMethods);
    }

    @Nullable
    public JavaMethod getInvertedIndexedClassAdderMethod() {
        return CollectionChildDescriptionImpl.getFirst(this.myInvertedIndexedClassAdderMethods);
    }

    @Nullable
    public JavaMethod getAdderMethod() {
        return CollectionChildDescriptionImpl.getFirst(this.myAdderMethods);
    }

    public DomElement addValue(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.addValue must not be null");
        }
        assert (element.getGenericInfo().getCollectionChildrenDescriptions().contains(this));
        return this.addChild(element, this.getType(), Integer.MAX_VALUE);
    }

    private DomElement addChild(DomElement element, Type type, int index) {
        try {
            DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
            assert (handler != null);
            return handler.addCollectionChild(this, type, index);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public DomElement addValue(@NotNull DomElement element, int index) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.addValue must not be null");
        }
        return this.addChild(element, this.getType(), index);
    }

    public DomElement addValue(@NotNull DomElement parent, Type type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.addValue must not be null");
        }
        return this.addValue(parent, type, Integer.MAX_VALUE);
    }

    public final DomElement addValue(@NotNull DomElement parent, Type type, int index) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.addValue must not be null");
        }
        return this.addChild(parent, type, index);
    }

    @Nullable
    public final JavaMethod getGetterMethod() {
        Collection<JavaMethod> methods = this.myGetterMethods;
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    public JavaMethod getIndexedAdderMethod() {
        return CollectionChildDescriptionImpl.getFirst(this.myIndexedAdderMethods);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement element) {
        List list;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getValues must not be null");
        }
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
        if (handler != null) {
            list = handler.getCollectionChildren(this, this.myTagsGetter);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getValues must not return null");
            return list;
        }
        JavaMethod getterMethod = this.getGetterMethod();
        if (getterMethod == null) {
            List collection = ModelMergerUtil.getFilteredImplementations((Object)element);
            list = ContainerUtil.concat((Iterable)collection, (Function)new Function<DomElement, Collection<? extends DomElement>>(){

                public Collection<? extends DomElement> fun(DomElement domElement) {
                    DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(domElement);
                    assert (handler != null) : domElement;
                    return handler.getCollectionChildren(CollectionChildDescriptionImpl.this, (NotNullFunction<DomInvocationHandler, List<XmlTag>>)CollectionChildDescriptionImpl.this.myTagsGetter);
                }
            });
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getValues must not return null");
            return list;
        }
        list = (List)getterMethod.invoke((Object)element, ArrayUtil.EMPTY_OBJECT_ARRAY);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getValues must not return null");
    }

    @NotNull
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getCommonPresentableName must not be null");
        }
        String words = strategy.splitIntoWords(this.getXmlElementName());
        String string = StringUtil.capitalizeWords((String)(words.endsWith(ES) ? words : StringUtil.pluralize((String)words)), (boolean)true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/CollectionChildDescriptionImpl.getCommonPresentableName must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        JavaMethod method = this.getGetterMethod();
        if (method != null && (annotation = method.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        Type elemType = this.getType();
        return elemType instanceof AnnotatedElement ? ((AnnotatedElement)((Object)elemType)).getAnnotation(annotationClass) : super.getAnnotation(annotationClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollectionChildDescriptionImpl that = (CollectionChildDescriptionImpl)o;
        if (this.myAdderMethods != null ? !((Object)this.myAdderMethods).equals(that.myAdderMethods) : that.myAdderMethods != null) {
            return false;
        }
        if (this.myClassAdderMethods != null ? !((Object)this.myClassAdderMethods).equals(that.myClassAdderMethods) : that.myClassAdderMethods != null) {
            return false;
        }
        if (this.myGetterMethods != null ? !((Object)this.myGetterMethods).equals(that.myGetterMethods) : that.myGetterMethods != null) {
            return false;
        }
        if (this.myIndexedAdderMethods != null ? !((Object)this.myIndexedAdderMethods).equals(that.myIndexedAdderMethods) : that.myIndexedAdderMethods != null) {
            return false;
        }
        if (this.myIndexedClassAdderMethods != null ? !((Object)this.myIndexedClassAdderMethods).equals(that.myIndexedClassAdderMethods) : that.myIndexedClassAdderMethods != null) {
            return false;
        }
        return !(this.myInvertedIndexedClassAdderMethods != null ? !((Object)this.myInvertedIndexedClassAdderMethods).equals(that.myInvertedIndexedClassAdderMethods) : that.myInvertedIndexedClassAdderMethods != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.myGetterMethods != null ? ((Object)this.myGetterMethods).hashCode() : 0);
        result = 29 * result + (this.myAdderMethods != null ? ((Object)this.myAdderMethods).hashCode() : 0);
        result = 29 * result + (this.myIndexedAdderMethods != null ? ((Object)this.myIndexedAdderMethods).hashCode() : 0);
        result = 29 * result + (this.myClassAdderMethods != null ? ((Object)this.myClassAdderMethods).hashCode() : 0);
        result = 29 * result + (this.myIndexedClassAdderMethods != null ? ((Object)this.myIndexedClassAdderMethods).hashCode() : 0);
        result = 29 * result + (this.myInvertedIndexedClassAdderMethods != null ? ((Object)this.myInvertedIndexedClassAdderMethods).hashCode() : 0);
        return result;
    }

    public Collection<JavaMethod> getAdderMethods() {
        return this.myAdderMethods;
    }

    public Collection<JavaMethod> getClassAdderMethods() {
        return this.myClassAdderMethods;
    }

    public Collection<JavaMethod> getGetterMethods() {
        return this.myGetterMethods;
    }

    public Collection<JavaMethod> getIndexedAdderMethods() {
        return this.myIndexedAdderMethods;
    }

    public Collection<JavaMethod> getIndexedClassAdderMethods() {
        return this.myIndexedClassAdderMethods;
    }

    public Collection<JavaMethod> getInvertedIndexedClassAdderMethods() {
        return this.myInvertedIndexedClassAdderMethods;
    }

    @Override
    public List<XmlTag> getSubTags(DomInvocationHandler handler, XmlTag[] subTags, XmlFile file) {
        return DomImplUtil.findSubTags(subTags, handler.createEvaluatedXmlName(this.getXmlName()), file);
    }

    @Override
    public EvaluatedXmlName createEvaluatedXmlName(DomInvocationHandler parent, XmlTag childTag) {
        return parent.createEvaluatedXmlName(this.getXmlName());
    }
}

