/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        Project project = field.getProject();
        String propertyName = PropertyUtil.suggestPropertyName((Project)project, (PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertySetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        Project project = field.getProject();
        String propertyName = PropertyUtil.suggestPropertyName((Project)project, (PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)true);
    }
}

