/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveInstanceMembersUtil.class.getName()));

    public static Map<PsiClass, Set<PsiMember>> getThisClassesToMembers(PsiMember member) {
        LinkedHashMap<PsiClass, Set<PsiMember>> map = new LinkedHashMap<PsiClass, Set<PsiMember>>();
        MoveInstanceMembersUtil.getThisClassesToMembers((PsiElement)member, map, member);
        return map;
    }

    private static void getThisClassesToMembers(PsiElement scope, Map<PsiClass, Set<PsiMember>> map, PsiMember refMember) {
        PsiElement[] children;
        if (scope instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)scope;
            if (!(scope instanceof PsiReferenceExpression) || !((PsiReferenceExpression)scope).isReferenceTo((PsiElement)refMember)) {
                Pair<PsiMember, PsiClass> pair = MoveInstanceMembersUtil.getMemberAndClassReferencedByThis(expression);
                if (pair != null) {
                    PsiClass refClass = (PsiClass)pair.getSecond();
                    PsiMember member = (PsiMember)pair.getFirst();
                    if (refClass != null && !PsiTreeUtil.isAncestor((PsiElement)refMember, (PsiElement)member, (boolean)false)) {
                        MoveInstanceMembersUtil.addReferencedMember(map, refClass, member);
                    }
                }
                if (expression instanceof PsiThisExpression) {
                    PsiClass thisClass;
                    PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)expression).getQualifier();
                    PsiClass psiClass = thisClass = thisQualifier == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class, (boolean)true) : (PsiClass)thisQualifier.resolve();
                    if (thisClass != null) {
                        MoveInstanceMembersUtil.addReferencedMember(map, thisClass, null);
                    }
                }
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            MoveInstanceMembersUtil.getThisClassesToMembers(child, map, refMember);
        }
    }

    private static void addReferencedMember(Map<PsiClass, Set<PsiMember>> map, PsiClass classReferenced, PsiMember member) {
        HashSet members = map.get(classReferenced);
        if (members == null) {
            members = new HashSet();
            map.put(classReferenced, (Set<PsiMember>)members);
        }
        members.add((PsiMember)member);
    }

    @Nullable
    private static Pair<PsiMember, PsiClass> getMemberAndClassReferencedByThis(PsiExpression expression) {
        PsiClass resolved;
        PsiJavaCodeReferenceElement classReference;
        PsiNewExpression newExpression;
        PsiExpression qualifier;
        if (expression instanceof PsiReferenceExpression) {
            PsiElement resolved2;
            PsiExpression qualifier2 = ((PsiReferenceExpression)expression).getQualifierExpression();
            if ((qualifier2 == null || qualifier2 instanceof PsiThisExpression) && (resolved2 = ((PsiReferenceExpression)expression).resolve()) instanceof PsiMember && !((PsiMember)resolved2).hasModifierProperty("static")) {
                PsiClass referencedClass = MoveInstanceMembersUtil.getReferencedClass((PsiMember)resolved2, qualifier2, expression);
                return new Pair((Object)((PsiMember)resolved2), (Object)referencedClass);
            }
        } else if (expression instanceof PsiNewExpression && ((qualifier = (newExpression = (PsiNewExpression)expression).getQualifier()) == null || qualifier instanceof PsiThisExpression) && (classReference = newExpression.getClassOrAnonymousClassReference()) != null && (resolved = (PsiClass)classReference.resolve()) != null && !resolved.hasModifierProperty("static")) {
            PsiClass referencedClass = MoveInstanceMembersUtil.getReferencedClass((PsiMember)resolved, qualifier, expression);
            return new Pair((Object)resolved, (Object)referencedClass);
        }
        return null;
    }

    @Nullable
    private static PsiClass getReferencedClass(PsiMember member, PsiExpression exprQualifier, PsiExpression expression) {
        if (exprQualifier != null) {
            PsiType type = exprQualifier.getType();
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).resolve();
            }
            return null;
        }
        PsiClass referencedClass = member.getContainingClass();
        if (referencedClass == null) {
            return null;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
        assert (parentClass != null);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)referencedClass, (boolean)false)) {
            referencedClass = parentClass;
        }
        return referencedClass;
    }

    @Nullable
    public static PsiClass getClassReferencedByThis(PsiExpression expression) {
        PsiClass enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
        if (enclosingClass == null) {
            return null;
        }
        Pair<PsiMember, PsiClass> pair = MoveInstanceMembersUtil.getMemberAndClassReferencedByThis(expression);
        if (pair != null) {
            return (PsiClass)pair.getSecond();
        }
        if (expression instanceof PsiThisExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)expression).getQualifier();
            if (thisQualifier == null) {
                return enclosingClass;
            }
            return (PsiClass)thisQualifier.resolve();
        }
        return null;
    }

    public static void moveInitializerToConstructor(PsiElementFactory factory, PsiMethod constructor, PsiField field) {
        PsiExpression initializer = field.getInitializer();
        PsiExpression initializerCopy = (PsiExpression)initializer.copy();
        PsiCodeBlock body = constructor.getBody();
        if (body != null) {
            try {
                String fieldName = field.getName();
                PsiReferenceExpression refExpr = (PsiReferenceExpression)factory.createExpressionFromText(fieldName, (PsiElement)body);
                if (refExpr.resolve() != null) {
                    fieldName = "this." + fieldName;
                }
                PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(fieldName + "= y;", null);
                if (initializerCopy instanceof PsiArrayInitializerExpression) {
                    PsiType type = initializer.getType();
                    PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + type.getCanonicalText() + "{}", (PsiElement)body);
                    newExpression.getArrayInitializer().replace((PsiElement)initializerCopy);
                    initializerCopy = newExpression;
                }
                ((PsiAssignmentExpression)statement.getExpression()).getRExpression().replace((PsiElement)initializerCopy);
                statement = (PsiExpressionStatement)field.getManager().getCodeStyleManager().reformat((PsiElement)statement);
                body.add((PsiElement)statement);
                initializer.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

