/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesHandler
implements CopyHandlerDelegate {
    @Override
    public boolean canCopy(PsiElement[] elements) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFileSystemItem)) {
                return false;
            }
            String name = ((PsiFileSystemItem)element).getName();
            if (names.contains(name)) {
                return false;
            }
            names.add(name);
            if (element instanceof PsiFile && !this.canCopyFile((PsiFile)element)) {
                return false;
            }
            if (!(element instanceof PsiDirectory) || this.canCopyDirectory((PsiDirectory)element)) continue;
            return false;
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        return filteredElements.length == elements.length;
    }

    protected boolean canCopyFile(PsiFile element) {
        return true;
    }

    protected boolean canCopyDirectory(PsiDirectory element) {
        return true;
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        if (defaultTargetDirectory == null) {
            defaultTargetDirectory = CopyFilesOrDirectoriesHandler.getCommonParentDirectory(elements);
        }
        Project project = elements[0].getProject();
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, defaultTargetDirectory, project, false);
        dialog.show();
        if (dialog.isOK()) {
            String newName = elements.length == 1 ? dialog.getNewName() : null;
            PsiDirectory targetDirectory = dialog.getTargetDirectory();
            try {
                for (PsiElement element : elements) {
                    PsiFileSystemItem psiElement = (PsiFileSystemItem)element;
                    if (!psiElement.isDirectory()) continue;
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)psiElement, (PsiElement)targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
                return;
            }
            CopyFilesOrDirectoriesHandler.copyImpl(elements, newName, dialog.getTargetDirectory(), false);
        }
    }

    @Override
    public void doClone(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : ((PsiFile)element).getContainingDirectory();
        PsiElement[] elements = new PsiElement[]{element};
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        dialog.show();
        if (dialog.isOK()) {
            String newName = dialog.getNewName();
            CopyFilesOrDirectoriesHandler.copyImpl(elements, newName, targetDirectory, true);
        }
    }

    @Nullable
    private static PsiDirectory getCommonParentDirectory(PsiElement[] elements) {
        PsiDirectory result = null;
        for (PsiElement element : elements) {
            PsiDirectory directory;
            if (element instanceof PsiDirectory) {
                directory = (PsiDirectory)element;
                directory = directory.getParentDirectory();
            } else if (element instanceof PsiFile) {
                directory = ((PsiFile)element).getContainingDirectory();
            } else {
                throw new IllegalArgumentException("unexpected element " + element);
            }
            if (directory == null) continue;
            if (result == null) {
                result = directory;
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)result, (boolean)true)) continue;
            result = directory;
        }
        return result;
    }

    private static void copyImpl(final PsiElement[] elements, final String newName, final PsiDirectory targetDirectory, final boolean doClone) {
        if (doClone && elements.length != 1) {
            throw new IllegalArgumentException("invalid number of elements to clone:" + elements.length);
        }
        if (newName != null && elements.length != 1) {
            throw new IllegalArgumentException("no new name should be set; number of elements is: " + elements.length);
        }
        final Project project = targetDirectory.getProject();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiFile firstFile = null;
                            for (PsiElement element : elements) {
                                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)element, newName, targetDirectory);
                                if (firstFile != null) continue;
                                firstFile = f;
                            }
                            if (firstFile != null) {
                                CopyHandler.updateSelectionInActiveProjectView(firstFile, project, doClone);
                                if (!(firstFile instanceof PsiBinaryFile)) {
                                    EditorHelper.openInEditor(firstFile);
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                                        }
                                    });
                                }
                            }
                        }
                        catch (IncorrectOperationException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                                }
                            });
                        }
                        catch (IOException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                                }
                            });
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, doClone ? RefactoringBundle.message((String)"copy,handler.clone.files.directories") : RefactoringBundle.message((String)"copy.handler.copy.files.directories"), null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler.copyToDirectory must not be null");
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler.copyToDirectory must not be null");
        }
        if (elementToCopy instanceof PsiFile) {
            PsiFile file = (PsiFile)elementToCopy;
            String name = newName == null ? file.getName() : newName;
            PsiFile existing = targetDirectory.findFile(name);
            if (existing != null) {
                int selection = Messages.showDialog((String)String.format("File '%s' already exists in directory '%s'", name, targetDirectory.getVirtualFile().getPath()), (String)"Copy", (String[])new String[]{"Overwrite", "Skip"}, (int)0, (Icon)Messages.getQuestionIcon());
                if (selection == 0 && file != existing) {
                    existing.delete();
                } else {
                    return null;
                }
            }
            return targetDirectory.copyFileFrom(name, file);
        }
        if (elementToCopy instanceof PsiDirectory) {
            PsiElement[] children;
            PsiDirectory existing;
            PsiDirectory directory = (PsiDirectory)elementToCopy;
            if (directory.equals(targetDirectory)) {
                return null;
            }
            if (newName == null) {
                newName = directory.getName();
            }
            final PsiDirectory subdirectory = (existing = targetDirectory.findSubdirectory(newName)) != null ? existing : targetDirectory.createSubdirectory(newName);
            VfsUtil.doActionAndRestoreEncoding((VirtualFile)directory.getVirtualFile(), (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                public VirtualFile compute() {
                    return subdirectory.getVirtualFile();
                }
            });
            PsiFile firstFile = null;
            for (PsiElement child : children = directory.getChildren()) {
                PsiFileSystemItem item = (PsiFileSystemItem)child;
                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory(item, item.getName(), subdirectory);
                if (firstFile != null) continue;
                firstFile = f;
            }
            return firstFile;
        }
        throw new IllegalArgumentException("unexpected elementToCopy: " + elementToCopy);
    }
}

