/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeSignatureTargetUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeSignature.refactoring.name");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeSignatureHandler.invoke must not be null");
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiMember element = ChangeSignatureTargetUtil.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        ChangeSignatureHandler.invokeOnElement(project, editor, (PsiElement)element);
    }

    private static void invokeOnElement(Project project, Editor editor, PsiElement element) {
        if (element instanceof PsiMethod) {
            ChangeSignatureHandler.invoke((PsiMethod)element, project, editor);
        } else if (element instanceof PsiClass) {
            ChangeSignatureHandler.invoke((PsiClass)element, editor);
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeSignatureHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeSignatureHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        ChangeSignatureHandler.invokeOnElement(project, editor, elements[0]);
    }

    private static void invoke(PsiMethod method, Project project, @Nullable Editor editor) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        PsiMethod newMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        if (!newMethod.equals(method)) {
            ChangeSignatureHandler.invoke(newMethod, project, editor);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiReferenceExpression refExpr = editor != null ? TargetElementUtil.findReferenceExpression(editor) : null;
        ChangeSignatureDialog dialog = new ChangeSignatureDialog(project, method, containingClass != null && !containingClass.isInterface(), refExpr);
        dialog.show();
    }

    private static void invoke(PsiClass aClass, Editor editor) {
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        Project project = aClass.getProject();
        if (typeParameterList == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"changeClassSignature.no.type.parameters"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeClassSignature");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(aClass);
        dialog.show();
    }
}

