/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.cache.TypeInfo");
    public final StringRef text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    public static final TIntObjectHashMap<String> ourIndexFrequentType = new TIntObjectHashMap();
    private static final TObjectIntHashMap<String> ourFrequentTypeIndex = new TObjectIntHashMap();
    private final List<PsiAnnotationStub> myAnnotationStubs;
    private static final TypeInfo NULL;
    private static final int NULL_FLAGS = 15;

    private static void registerFrequentType(String typeText) {
        int index = ourFrequentTypeIndex.size() + 1;
        assert (index < 15);
        ourFrequentTypeIndex.put((Object)typeText, index);
        ourIndexFrequentType.put(index, (Object)typeText);
    }

    public TypeInfo(StringRef text, byte arrayCount, boolean ellipsis, @NotNull List<PsiAnnotationStub> annotationStubs) {
        if (annotationStubs == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.<init> must not be null");
        }
        this.text = text;
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
        this.myAnnotationStubs = annotationStubs;
    }

    public TypeInfo(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.<init> must not be null");
        }
        this.text = typeInfo.text;
        this.arrayCount = typeInfo.arrayCount;
        this.isEllipsis = typeInfo.isEllipsis;
        this.myAnnotationStubs = new SmartList(typeInfo.myAnnotationStubs);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeInfo create(PsiType type, PsiTypeElement typeElement) {
        List<PsiAnnotationStub> list;
        String text;
        TypeInfo typeInfo;
        if (type == null) {
            typeInfo = NULL;
            if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.create must not return null");
            return typeInfo;
        }
        boolean isEllipsis = type instanceof PsiEllipsisType;
        int arrayCount = type.getArrayDimensions();
        if (typeElement != null) {
            while (typeElement.getFirstChild() instanceof PsiTypeElement) {
                typeElement = (PsiTypeElement)typeElement.getFirstChild();
            }
            text = typeElement instanceof PsiCompiledElement ? ((ClsTypeElementImpl)typeElement).getCanonicalText() : typeElement.getText();
        } else {
            type = type.getDeepComponentType();
            text = type.getInternalCanonicalText();
        }
        PsiAnnotation[] annotations = type.getAnnotations();
        if (annotations.length == 0) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(annotations.length);
            for (PsiAnnotation annotation : annotations) {
                PsiAnnotationStub stub = JavaStubElementTypes.ANNOTATION.createStub(annotation, null);
                list.add(stub);
            }
        }
        if ((typeInfo = new TypeInfo(StringRef.fromString((String)text), (byte)arrayCount, isEllipsis, list)) != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.create must not return null");
    }

    @NotNull
    public static TypeInfo fromString(String typeText, boolean isEllipsis) {
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        StringRef text = StringRef.fromString((String)typeText);
        TypeInfo typeInfo = new TypeInfo(text, arrayCount, isEllipsis, Collections.<PsiAnnotationStub>emptyList());
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.fromString must not return null");
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        if (typeText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.fromString must not be null");
        }
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        TypeInfo typeInfo = TypeInfo.fromString(typeText, isEllipsis);
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.fromString must not return null");
        }
        return typeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeInfo readTYPE(StubInputStream record, StubElement parentStub) throws IOException {
        List<PsiAnnotationStub> annotationStubs;
        boolean annotationsArePresent;
        TypeInfo typeInfo;
        int flags = 0xFF & record.readByte();
        if (flags == 15) {
            typeInfo = NULL;
            if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.readTYPE must not return null");
            return typeInfo;
        }
        int frequentIndex = 0xF & flags;
        byte arrayCount = (flags & 0x20) != 0 ? record.readByte() : (byte)0;
        boolean isEllipsis = (flags & 0x40) != 0;
        StringRef text = frequentIndex == 0 ? record.readName() : StringRef.fromString((String)((String)ourIndexFrequentType.get(frequentIndex)));
        boolean bl = annotationsArePresent = (flags & 0x10) != 0;
        if (annotationsArePresent) {
            int size = 0xFF & record.readByte();
            annotationStubs = new ArrayList<PsiAnnotationStub>(size);
            for (int i = 0; i < size; ++i) {
                PsiAnnotationStub annotationStub = JavaStubElementTypes.ANNOTATION.deserialize(record, parentStub);
                annotationStubs.add(annotationStub);
            }
        } else {
            annotationStubs = Collections.emptyList();
        }
        if ((typeInfo = new TypeInfo(text, arrayCount, isEllipsis, annotationStubs)) != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.readTYPE must not return null");
    }

    public static void writeTYPE(StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.writeTYPE must not be null");
        }
        if (typeInfo == NULL) {
            dataStream.writeByte(15);
            return;
        }
        boolean isEllipsis = typeInfo.isEllipsis;
        String text = typeInfo.text.getString();
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.get((Object)text);
        LOG.assertTrue(frequentIndex < 15, (Object)frequentIndex);
        List<PsiAnnotationStub> annotations = typeInfo.myAnnotationStubs;
        boolean annotationsArePresent = !annotations.isEmpty();
        int flags = (isEllipsis ? 1 : 0) << 6 | (arrayCount == 0 ? 0 : 1) << 5 | (annotationsArePresent ? 1 : 0) << 4 | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte((int)arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text);
        }
        if (annotationsArePresent) {
            LOG.assertTrue(annotations.size() < 256, (Object)annotations.size());
            dataStream.writeByte(annotations.size());
            for (PsiAnnotationStub annotation : annotations) {
                dataStream.writeUTFFast(annotation.getText());
            }
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.createTypeText must not be null");
        }
        if (typeInfo == NULL) {
            return null;
        }
        if (typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0 && typeInfo.myAnnotationStubs.isEmpty()) {
            return typeInfo.text.getString();
        }
        String text = typeInfo.text.getString();
        StringBuilder buf = new StringBuilder(text.length());
        for (PsiAnnotationStub stub : typeInfo.myAnnotationStubs) {
            buf.append(stub.getText() + " ");
        }
        buf.append(text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i = 0; i < arrayCount; ++i) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return buf.toString();
    }

    public void addAnnotation(PsiAnnotationStub annotation) {
        this.myAnnotationStubs.add(annotation);
    }

    static {
        TypeInfo.registerFrequentType("boolean");
        TypeInfo.registerFrequentType("byte");
        TypeInfo.registerFrequentType("char");
        TypeInfo.registerFrequentType("double");
        TypeInfo.registerFrequentType("float");
        TypeInfo.registerFrequentType("int");
        TypeInfo.registerFrequentType("long");
        TypeInfo.registerFrequentType("null");
        TypeInfo.registerFrequentType("short");
        TypeInfo.registerFrequentType("void");
        TypeInfo.registerFrequentType("Object");
        TypeInfo.registerFrequentType("java.lang.Object");
        TypeInfo.registerFrequentType("String");
        TypeInfo.registerFrequentType("java.lang.String");
        NULL = new TypeInfo(null, 0, false, Collections.<PsiAnnotationStub>emptyList());
    }
}

