/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;

class VcsWrapper {
    private final AbstractVcs myOriginal;

    public VcsWrapper(AbstractVcs original) {
        this.myOriginal = original;
    }

    public AbstractVcs getOriginal() {
        return this.myOriginal;
    }

    public String toString() {
        return this.getDisplayName(this.myOriginal);
    }

    protected String getDisplayName(AbstractVcs vcs) {
        if (vcs == null) {
            return VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]);
        }
        return vcs.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsWrapper that = (VcsWrapper)o;
        return !(this.myOriginal == null ? that.myOriginal != null : !this.myOriginal.equals(that.myOriginal));
    }

    public int hashCode() {
        return this.myOriginal != null ? this.myOriginal.hashCode() : 0;
    }

    public static VcsWrapper fromName(Project project, String name) {
        if (name.length() == 0) {
            return new VcsWrapper(null);
        }
        return new VcsWrapper(ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(name));
    }
}

