/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

public class ChannelStatus
implements Comparable<ChannelStatus> {
    public static final ChannelStatus EAP = new ChannelStatus(0, "eap", "Early Access Program");
    public static final ChannelStatus MILESTONE = new ChannelStatus(1, "milestone", "Milestone Releases");
    public static final ChannelStatus BETA = new ChannelStatus(2, "beta", "Beta Releases or Public Previews");
    public static final ChannelStatus RELEASE = new ChannelStatus(3, "release", "New Major Version Releases");
    private final int myOrder;
    private final String myCode;
    private final String myDisplayName;

    private ChannelStatus(int order, String code, String displayName) {
        this.myOrder = order;
        this.myCode = code;
        this.myDisplayName = displayName;
    }

    public static ChannelStatus fromCode(String code) {
        if ("eap".equals(code)) {
            return EAP;
        }
        if ("milestone".equals(code)) {
            return MILESTONE;
        }
        if ("beta".equals(code)) {
            return BETA;
        }
        if ("release".equals(code)) {
            return RELEASE;
        }
        return EAP;
    }

    @Override
    public int compareTo(ChannelStatus o) {
        return this.myOrder - o.myOrder;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }
}

