/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class InheritedJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements InheritedJdkOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    @NonNls
    static final String ENTRY_TYPE = "inheritedJdk";
    private final MyJdkTableListener myJdkTableListener = new MyJdkTableListener();
    private final MyProjectJdkListener myListener = new MyProjectJdkListener();

    InheritedJdkOrderEntryImpl(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myProjectRootManagerImpl.addProjectJdkListener(this.myListener);
        this.myProjectRootManagerImpl.addJdkTableListener(this.myJdkTableListener);
        this.init();
    }

    InheritedJdkOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        this(rootModel, projectRootManager);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException(element.getName());
        }
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new InheritedJdkOrderEntryImpl(rootModel, projectRootManager);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitInheritedJdkOrderEntry((InheritedJdkOrderEntry)this, initialValue);
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element orderEntryElement = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        rootElement.addContent(orderEntryElement);
    }

    public Sdk getJdk() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdk(project);
    }

    public String getJdkName() {
        Project project = this.getRootModel().getModule().getProject();
        return this.getRootModel().getConfigurationAccessor().getProjectSdkName(project);
    }

    @Override
    protected RootProvider getRootProvider() {
        Sdk projectJdk = this.myProjectRootManagerImpl.getProjectJdk();
        return projectJdk == null ? null : projectJdk.getRootProvider();
    }

    public String getPresentableName() {
        return "< " + this.getJdkName() + " >";
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myProjectRootManagerImpl.removeJdkTableListener(this.myJdkTableListener);
        this.myProjectRootManagerImpl.removeProjectJdkListener(this.myListener);
    }

    private class MyProjectJdkListener
    implements ProjectRootManagerEx.ProjectJdkListener {
        private MyProjectJdkListener() {
        }

        @Override
        public void projectJdkChanged() {
            InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyJdkTableListener
    implements ProjectJdkTable.Listener {
        private MyJdkTableListener() {
        }

        public void jdkRemoved(Sdk jdk) {
            if (jdk.equals(InheritedJdkOrderEntryImpl.this.getJdk())) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkAdded(Sdk jdk) {
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        public void jdkNameChanged(Sdk jdk, String previousName) {
            if (this.isAffectedByJdk(jdk)) {
                InheritedJdkOrderEntryImpl.this.updateFromRootProviderAndSubscribe();
            }
        }

        private boolean isAffectedByJdk(Sdk jdk) {
            return jdk.getName().equals(InheritedJdkOrderEntryImpl.this.getJdkName());
        }
    }
}

