/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.DefaultSearchableConfigurable;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ControlPanelMnemonicsUtil;
import com.intellij.openapi.options.ex.ProjectConfigurableWrapper;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LabeledIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ControlPanelSettingsEditor
extends DialogWrapper {
    private static final int ICONS_PER_ROW = 8;
    private static final Insets ICON_INSETS = new Insets(2, 2, 2, 2);
    protected final Project myProject;
    private final ConfigurableGroup[] myGroups;
    private JPanel myPanel;
    private Configurable myKeypressedConfigurable = null;
    private int mySelectedRow = 0;
    private int mySelectedColumn = 0;
    private int mySelectedGroup = 0;
    private Set<Configurable> myOptionContainers = null;
    private SearchUtil.ConfigurableSearchTextField mySearchField;
    private final Alarm mySearchUpdater = new Alarm();
    private final JBPopup[] myPopup = new JBPopup[2];

    public ControlPanelSettingsEditor(Project project, ConfigurableGroup[] groups, Configurable preselectedConfigurable) {
        super(project, true);
        this.myProject = project;
        this.myGroups = groups;
        this.setTitle(OptionsBundle.message((String)"settings.panel.title", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.init();
        if (preselectedConfigurable != null) {
            this.selectConfigurable(preselectedConfigurable);
            this.editConfigurable(preselectedConfigurable);
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.options.ex.ControlPanelSettingsEditor";
    }

    protected Action[] createActions() {
        return new Action[]{this.getCancelAction()};
    }

    @NonNls
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("preferences");
    }

    protected Action[] createLeftSideActions() {
        return new Action[]{new SwitchToClassicViewAction()};
    }

    protected JComponent createCenterPanel() {
        this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (int i = 0; i < this.myGroups.length; ++i) {
            ConfigurableGroup group = this.myGroups[i];
            this.myPanel.add(this.createGroupComponent(group, i));
        }
        final MyKeyAdapter keyAdapter = new MyKeyAdapter();
        this.myPanel.addKeyListener(keyAdapter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ControlPanelSettingsEditor.this.myPanel.removeKeyListener(keyAdapter);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)panel);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    private void selectConfigurable(Configurable configurable) {
        for (int g = 0; g < this.myGroups.length; ++g) {
            ConfigurableGroup group = this.myGroups[g];
            Configurable[] allConfigurables = group.getConfigurables();
            int count = allConfigurables.length;
            int rowCount = ControlPanelSettingsEditor.getRowCount(count);
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int n = i * 8 + j;
                    if (n >= count || configurable != allConfigurables[n]) continue;
                    this.mySelectedGroup = g;
                    this.mySelectedRow = i;
                    this.mySelectedColumn = j;
                    return;
                }
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    private JComponent createGroupComponent(ConfigurableGroup group, int groupIdx) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        TitledSeparator separator = new TitledSeparator();
        separator.setText(group.getDisplayName());
        separator.setTitleFont(new JLabel().getFont().deriveFont(20.0f));
        panel.add((Component)separator);
        Configurable[] allConfigurables = group.getConfigurables();
        int count = allConfigurables.length;
        int rowCount = ControlPanelSettingsEditor.getRowCount(count);
        JPanel toolBar = new JPanel(new GridLayout(0, 8));
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i * 8 + j;
                if (n >= count) continue;
                toolBar.add(this.createActionButton(allConfigurables[n], ControlPanelSettingsEditor.getShortcut(n, groupIdx), groupIdx, j, i));
            }
        }
        panel.add(toolBar);
        panel.add(new JPanel());
        return panel;
    }

    private static int getRowCount(int count) {
        return count / 8 + (count % 8 == 0 ? 0 : 1);
    }

    private static KeyStroke getShortcut(int actionIdx, int groupIdx) {
        int mnemonic = ControlPanelSettingsEditor.getMnemonicByIndex(actionIdx, groupIdx);
        if (mnemonic == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(mnemonic, 0);
    }

    private static int getMnemonicByIndex(int idx, int groupIdx) {
        if (groupIdx == 0) {
            if (idx >= 0 && idx < 9) {
                return 49 + idx;
            }
            if (idx == 9) {
                return 48;
            }
            return 0;
        }
        if (groupIdx == 1 && idx >= 0 && idx < 25) {
            return 65 + idx;
        }
        return 0;
    }

    @Nullable
    private Configurable getSelectedConfigurable() {
        if (this.mySelectedColumn == -1 || this.mySelectedRow == -1 || this.mySelectedGroup == -1) {
            return null;
        }
        int index = this.mySelectedColumn + this.mySelectedRow * 8;
        Configurable[] configurables = this.myGroups[this.mySelectedGroup].getConfigurables();
        if (index >= configurables.length) {
            return null;
        }
        return configurables[index];
    }

    private JComponent createActionButton(Configurable configurable, KeyStroke shortcut, int groupIdx, int column, int row) {
        return new MyActionButton(configurable, shortcut, groupIdx, row, column);
    }

    private void editConfigurable(Configurable configurable) {
        Object actualConfigurable = configurable;
        if (configurable instanceof ProjectComponent) {
            actualConfigurable = new ProjectConfigurableWrapper(this.myProject, configurable);
        }
        if (actualConfigurable instanceof SearchableConfigurable) {
            actualConfigurable = new DefaultSearchableConfigurable((SearchableConfigurable)actualConfigurable);
            ((DefaultSearchableConfigurable)actualConfigurable).clearSearch();
            final String filter = this.mySearchField.getText();
            if (filter != null && filter.length() > 0) {
                final DefaultSearchableConfigurable finalConfigurable = (DefaultSearchableConfigurable)actualConfigurable;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        finalConfigurable.enableSearch(filter);
                    }
                });
            }
        }
        SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(this.myProject, (Configurable)actualConfigurable, SingleConfigurableEditor.createDimensionKey(configurable));
        configurableEditor.show();
    }

    public void dispose() {
        for (JBPopup popup : this.myPopup) {
            if (popup == null) continue;
            popup.cancel();
        }
        this.mySearchUpdater.cancelAllRequests();
        this.myOptionContainers = null;
        super.dispose();
    }

    protected JComponent createNorthPanel() {
        Consumer<String> selectConfigurable = new Consumer<String>(){

            public void consume(String configurableId) {
                if (ControlPanelSettingsEditor.this.myOptionContainers != null) {
                    for (Configurable configurable : ControlPanelSettingsEditor.this.myOptionContainers) {
                        if (!Comparing.strEqual((String)configurable.getDisplayName(), (String)configurableId)) continue;
                        ControlPanelSettingsEditor.this.editConfigurable(configurable);
                        return;
                    }
                }
            }
        };
        final SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        final JPanel panel = new JPanel(new GridBagLayout());
        this.mySearchField = new SearchUtil.ConfigurableSearchTextField();
        final DocumentAdapter docAdapter = new DocumentAdapter((Consumer)selectConfigurable){
            final /* synthetic */ Consumer val$selectConfigurable;
            {
                this.val$selectConfigurable = consumer;
            }

            protected void textChanged(final DocumentEvent e) {
                ControlPanelSettingsEditor.this.mySearchUpdater.cancelAllRequests();
                ControlPanelSettingsEditor.this.mySearchUpdater.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        String searchPattern = ControlPanelSettingsEditor.this.mySearchField.getText();
                        if (searchPattern != null && searchPattern.length() > 0) {
                            ControlPanelSettingsEditor.this.myOptionContainers = optionsRegistrar.getConfigurables(ControlPanelSettingsEditor.this.myGroups, e.getType(), ControlPanelSettingsEditor.this.myOptionContainers, searchPattern, ControlPanelSettingsEditor.this.myProject).getContentHits();
                        } else {
                            ControlPanelSettingsEditor.this.myOptionContainers = null;
                        }
                        SearchUtil.showHintPopup(ControlPanelSettingsEditor.this.mySearchField, ControlPanelSettingsEditor.this.myPopup, ControlPanelSettingsEditor.this.mySearchUpdater, (Consumer<String>)val$selectConfigurable, ControlPanelSettingsEditor.this.myProject);
                        ControlPanelSettingsEditor.this.myPanel.repaint();
                    }
                }, 300, ModalityState.defaultModalityState());
            }
        };
        this.mySearchField.addDocumentListener((DocumentListener)docAdapter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (ControlPanelSettingsEditor.this.mySearchField != null) {
                    panel.remove((Component)((Object)ControlPanelSettingsEditor.this.mySearchField));
                    ControlPanelSettingsEditor.this.mySearchField.removeDocumentListener((DocumentListener)docAdapter);
                    ControlPanelSettingsEditor.this.mySearchField = null;
                }
            }
        });
        SearchUtil.registerKeyboardNavigation(this.mySearchField, this.myPopup, this.mySearchUpdater, selectConfigurable, this.myProject);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)Box.createHorizontalBox(), gc);
        ++gc.gridx;
        gc.weightx = 0.0;
        gc.fill = 0;
        JLabel label = new JLabel(IdeBundle.message((String)"search.textfield.title", (Object[])new Object[0]));
        panel.add((Component)label, gc);
        label.setLabelFor((Component)((Object)this.mySearchField));
        ++gc.gridx;
        int height = this.mySearchField.getPreferredSize().height;
        this.mySearchField.setPreferredSize(new Dimension(100, height));
        panel.add((Component)((Object)this.mySearchField), gc);
        return panel;
    }

    private class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent e) {
            try {
                if (e.getKeyCode() == 10) {
                    ControlPanelSettingsEditor.this.myKeypressedConfigurable = ControlPanelSettingsEditor.this.getSelectedConfigurable();
                    return;
                }
                int code = e.getKeyCode();
                if (code == 38 || code == 40 || code == 39 || code == 37) {
                    int idx;
                    if (ControlPanelSettingsEditor.this.getSelectedConfigurable() == null) {
                        ControlPanelSettingsEditor.this.mySelectedColumn = 0;
                        ControlPanelSettingsEditor.this.mySelectedRow = 0;
                        ControlPanelSettingsEditor.this.mySelectedGroup = 0;
                        return;
                    }
                    int xShift = 0;
                    int yShift = 0;
                    if (code == 38) {
                        yShift = -1;
                    } else if (code == 40) {
                        yShift = 1;
                    } else {
                        xShift = code == 37 ? -1 : 1;
                    }
                    int newColumn = ControlPanelSettingsEditor.this.mySelectedColumn + xShift;
                    int newRow = ControlPanelSettingsEditor.this.mySelectedRow + yShift;
                    int newGroup = ControlPanelSettingsEditor.this.mySelectedGroup;
                    if (newColumn < 0) {
                        newColumn = 0;
                    }
                    if (newColumn >= 8) {
                        newColumn = 7;
                    }
                    if ((idx = newColumn + newRow * 8) >= ControlPanelSettingsEditor.this.myGroups[newGroup].getConfigurables().length) {
                        if (yShift > 0) {
                            newRow = 0;
                            if (++newGroup >= ControlPanelSettingsEditor.this.myGroups.length) {
                                return;
                            }
                            idx = newColumn + newRow * 8;
                            if (idx >= ControlPanelSettingsEditor.this.myGroups[newGroup].getConfigurables().length) {
                                return;
                            }
                        } else if (xShift > 0) {
                            return;
                        }
                    }
                    if (yShift < 0 && idx < 0) {
                        if (--newGroup < 0) {
                            return;
                        }
                        int rowCount = ControlPanelSettingsEditor.getRowCount(ControlPanelSettingsEditor.this.myGroups[newGroup].getConfigurables().length);
                        newRow = rowCount - 1;
                        idx = newColumn + newRow * 8;
                        if (idx >= ControlPanelSettingsEditor.this.myGroups[newGroup].getConfigurables().length) {
                            if (newRow <= 0) {
                                return;
                            }
                            --newRow;
                        }
                    }
                    ControlPanelSettingsEditor.this.mySelectedColumn = newColumn;
                    ControlPanelSettingsEditor.this.mySelectedRow = newRow;
                    ControlPanelSettingsEditor.this.mySelectedGroup = newGroup;
                    return;
                }
                ControlPanelSettingsEditor.this.myKeypressedConfigurable = ControlPanelMnemonicsUtil.getConfigurableFromMnemonic(e, ControlPanelSettingsEditor.this.myGroups);
            }
            finally {
                ControlPanelSettingsEditor.this.myPanel.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (ControlPanelSettingsEditor.this.myKeypressedConfigurable != null) {
                e.consume();
                ControlPanelSettingsEditor.this.selectConfigurable(ControlPanelSettingsEditor.this.myKeypressedConfigurable);
                ControlPanelSettingsEditor.this.editConfigurable(ControlPanelSettingsEditor.this.myKeypressedConfigurable);
                ControlPanelSettingsEditor.this.myKeypressedConfigurable = null;
                ControlPanelSettingsEditor.this.myPanel.repaint();
            }
        }
    }

    private class SwitchToClassicViewAction
    extends AbstractAction {
        public SwitchToClassicViewAction() {
            this.putValue("Name", OptionsBundle.message((String)"control.panel.classic.view.button", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlPanelSettingsEditor.this.close(0);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showExplorerOptions(ControlPanelSettingsEditor.this.myProject, ControlPanelSettingsEditor.this.myGroups);
                }
            }, ModalityState.NON_MODAL);
        }
    }

    private class MyActionButton
    extends JComponent
    implements ActionButtonComponent {
        private final Configurable myConfigurable;
        private final int myGroupIdx;
        private final int myRowIdx;
        private final int myColumnIdx;
        private boolean myIsMouseInside = false;
        private final Icon myIcon;
        private final KeyStroke myShortcut;

        public MyActionButton(Configurable configurable, KeyStroke shortcut, int groupIdx, int rowIdx, int columnIdx) {
            this.myConfigurable = configurable;
            this.myGroupIdx = groupIdx;
            this.myRowIdx = rowIdx;
            this.myColumnIdx = columnIdx;
            this.myShortcut = shortcut;
            this.myIcon = this.createIcon();
            this.setToolTipText(null);
            this.setupListeners();
        }

        private Icon createIcon() {
            Icon icon = this.myConfigurable.getIcon();
            if (icon == null) {
                icon = IconLoader.getIcon((String)"/general/configurableDefault.png");
            }
            String displayName = this.myConfigurable.getDisplayName();
            return new LabeledIcon(icon, displayName, this.myShortcut == null ? null : " (" + KeyEvent.getKeyText(this.myShortcut.getKeyCode()) + ")");
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon.getIconWidth() + ICON_INSETS.left + ICON_INSETS.right, this.myIcon.getIconHeight() + ICON_INSETS.top + ICON_INSETS.bottom);
        }

        @Override
        protected void paintComponent(Graphics g) {
            UIUtil.applyRenderingHints((Graphics)g);
            super.paintComponent(g);
            ActionButtonLook look = ActionButtonLook.IDEA_LOOK;
            look.paintBackground(g, this);
            look.paintIcon(g, this, this.myIcon);
            look.paintBorder(g, this);
        }

        public int getPopState() {
            if (ControlPanelSettingsEditor.this.myKeypressedConfigurable == this.myConfigurable) {
                return this.myIsMouseInside ? -1 : 1;
            }
            if (ControlPanelSettingsEditor.this.myKeypressedConfigurable != null) {
                return 0;
            }
            Configurable selectedConfigurable = ControlPanelSettingsEditor.this.getSelectedConfigurable();
            if (selectedConfigurable == this.myConfigurable) {
                return 1;
            }
            return 0;
        }

        private void setupListeners() {
            final MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MyActionButton.this.myIsMouseInside = true;
                    ControlPanelSettingsEditor.this.myKeypressedConfigurable = MyActionButton.this.myConfigurable;
                    ControlPanelSettingsEditor.this.myPanel.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (ControlPanelSettingsEditor.this.myKeypressedConfigurable == MyActionButton.this.myConfigurable && MyActionButton.this.myIsMouseInside) {
                        ControlPanelSettingsEditor.this.myKeypressedConfigurable = null;
                        ControlPanelSettingsEditor.this.editConfigurable(MyActionButton.this.myConfigurable);
                    } else {
                        ControlPanelSettingsEditor.this.myKeypressedConfigurable = null;
                    }
                    MyActionButton.this.myIsMouseInside = false;
                    ControlPanelSettingsEditor.this.myPanel.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MyActionButton.this.myIsMouseInside = true;
                    ControlPanelSettingsEditor.this.myPanel.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MyActionButton.this.myIsMouseInside = false;
                    ControlPanelSettingsEditor.this.myPanel.repaint();
                }
            };
            this.addMouseListener(mouseAdapter);
            Disposer.register((Disposable)ControlPanelSettingsEditor.this.myDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    MyActionButton.this.removeMouseListener(mouseAdapter);
                }
            });
            final MouseMotionListener motionListener = new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ControlPanelSettingsEditor.this.mySelectedColumn = MyActionButton.this.myColumnIdx;
                    ControlPanelSettingsEditor.this.mySelectedRow = MyActionButton.this.myRowIdx;
                    ControlPanelSettingsEditor.this.mySelectedGroup = MyActionButton.this.myGroupIdx;
                    ControlPanelSettingsEditor.this.myPanel.repaint();
                }
            };
            this.addMouseMotionListener(motionListener);
            Disposer.register((Disposable)ControlPanelSettingsEditor.this.myDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    MyActionButton.this.removeMouseMotionListener(motionListener);
                }
            });
        }
    }
}

