/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String COMMENT_LINE_FOR_TEST_MODE_MACRO = "$COMMENT_LINE_FOR_TEST_MODE$";
    private static final String LOGDIR_MACRO = "$LOG_DIR$";
    private boolean myInitialized = false;
    private static final LoggerFactory ourInstance = new LoggerFactory();
    public static final String LOG_DIR = "log";

    public static LoggerFactory getInstance() {
        return ourInstance;
    }

    private LoggerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(String name) {
        LoggerFactory loggerFactory = this;
        synchronized (loggerFactory) {
            try {
                if (!this.isInitialized()) {
                    this.init();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new IdeaLogger(Logger.getLogger((String)name));
        }
    }

    private void init() {
        try {
            System.setProperty("log4j.defaultInitOverride", "true");
            File logXmlFile = FileUtil.findFirstThatExist((String[])new String[]{PathManager.getHomePath() + "/bin/log.xml", PathManager.getHomePath() + "/community/bin/log.xml"});
            if (logXmlFile == null) {
                throw new RuntimeException("log.xml file does not exist! Path: [ $home/bin/log.xml]");
            }
            String text = new String(FileUtil.loadFileText((File)logXmlFile));
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOGDIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
            if ("true".equals(System.getProperty("idea.test.test_mode"))) {
                text = LoggerFactory.commentTestModeLines(text);
            }
            File file = new File(PathManager.getLogPath());
            file.mkdirs();
            new DOMConfigurator().doConfigure((Reader)new StringReader(text), LogManager.getLoggerRepository());
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInitialized() {
        return this.myInitialized;
    }

    private static String commentTestModeLines(String text) {
        String result = text;
        int index = text.indexOf(COMMENT_LINE_FOR_TEST_MODE_MACRO);
        if (index != -1) {
            String str1 = result.substring(0, index);
            String str2 = result.substring(index);
            int firstLineChar = Math.max(str1.lastIndexOf(10), str1.lastIndexOf(13));
            int lastLineChar = str2.indexOf(10);
            int lastLineChar2 = str2.indexOf(13);
            if (lastLineChar == -1) {
                lastLineChar = lastLineChar2;
            } else if (lastLineChar2 != -1) {
                lastLineChar = Math.min(lastLineChar, lastLineChar2);
            }
            if (firstLineChar != -1) {
                str1 = str1.substring(0, firstLineChar);
            }
            if (lastLineChar != -1) {
                str2 = str2.substring(lastLineChar);
            }
            result = LoggerFactory.commentTestModeLines(str1) + LoggerFactory.commentTestModeLines(str2);
        }
        return result;
    }
}

