/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionOptionsPanel;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworksTree;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelImpl;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSupportForFrameworksPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksStep");
    @NonNls
    private static final String UNCHECKED_CARD = "unchecked";
    @NonNls
    private static final String EMPTY_CARD = "empty";
    private JPanel myMainPanel;
    private JPanel myFrameworksPanel;
    private List<List<FrameworkSupportNode>> myGroups;
    private final LibrariesContainer myLibrariesContainer;
    private final Computable<String> myBaseDirForLibrariesGetter;
    private final List<FrameworkSupportProvider> myProviders;
    private final LibraryDownloadingMirrorsMap myMirrorsMap;
    private final FrameworkSupportModelImpl myModel;
    private JPanel myOptionsPanel;
    private FrameworksTree myFrameworksTree;
    private Set<String> myInitializedOptionsPanelIds;
    private FrameworkSupportNode myLastSelectedNode;
    private JLabel myTickCheckboxLabel;

    public AddSupportForFrameworksPanel(List<FrameworkSupportProvider> providers, @NotNull LibrariesContainer librariesContainer, @Nullable ModuleBuilder builder, Computable<String> baseDirForLibrariesGetter) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel.<init> must not be null");
        }
        this.$$$setupUI$$$();
        this.myInitializedOptionsPanelIds = new HashSet<String>();
        this.myLibrariesContainer = librariesContainer;
        this.myBaseDirForLibrariesGetter = baseDirForLibrariesGetter;
        this.myProviders = providers;
        this.myModel = new FrameworkSupportModelImpl(this.myLibrariesContainer.getProject(), builder);
        this.createNodes();
        this.myMirrorsMap = this.createMirrorsMap();
        Splitter splitter = new Splitter(false, 0.3f, 0.1f, 0.7f);
        this.myFrameworksTree = new FrameworksTree(this.myGroups){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (!(node instanceof FrameworkSupportNode)) {
                    return;
                }
                FrameworkSupportNode frameworkSupportNode = (FrameworkSupportNode)node;
                frameworkSupportNode.setConfigurableComponentEnabled(node.isChecked());
                AddSupportForFrameworksPanel.this.updateOptionsPanel();
                frameworkSupportNode.getConfigurable().onFrameworkSelectionChanged(node.isChecked());
                AddSupportForFrameworksPanel.this.myModel.onFrameworkSelectionChanged(frameworkSupportNode);
            }
        };
        this.myFrameworksTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AddSupportForFrameworksPanel.this.onSelectionChanged();
            }
        });
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myFrameworksTree)));
        this.myOptionsPanel = new JPanel(new CardLayout());
        this.myOptionsPanel.add(EMPTY_CARD, new JPanel());
        JPanel uncheckedLabelPanel = new JPanel(new BorderLayout());
        this.myTickCheckboxLabel = new JLabel("Tick checkbox");
        uncheckedLabelPanel.add("North", this.myTickCheckboxLabel);
        this.myOptionsPanel.add(UNCHECKED_CARD, uncheckedLabelPanel);
        splitter.setSecondComponent((JComponent)this.myOptionsPanel);
        this.myFrameworksPanel.add((Component)splitter, "Center");
    }

    private void onSelectionChanged() {
        FrameworkSupportNode selectedNode;
        if (!this.myFrameworksTree.isProcessingMouseEventOnCheckbox()) {
            this.updateOptionsPanel();
        }
        if (!Comparing.equal((Object)((Object)(selectedNode = this.getSelectedNode())), (Object)((Object)this.myLastSelectedNode))) {
            LibraryCompositionOptionsPanel newOptionsPanel;
            this.applyLibraryOptionsForSelected();
            this.myLastSelectedNode = selectedNode;
            if (selectedNode != null && (newOptionsPanel = selectedNode.getLibraryCompositionOptionsPanel(this.myLibrariesContainer, this.myMirrorsMap)) != null) {
                newOptionsPanel.updateRepositoriesMirrors(this.myMirrorsMap);
            }
        }
    }

    private void applyLibraryOptionsForSelected() {
        LibraryCompositionOptionsPanel optionsPanel;
        if (this.myLastSelectedNode != null && (optionsPanel = this.myLastSelectedNode.getLibraryCompositionOptionsPanel(this.myLibrariesContainer, this.myMirrorsMap)) != null) {
            optionsPanel.saveSelectedRepositoriesMirrors(this.myMirrorsMap);
            optionsPanel.apply();
        }
    }

    private void updateOptionsPanel() {
        FrameworkSupportNode node = this.getSelectedNode();
        if (node != null) {
            if (node.isChecked()) {
                this.initializeOptionsPanel(node);
                this.showCard(node.getProvider().getId());
            } else {
                this.myTickCheckboxLabel.setText("Select check box to add '" + node.getTitle() + "' support");
                this.showCard(UNCHECKED_CARD);
            }
        } else {
            this.showCard(EMPTY_CARD);
        }
    }

    @Nullable
    private FrameworkSupportNode getSelectedNode() {
        FrameworkSupportNode[] nodes = (FrameworkSupportNode[])this.myFrameworksTree.getSelectedNodes(FrameworkSupportNode.class, null);
        return nodes.length == 1 ? nodes[0] : null;
    }

    private void initializeOptionsPanel(final FrameworkSupportNode node) {
        String id = node.getProvider().getId();
        if (!this.myInitializedOptionsPanelIds.contains(id)) {
            JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JComponent separator = SeparatorFactory.createSeparator((String)(node.getTitle() + " Settings"), null);
            separator.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)5));
            optionsPanel.add(separator);
            FrameworkSupportConfigurable configurable = node.getConfigurable();
            optionsPanel.add(configurable.getComponent());
            final JPanel librariesOptionsPanelWrapper = new JPanel(new BorderLayout());
            optionsPanel.add(librariesOptionsPanelWrapper);
            configurable.addListener(new FrameworkSupportConfigurableListener(){

                public void frameworkVersionChanged() {
                    librariesOptionsPanelWrapper.removeAll();
                    AddSupportForFrameworksPanel.this.addLibrariesOptionsPanel(node, librariesOptionsPanelWrapper);
                    librariesOptionsPanelWrapper.revalidate();
                }
            });
            this.addLibrariesOptionsPanel(node, librariesOptionsPanelWrapper);
            this.myOptionsPanel.add(id, optionsPanel);
            this.myInitializedOptionsPanelIds.add(id);
        }
    }

    private void addLibrariesOptionsPanel(FrameworkSupportNode node, JPanel librariesOptionsPanelWrapper) {
        LibraryCompositionOptionsPanel libraryOptionsPanel = node.getLibraryCompositionOptionsPanel(this.myLibrariesContainer, this.myMirrorsMap);
        if (libraryOptionsPanel != null) {
            librariesOptionsPanelWrapper.add("Center", libraryOptionsPanel.getMainPanel());
        }
    }

    private void showCard(String cardName) {
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, cardName);
    }

    private LibraryDownloadingMirrorsMap createMirrorsMap() {
        List<RemoteRepositoryInfo> repositoryInfos = this.getRemoteRepositories();
        return new LibraryDownloadingMirrorsMap(repositoryInfos.toArray(new RemoteRepositoryInfo[repositoryInfos.size()]));
    }

    private List<RemoteRepositoryInfo> getRemoteRepositories() {
        ArrayList<RemoteRepositoryInfo> repositoryInfos = new ArrayList<RemoteRepositoryInfo>();
        List<FrameworkSupportNode> frameworkNodes = this.getFrameworkNodes(false);
        for (FrameworkSupportNode node : frameworkNodes) {
            LibraryInfo[] libraries;
            for (LibraryInfo library : libraries = node.getLibraries()) {
                RemoteRepositoryInfo repository;
                LibraryDownloadInfo downloadInfo = library.getDownloadingInfo();
                if (downloadInfo == null || (repository = downloadInfo.getRemoteRepository()) == null) continue;
                repositoryInfos.add(repository);
            }
        }
        return repositoryInfos;
    }

    private List<LibraryCompositionSettings> getLibrariesCompositionSettingsList() {
        ArrayList<LibraryCompositionSettings> list = new ArrayList<LibraryCompositionSettings>();
        List<FrameworkSupportNode> selected = this.getFrameworkNodes(true);
        for (FrameworkSupportNode node : selected) {
            LibraryCompositionSettings settings = node.getLibraryCompositionSettings();
            if (settings == null) continue;
            list.add(settings);
        }
        return list;
    }

    public boolean downloadLibraries() {
        this.applyLibraryOptionsForSelected();
        List<LibraryCompositionSettings> list = this.getLibrariesCompositionSettingsList();
        for (LibraryCompositionSettings compositionSettings : list) {
            if (compositionSettings.downloadFiles(this.myMirrorsMap, this.myLibrariesContainer, this.myMainPanel, true)) continue;
            return false;
        }
        return true;
    }

    private void createNodes() {
        HashMap<String, FrameworkSupportNode> nodes = new HashMap<String, FrameworkSupportNode>();
        MultiValuesMap groups = new MultiValuesMap(true);
        for (FrameworkSupportProvider frameworkSupport : this.myProviders) {
            this.createNode(frameworkSupport, nodes, (MultiValuesMap<String, FrameworkSupportNode>)groups);
        }
        this.myGroups = new ArrayList<List<FrameworkSupportNode>>();
        for (String groupId : groups.keySet()) {
            Collection collection = groups.get((Object)groupId);
            if (collection == null) continue;
            ArrayList<FrameworkSupportNode> group = new ArrayList<FrameworkSupportNode>();
            for (FrameworkSupportNode node : collection) {
                if (node.getParentNode() != null) continue;
                group.add(node);
            }
            FrameworkSupportNode.sortByTitle(group);
            this.myGroups.add(group);
        }
    }

    @Nullable
    private FrameworkSupportNode createNode(FrameworkSupportProvider provider, Map<String, FrameworkSupportNode> nodes, MultiValuesMap<String, FrameworkSupportNode> groups) {
        FrameworkSupportNode node = nodes.get(provider.getId());
        if (node == null) {
            String underlyingFrameworkId = provider.getUnderlyingFrameworkId();
            FrameworkSupportNode parentNode = null;
            if (underlyingFrameworkId != null) {
                FrameworkSupportProvider parentProvider = this.findProvider(underlyingFrameworkId);
                if (parentProvider == null) {
                    LOG.info("Cannot find id = " + underlyingFrameworkId);
                    return null;
                }
                parentNode = this.createNode(parentProvider, nodes, groups);
            }
            node = new FrameworkSupportNode(provider, parentNode, this.myModel, this.myBaseDirForLibrariesGetter);
            nodes.put(provider.getId(), node);
            groups.put((Object)provider.getGroupId(), (Object)node);
        }
        return node;
    }

    @Nullable
    private FrameworkSupportProvider findProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel.findProvider must not be null");
        }
        for (FrameworkSupportProvider provider : this.myProviders) {
            if (!id.equals(provider.getId())) continue;
            return provider;
        }
        LOG.info("Cannot find framework support provider '" + id + "'");
        return null;
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public boolean haveSelectedFrameworks() {
        return !this.getFrameworkNodes(true).isEmpty();
    }

    private List<FrameworkSupportNode> getFrameworkNodes(boolean selectedOnly) {
        ArrayList<FrameworkSupportNode> list = new ArrayList<FrameworkSupportNode>();
        if (this.myGroups != null) {
            for (List<FrameworkSupportNode> group : this.myGroups) {
                AddSupportForFrameworksPanel.addChildFrameworks(group, list, selectedOnly);
            }
        }
        return list;
    }

    private static void addChildFrameworks(List<FrameworkSupportNode> list, List<FrameworkSupportNode> result, boolean selectedOnly) {
        for (FrameworkSupportNode node : list) {
            if (selectedOnly && !node.isChecked()) continue;
            result.add(node);
            AddSupportForFrameworksPanel.addChildFrameworks(node.getChildren(), result, selectedOnly);
        }
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel.addSupport must not be null");
        }
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/AddSupportForFrameworksPanel.addSupport must not be null");
        }
        ArrayList<Library> addedLibraries = new ArrayList<Library>();
        List<FrameworkSupportNode> selectedFrameworks = this.getFrameworkNodes(true);
        this.sortFrameworks(selectedFrameworks);
        for (FrameworkSupportNode node : selectedFrameworks) {
            FrameworkSupportConfigurable configurable = node.getConfigurable();
            LibraryCompositionSettings settings = node.getLibraryCompositionSettings();
            Library library = settings != null ? settings.addLibraries(rootModel, addedLibraries) : null;
            configurable.addSupport(module, rootModel, library);
        }
        for (FrameworkSupportNode node : selectedFrameworks) {
            FrameworkSupportProvider provider = node.getProvider();
            if (!(provider instanceof FacetBasedFrameworkSupportProvider) || addedLibraries.isEmpty()) continue;
            ((FacetBasedFrameworkSupportProvider)provider).processAddedLibraries(module, addedLibraries);
        }
    }

    private void sortFrameworks(List<FrameworkSupportNode> nodes) {
        DFSTBuilder builder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new ProvidersGraph(this.myProviders))));
        if (!builder.isAcyclic()) {
            Pair pair = builder.getCircularDependency();
            LOG.error("Circular dependency between providers '" + ((FrameworkSupportProvider)pair.getFirst()).getId() + "' and '" + ((FrameworkSupportProvider)pair.getSecond()).getId() + "' was found.");
        }
        final Comparator comparator = builder.comparator();
        Collections.sort(nodes, new Comparator<FrameworkSupportNode>(){

            @Override
            public int compare(FrameworkSupportNode o1, FrameworkSupportNode o2) {
                return comparator.compare(o1.getProvider(), o2.getProvider());
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        ((Component)jLabel).setEnabled(true);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.please.select.desired.technologies"));
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.framework.support.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworksPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class ProvidersGraph
    implements GraphGenerator.SemiGraph<FrameworkSupportProvider> {
        private final List<FrameworkSupportProvider> myFrameworkSupportProviders;

        public ProvidersGraph(List<FrameworkSupportProvider> frameworkSupportProviders) {
            this.myFrameworkSupportProviders = new ArrayList<FrameworkSupportProvider>(frameworkSupportProviders);
        }

        public Collection<FrameworkSupportProvider> getNodes() {
            return this.myFrameworkSupportProviders;
        }

        public Iterator<FrameworkSupportProvider> getIn(FrameworkSupportProvider provider) {
            FrameworkSupportProvider underlyingProvider;
            String[] ids = provider.getPrecedingFrameworkProviderIds();
            ArrayList<FrameworkSupportProvider> dependencies = new ArrayList<FrameworkSupportProvider>();
            String underlyingId = provider.getUnderlyingFrameworkId();
            if (underlyingId != null && (underlyingProvider = AddSupportForFrameworksPanel.this.findProvider(underlyingId)) != null) {
                dependencies.add(underlyingProvider);
            }
            for (String id : ids) {
                FrameworkSupportProvider dependency = AddSupportForFrameworksPanel.this.findProvider(id);
                if (dependency == null) continue;
                dependencies.add(dependency);
            }
            return dependencies.iterator();
        }
    }
}

