/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import org.jetbrains.annotations.Nullable;

public class JavaNavBarExtension
implements NavBarModelExtension {
    @Override
    public String getPresentableText(Object object) {
        if (object instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)object, false);
        }
        if (object instanceof PsiPackage) {
            String name = ((PsiPackage)object).getName();
            return name != null ? name : AnalysisScopeBundle.message((String)"dependencies.tree.node.default.package.abbreviation", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public PsiElement getParent(PsiElement psiElement) {
        PsiPackage parentPackage;
        if (psiElement instanceof PsiPackage && (parentPackage = ((PsiPackage)psiElement).getParentPackage()) != null && parentPackage.getQualifiedName().length() > 0) {
            return parentPackage;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement adjustElement(PsiElement psiElement) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file != null && (index.isInSourceContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file))) {
                PsiClass[] psiClasses;
                PsiJavaFile psiJavaFile;
                if (psiElement instanceof PsiJavaFile && (psiJavaFile = (PsiJavaFile)psiElement).getViewProvider().getBaseLanguage() == StdLanguages.JAVA && (psiClasses = psiJavaFile.getClasses()).length == 1) {
                    return psiClasses[0];
                }
                if (psiElement instanceof PsiClass) {
                    return psiElement;
                }
            }
            return containingFile;
        }
        return psiElement.isPhysical() ? psiElement : null;
    }
}

