/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLanguageBlockFragmentWrapper
implements Block {
    private final Block myOwner;
    private final TextRange myRange;

    public DataLanguageBlockFragmentWrapper(@NotNull Block owner, @NotNull TextRange range) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper.<init> must not be null");
        }
        this.myOwner = owner;
        this.myRange = range;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = AbstractBlock.EMPTY;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper.getSubBlocks must not return null");
        }
        return list;
    }

    public Wrap getWrap() {
        return this.myOwner.getWrap();
    }

    public Indent getIndent() {
        return this.myOwner.getIndent();
    }

    public Alignment getAlignment() {
        return this.myOwner.getAlignment();
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        return Spacing.getReadOnlySpacing();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOwner.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper.getChildAttributes must not return null");
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myOwner.isIncomplete();
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "Fragment " + this.getTextRange();
    }
}

