/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.TypeTemplatesConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DefaultConfigurationSettingsEditor
implements Configurable {
    @NonNls
    private final DefaultMutableTreeNode myRoot = new DefaultMutableTreeNode("Root");
    private final JTree myTree = new JTree(this.myRoot);
    private final Project myProject;
    private final Map<ConfigurationType, Configurable> myStoredComponents = new HashMap<ConfigurationType, Configurable>();
    private final ConfigurationType mySelection;

    public DefaultConfigurationSettingsEditor(Project project, ConfigurationType selection) {
        this.myProject = project;
        this.mySelection = selection;
    }

    public JComponent createComponent() {
        ConfigurationType[] configurationTypes;
        final JPanel wholePanel = new JPanel(new BorderLayout());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
        pane.setHorizontalScrollBarPolicy(30);
        wholePanel.add((Component)pane, "West");
        final JPanel rightPanel = new JPanel(new BorderLayout());
        wholePanel.add((Component)rightPanel, "Center");
        for (ConfigurationType type : configurationTypes = RunManagerImpl.getInstanceImpl(this.myProject).getConfigurationFactories()) {
            this.myRoot.add(new DefaultMutableTreeNode(type));
        }
        this.myTree.setRootVisible(false);
        TreeToolTipHandler.install(this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject;
                Component rendererComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ConfigurationType) {
                    ConfigurationType type = (ConfigurationType)userObject;
                    this.setText(type.getDisplayName());
                    this.setIcon(type.getIcon());
                }
                return rendererComponent;
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = DefaultConfigurationSettingsEditor.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    ConfigurationType type = (ConfigurationType)node.getUserObject();
                    rightPanel.removeAll();
                    Configurable configurable = (Configurable)DefaultConfigurationSettingsEditor.this.myStoredComponents.get(type);
                    if (configurable == null) {
                        configurable = TypeTemplatesConfigurable.createConfigurable(type, DefaultConfigurationSettingsEditor.this.myProject);
                        DefaultConfigurationSettingsEditor.this.myStoredComponents.put(type, configurable);
                        rightPanel.add(configurable.createComponent());
                        configurable.reset();
                    } else {
                        rightPanel.add(configurable.createComponent());
                    }
                    rightPanel.revalidate();
                    rightPanel.repaint();
                    Window window = SwingUtilities.windowForComponent(wholePanel);
                    if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
                        window.pack();
                    }
                }
            }
        });
        RunConfigurable.sortTree(this.myRoot);
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        TreeUtil.selectFirstNode((JTree)this.myTree);
        TreeUtil.traverse((TreeNode)this.myRoot, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                DefaultMutableTreeNode treeNode;
                Object o;
                if (node instanceof DefaultMutableTreeNode && Comparing.equal((Object)(o = (treeNode = (DefaultMutableTreeNode)node).getUserObject()), (Object)DefaultConfigurationSettingsEditor.this.mySelection)) {
                    TreeUtil.selectInTree((DefaultMutableTreeNode)treeNode, (boolean)true, (JTree)DefaultConfigurationSettingsEditor.this.myTree);
                    return false;
                }
                return true;
            }
        });
        return wholePanel;
    }

    public boolean isModified() {
        for (Configurable configurable : this.myStoredComponents.values()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.myStoredComponents.values()) {
            if (!configurable.isModified()) continue;
            configurable.apply();
        }
    }

    public void reset() {
    }

    public void disposeUIResources() {
        for (Configurable configurable : this.myStoredComponents.values()) {
            configurable.disposeUIResources();
        }
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"default.settings.editor.dialog.title", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }
}

