/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.ContinueException;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.BooleanValue;

public class ForStatementEvaluator
implements Evaluator {
    private final Evaluator myInitializationEvaluator;
    private final Evaluator myConditionEvaluator;
    private final Evaluator myUpdateEvaluator;
    private final Evaluator myBodyEvaluator;
    private Modifier myModifier;
    private final String myLabelName;

    public ForStatementEvaluator(Evaluator initializationEvaluator, Evaluator conditionEvaluator, Evaluator updateEvaluator, Evaluator bodyEvaluator, String labelName) {
        this.myInitializationEvaluator = initializationEvaluator;
        this.myConditionEvaluator = conditionEvaluator;
        this.myUpdateEvaluator = updateEvaluator;
        this.myBodyEvaluator = bodyEvaluator;
        this.myLabelName = labelName;
    }

    @Override
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = context.getDebugProcess().getVirtualMachineProxy().mirrorOf();
        if (this.myInitializationEvaluator != null) {
            value = this.myInitializationEvaluator.evaluate(context);
            this.myModifier = this.myInitializationEvaluator.getModifier();
        }
        while (true) {
            block7: {
                if (this.myConditionEvaluator != null) {
                    value = this.myConditionEvaluator.evaluate(context);
                    this.myModifier = this.myConditionEvaluator.getModifier();
                    if (!(value instanceof BooleanValue)) {
                        throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
                    }
                    if (!((BooleanValue)value).booleanValue()) break;
                }
                try {
                    this.myBodyEvaluator.evaluate(context);
                }
                catch (BreakException e) {
                    if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break;
                    throw e;
                }
                catch (ContinueException e) {
                    if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break block7;
                    throw e;
                }
            }
            if (this.myUpdateEvaluator == null) continue;
            value = this.myUpdateEvaluator.evaluate(context);
            this.myModifier = this.myUpdateEvaluator.getModifier();
        }
        return value;
    }
}

