/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AnnotationPrimitiveConstantValue
extends ConstantValue {
    private final char myValueTag;
    private final ConstantValue myValue;

    public AnnotationPrimitiveConstantValue(char valueTag, ConstantValue value) {
        this.myValueTag = valueTag;
        this.myValue = value;
    }

    public AnnotationPrimitiveConstantValue(DataInput in) throws IOException {
        this.myValueTag = in.readChar();
        this.myValue = MemberInfoExternalizer.loadConstantValue(in);
    }

    public char getValueTag() {
        return this.myValueTag;
    }

    public ConstantValue getValue() {
        return this.myValue;
    }

    @Override
    public void save(DataOutput out) throws IOException {
        out.writeChar(this.myValueTag);
        MemberInfoExternalizer.saveConstantValue(out, this.myValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationPrimitiveConstantValue)) {
            return false;
        }
        AnnotationPrimitiveConstantValue memberValue = (AnnotationPrimitiveConstantValue)o;
        if (this.myValueTag != memberValue.myValueTag) {
            return false;
        }
        return this.myValue.equals(memberValue.myValue);
    }

    public int hashCode() {
        int result = this.myValueTag;
        result = 29 * result + this.myValue.hashCode();
        return result;
    }
}

