/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringInspectionTool
extends InspectionTool {
    private HashMap<String, Set<RefEntity>> myPackageContents = new HashMap();
    private HashMap<String, Set<RefEntity>> myOldPackageContents = null;
    private final Set<RefEntity> myIgnoreElements = new HashSet();

    public abstract RefFilter getFilter();

    @Override
    public void updateContent() {
        this.myPackageContents = new HashMap();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if ((!FilteringInspectionTool.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !FilteringInspectionTool.this.myIgnoreElements.contains(refElement)) && refElement.isValid() && FilteringInspectionTool.this.getFilter().accepts(refElement)) {
                    String packageName = RefJavaUtil.getInstance().getPackageName(refEntity);
                    Set content = (Set)FilteringInspectionTool.this.myPackageContents.get((Object)packageName);
                    if (content == null) {
                        content = new HashSet();
                        FilteringInspectionTool.this.myPackageContents.put((Object)packageName, (Object)content);
                    }
                    content.add(refEntity);
                }
            }
        });
    }

    @Override
    public boolean hasReportedProblems() {
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_ONLY_DIFF) {
            return this.containsOnlyDiff(this.myPackageContents) || this.myOldPackageContents != null && this.containsOnlyDiff(this.myOldPackageContents);
        }
        if (!this.myPackageContents.isEmpty()) {
            return true;
        }
        return this.isOldProblemsIncluded() && this.myOldPackageContents.size() > 0;
    }

    private boolean containsOnlyDiff(HashMap<String, Set<RefEntity>> packageContents) {
        for (String packageName : packageContents.keySet()) {
            Set refElements = (Set)packageContents.get((Object)packageName);
            if (refElements == null) continue;
            for (RefEntity refElement : refElements) {
                if (this.getElementStatus(refElement) == FileStatus.NOT_CHANGED) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Set<RefEntity>> getContent() {
        return this.myPackageContents;
    }

    @Override
    public Map<String, Set<RefEntity>> getOldContent() {
        return this.myOldPackageContents;
    }

    @Override
    public void ignoreCurrentElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.myIgnoreElements.add(refEntity);
    }

    @Override
    public void amnesty(RefEntity refEntity) {
        this.myIgnoreElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN) {
            if (this.myOldPackageContents == null) {
                this.myOldPackageContents = new HashMap();
            }
            this.myOldPackageContents.clear();
            this.myOldPackageContents.putAll(this.myPackageContents);
        } else {
            this.myOldPackageContents = null;
        }
        this.myPackageContents.clear();
        this.myIgnoreElements.clear();
    }

    @Override
    public void finalCleanup() {
        super.finalCleanup();
        this.myOldPackageContents = null;
    }

    @Override
    public boolean isGraphNeeded() {
        return true;
    }

    @Override
    public boolean isElementIgnored(RefEntity element) {
        for (RefEntity entity : this.myIgnoreElements) {
            if (!Comparing.equal((Object)entity, (Object)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileStatus getElementStatus(RefEntity element) {
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN) {
            if (this.myOldPackageContents != null) {
                boolean old = FilteringInspectionTool.contains(element, FilteringInspectionTool.collectRefElements(this.myOldPackageContents));
                boolean current = FilteringInspectionTool.contains(element, FilteringInspectionTool.collectRefElements(this.myPackageContents));
                return FilteringInspectionTool.calcStatus(old, current);
            }
            return FileStatus.ADDED;
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public Collection<RefEntity> getIgnoredRefElements() {
        return this.myIgnoreElements;
    }

    private static Set<RefEntity> collectRefElements(HashMap<String, Set<RefEntity>> packageContents) {
        HashSet allAvailable = new HashSet();
        for (Set elements : packageContents.values()) {
            allAvailable.addAll(elements);
        }
        return allAvailable;
    }

    @Override
    @Nullable
    public SuppressIntentionAction[] getSuppressActions() {
        return SuppressManager.getInstance().createSuppressActions(HighlightDisplayKey.find((String)this.getShortName()));
    }
}

