/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.lang.LanguageLiteralEscapers;
import com.intellij.lang.LiteralEscaper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.IntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateState
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateState");
    private Project myProject;
    private Editor myEditor;
    private TemplateImpl myTemplate;
    private TemplateImpl myPrevTemplate;
    private TemplateSegments mySegments;
    private Map<String, String> myPredefinedVariableValues;
    private RangeMarker myTemplateRange;
    private final ArrayList<RangeHighlighter> myTabStopHighlighters;
    private int myCurrentVariableNumber;
    private int myCurrentSegmentNumber;
    private boolean toProcessTab;
    private boolean myDocumentChangesTerminateTemplate;
    private boolean myDocumentChanged;
    private CommandAdapter myCommandListener;
    private List<TemplateEditingListener> myListeners;
    private DocumentAdapter myEditorDocumentListener;
    private final Map myProperties;
    private boolean myTemplateIndented;
    private Document myDocument;
    private boolean myFinished;
    @Nullable
    private PairProcessor<String, String> myProcessor;

    public TemplateState(@NotNull Project project, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateState.<init> must not be null");
        }
        this.mySegments = null;
        this.myTemplateRange = null;
        this.myTabStopHighlighters = new ArrayList();
        this.myCurrentVariableNumber = -1;
        this.myCurrentSegmentNumber = -1;
        this.toProcessTab = true;
        this.myDocumentChangesTerminateTemplate = true;
        this.myDocumentChanged = false;
        this.myListeners = new ArrayList<TemplateEditingListener>();
        this.myProperties = new HashMap();
        this.myTemplateIndented = false;
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
    }

    private void initListeners() {
        this.myEditorDocumentListener = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                TemplateState.this.myDocumentChanged = true;
            }
        };
        this.myCommandListener = new CommandAdapter(){
            boolean started = false;

            public void commandStarted(CommandEvent event) {
                if (TemplateState.this.myEditor != null) {
                    int offset = TemplateState.this.myEditor.getCaretModel().getOffset();
                    TemplateState.this.myDocumentChangesTerminateTemplate = TemplateState.this.myCurrentSegmentNumber >= 0 && (offset < TemplateState.this.mySegments.getSegmentStart(TemplateState.this.myCurrentSegmentNumber) || offset > TemplateState.this.mySegments.getSegmentEnd(TemplateState.this.myCurrentSegmentNumber));
                }
                this.started = true;
            }

            public void beforeCommandFinished(CommandEvent event) {
                if (this.started) {
                    TemplateState.this.afterChangedUpdate();
                }
            }
        };
        this.myDocument.addDocumentListener((DocumentListener)this.myEditorDocumentListener);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this.myCommandListener);
    }

    public synchronized void dispose() {
        if (this.myEditorDocumentListener != null) {
            this.myDocument.removeDocumentListener((DocumentListener)this.myEditorDocumentListener);
            this.myEditorDocumentListener = null;
        }
        if (this.myCommandListener != null) {
            CommandProcessor.getInstance().removeCommandListener((CommandListener)this.myCommandListener);
            this.myCommandListener = null;
        }
        this.myProcessor = null;
        this.releaseEditor();
        this.myDocument = null;
    }

    public boolean isToProcessTab() {
        return this.toProcessTab;
    }

    private void setCurrentVariableNumber(int variableNumber) {
        this.myCurrentVariableNumber = variableNumber;
        boolean isFinished = variableNumber < 0;
        ((DocumentEx)this.myDocument).setStripTrailingSpacesEnabled(isFinished);
        this.myCurrentSegmentNumber = isFinished ? -1 : this.getCurrentSegmentNumber();
    }

    @Nullable
    public String getTrimmedVariableValue(int variableIndex) {
        TextResult value = this.getVariableValue(this.myTemplate.getVariableNameAt(variableIndex));
        return value == null ? null : value.getText().trim();
    }

    @Nullable
    public TextResult getVariableValue(@NotNull String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/TemplateState.getVariableValue must not be null");
        }
        if (variableName.equals("SELECTION")) {
            String selection = (String)this.getProperties().get(ExpressionContext.SELECTION);
            return new TextResult(selection == null ? "" : selection);
        }
        if (variableName.equals("END")) {
            return new TextResult("");
        }
        if (this.myPredefinedVariableValues != null && this.myPredefinedVariableValues.containsKey(variableName)) {
            return new TextResult(this.myPredefinedVariableValues.get(variableName));
        }
        CharSequence text = this.myDocument.getCharsSequence();
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            return null;
        }
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        int length = this.myDocument.getTextLength();
        if (start > length || end > length) {
            return null;
        }
        return new TextResult(((Object)text.subSequence(start, end)).toString());
    }

    @Nullable
    public TextRange getCurrentVariableRange() {
        int number = this.getCurrentSegmentNumber();
        if (number == -1) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(number), this.mySegments.getSegmentEnd(number));
    }

    @Nullable
    public TextRange getVariableRange(int variableIndex) {
        return this.getVariableRange(this.myTemplate.getVariableNameAt(variableIndex));
    }

    @Nullable
    public TextRange getVariableRange(String variableName) {
        int segment = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segment < 0) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(segment), this.mySegments.getSegmentEnd(segment));
    }

    public boolean isFinished() {
        return this.myCurrentVariableNumber < 0;
    }

    private void releaseAll() {
        if (this.mySegments != null) {
            this.mySegments.removeAll();
            this.mySegments = null;
        }
        this.myTemplateRange = null;
        this.myPrevTemplate = this.myTemplate;
        this.myTemplate = null;
        this.releaseEditor();
        this.myTabStopHighlighters.clear();
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            for (RangeHighlighter segmentHighlighter : this.myTabStopHighlighters) {
                this.myEditor.getMarkupModel().removeHighlighter(segmentHighlighter);
            }
            this.myEditor = null;
        }
    }

    public void start(TemplateImpl template, @Nullable PairProcessor<String, String> processor, @Nullable Map<String, String> predefinedVarValues) {
        DocumentReference[] documentReferenceArray;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.myProcessor = processor;
        if (this.myDocument == null) {
            documentReferenceArray = null;
        } else {
            DocumentReference[] documentReferenceArray2 = new DocumentReference[1];
            documentReferenceArray = documentReferenceArray2;
            documentReferenceArray2[0] = DocumentReferenceManager.getInstance().create(this.myDocument);
        }
        final DocumentReference[] refs = documentReferenceArray;
        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed(new UndoableAction(){

            public void undo() {
                if (TemplateState.this.myDocument != null) {
                    TemplateState.this.fireTemplateCancelled();
                    LookupManager.getInstance(TemplateState.this.myProject).hideActiveLookup();
                    int oldVar = TemplateState.this.myCurrentVariableNumber;
                    TemplateState.this.setCurrentVariableNumber(-1);
                    TemplateState.this.currentVariableChanged(oldVar);
                }
            }

            public void redo() {
            }

            public DocumentReference[] getAffectedDocuments() {
                return refs;
            }

            public boolean isGlobal() {
                return false;
            }
        });
        this.myTemplateIndented = false;
        this.myCurrentVariableNumber = -1;
        this.mySegments = new TemplateSegments(this.myEditor);
        this.myPrevTemplate = this.myTemplate;
        this.myTemplate = template;
        this.myPredefinedVariableValues = predefinedVarValues;
        if (template.isInline()) {
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset + template.getTemplateText().length());
        } else {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            this.preprocessTemplate(file, this.myEditor.getCaretModel().getOffset(), this.myTemplate.getTemplateText());
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset);
        }
        this.myTemplateRange.setGreedyToLeft(true);
        this.myTemplateRange.setGreedyToRight(true);
        this.processAllExpressions(template);
    }

    private void fireTemplateCancelled() {
        TemplateEditingListener[] listeners;
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener : listeners = this.myListeners.toArray(new TemplateEditingListener[this.myListeners.size()])) {
            listener.templateCancelled(this.myTemplate);
        }
    }

    private void preprocessTemplate(PsiFile file, int caretOffset, String textToInsert) {
        for (TemplatePreprocessor preprocessor : (TemplatePreprocessor[])Extensions.getExtensions(TemplatePreprocessor.EP_NAME)) {
            preprocessor.preprocessTemplate(this.myEditor, file, caretOffset, textToInsert, this.myTemplate.getTemplateText());
        }
    }

    private void processAllExpressions(final TemplateImpl template) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!template.isInline()) {
                    TemplateState.this.myDocument.insertString(TemplateState.this.myTemplateRange.getStartOffset(), (CharSequence)template.getTemplateText());
                }
                for (int i = 0; i < template.getSegmentsCount(); ++i) {
                    int segmentOffset = TemplateState.this.myTemplateRange.getStartOffset() + template.getSegmentOffset(i);
                    TemplateState.this.mySegments.addSegment(segmentOffset, segmentOffset);
                }
                TemplateState.this.calcResults(false);
                TemplateState.this.calcResults(false);
                TemplateState.this.doReformat(null);
                int nextVariableNumber = TemplateState.this.getNextVariableNumber(-1);
                if (nextVariableNumber >= 0) {
                    TemplateState.this.fireWaitingForInput();
                }
                if (nextVariableNumber == -1) {
                    TemplateState.this.finishTemplateEditing(false);
                } else {
                    TemplateState.this.setCurrentVariableNumber(nextVariableNumber);
                    TemplateState.this.initTabStopHighlighters();
                    TemplateState.this.initListeners();
                    TemplateState.this.focusCurrentExpression();
                    TemplateState.this.currentVariableChanged(-1);
                }
            }
        });
    }

    public void doReformat(TextRange range) {
        RangeMarker rangeMarker = null;
        if (range != null) {
            rangeMarker = this.myDocument.createRangeMarker(range);
            rangeMarker.setGreedyToLeft(true);
            rangeMarker.setGreedyToRight(true);
        }
        final RangeMarker finalRangeMarker = rangeMarker;
        Runnable action = new Runnable(){

            @Override
            public void run() {
                IntArrayList indices = TemplateState.this.initEmptyVariables();
                TemplateState.this.mySegments.setSegmentsGreedy(false);
                TemplateState.this.reformat(finalRangeMarker);
                TemplateState.this.mySegments.setSegmentsGreedy(true);
                TemplateState.this.restoreEmptyVariables(indices);
            }
        };
        ApplicationManager.getApplication().runWriteAction(action);
    }

    private void shortenReferences() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiFile file = PsiDocumentManager.getInstance((Project)TemplateState.this.myProject).getPsiFile(TemplateState.this.myDocument);
                if (file != null) {
                    IntArrayList indices = TemplateState.this.initEmptyVariables();
                    TemplateState.this.mySegments.setSegmentsGreedy(false);
                    for (TemplateOptionalProcessor processor : (TemplateOptionalProcessor[])Extensions.getExtensions(TemplateOptionalProcessor.EP_NAME)) {
                        processor.processText(TemplateState.this.myProject, TemplateState.this.myTemplate, TemplateState.this.myDocument, TemplateState.this.myTemplateRange, TemplateState.this.myEditor);
                    }
                    TemplateState.this.mySegments.setSegmentsGreedy(true);
                    TemplateState.this.restoreEmptyVariables(indices);
                }
            }
        });
    }

    private void afterChangedUpdate() {
        if (this.isFinished()) {
            return;
        }
        LOG.assertTrue(this.myTemplate != null, (Object)(this.myPrevTemplate != null ? this.myPrevTemplate.getKey() : "prev template is null"));
        if (this.myDocumentChanged) {
            if (this.myDocumentChangesTerminateTemplate || this.mySegments.isInvalid()) {
                int oldIndex = this.myCurrentVariableNumber;
                this.setCurrentVariableNumber(-1);
                this.currentVariableChanged(oldIndex);
                this.fireTemplateCancelled();
            } else {
                this.calcResults(true);
            }
            this.myDocumentChanged = false;
        }
    }

    private String getExpressionString(int index) {
        CharSequence text = this.myDocument.getCharsSequence();
        if (!this.mySegments.isValid(index)) {
            return "";
        }
        int start = this.mySegments.getSegmentStart(index);
        int end = this.mySegments.getSegmentEnd(index);
        return ((Object)text.subSequence(start, end)).toString();
    }

    private int getCurrentSegmentNumber() {
        if (this.myCurrentVariableNumber == -1) {
            return -1;
        }
        String variableName = this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber);
        return this.myTemplate.getVariableSegmentNumber(variableName);
    }

    private void focusCurrentExpression() {
        if (this.isFinished()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        int currentSegmentNumber = this.getCurrentSegmentNumber();
        this.lockSegmentAtTheSameOffsetIfAny();
        if (currentSegmentNumber < 0) {
            return;
        }
        int start = this.mySegments.getSegmentStart(currentSegmentNumber);
        int end = this.mySegments.getSegmentEnd(currentSegmentNumber);
        this.myEditor.getCaretModel().moveToOffset(end);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        this.myEditor.getSelectionModel().setSelection(start, end);
        Expression expressionNode = this.myTemplate.getExpressionAt(this.myCurrentVariableNumber);
        ExpressionContext context = this.createExpressionContext(start);
        LookupElement[] lookupItems = expressionNode.calculateLookupItems(context);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        if (lookupItems != null && lookupItems.length > 0) {
            if (((TemplateManagerImpl)TemplateManager.getInstance(this.myProject)).shouldSkipInTests()) {
                String s = lookupItems[0].getLookupString();
                EditorModificationUtil.insertStringAtCaret((Editor)this.myEditor, (String)s);
                this.itemSelected(lookupItems[0], psiFile, currentSegmentNumber, ' ', lookupItems);
            } else {
                this.runLookup(currentSegmentNumber, lookupItems, psiFile);
            }
        } else {
            Result result = expressionNode.calculateResult(context);
            if (result != null) {
                result.handleFocused(psiFile, this.myDocument, this.mySegments.getSegmentStart(currentSegmentNumber), this.mySegments.getSegmentEnd(currentSegmentNumber));
            }
        }
        this.focusCurrentHighlighter(true);
    }

    private void runLookup(final int currentSegmentNumber, final LookupElement[] lookupItems, final PsiFile psiFile) {
        if (this.myEditor == null) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(this.myProject);
        if (lookupManager.isDisposed()) {
            return;
        }
        final Lookup lookup = lookupManager.showLookup(this.myEditor, lookupItems);
        this.toProcessTab = false;
        lookup.addLookupListener(new LookupAdapter(){

            @Override
            public void lookupCanceled(LookupEvent event) {
                lookup.removeLookupListener(this);
                TemplateState.this.toProcessTab = true;
            }

            @Override
            public void itemSelected(LookupEvent event) {
                lookup.removeLookupListener(this);
                if (TemplateState.this.isFinished()) {
                    return;
                }
                TemplateState.this.toProcessTab = true;
                TemplateState.this.itemSelected(event.getItem(), psiFile, currentSegmentNumber, event.getCompletionChar(), lookupItems);
            }
        });
    }

    private void itemSelected(final LookupElement item, PsiFile psiFile, int currentSegmentNumber, char completionChar, LookupElement[] elements) {
        if (item != null) {
            TemplateLookupSelectionHandler handler;
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            OffsetMap offsetMap = new OffsetMap(this.myDocument);
            final InsertionContext context = new InsertionContext(offsetMap, '\u0000', elements, psiFile, this.myEditor);
            context.setTailOffset(this.myEditor.getCaretModel().getOffset());
            offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, context.getTailOffset() - item.getLookupString().length());
            offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, context.getTailOffset());
            offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context.getTailOffset());
            Integer bracketCount = (Integer)item.getUserData(LookupItem.BRACKETS_COUNT_ATTR);
            if (bracketCount != null) {
                final StringBuilder tail = new StringBuilder();
                for (int i = 0; i < bracketCount; ++i) {
                    tail.append("[]");
                }
                new WriteCommandAction(this.myProject, new PsiFile[0]){

                    protected void run(com.intellij.openapi.application.Result result) throws Throwable {
                        EditorModificationUtil.insertStringAtCaret((Editor)TemplateState.this.myEditor, (String)tail.toString());
                    }
                }.execute();
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            }
            TemplateLookupSelectionHandler templateLookupSelectionHandler = handler = item instanceof LookupItem ? ((LookupItem)item).getAttribute(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM) : null;
            if (handler != null) {
                handler.itemSelected(item, psiFile, this.myDocument, this.mySegments.getSegmentStart(currentSegmentNumber), this.mySegments.getSegmentEnd(currentSegmentNumber));
            } else {
                new WriteCommandAction(this.myProject, new PsiFile[0]){

                    protected void run(com.intellij.openapi.application.Result result) throws Throwable {
                        item.handleInsert(context);
                    }
                }.execute();
            }
            if (completionChar == '.') {
                EditorModificationUtil.insertStringAtCaret((Editor)this.myEditor, (String)".");
                AutoPopupController.getInstance(this.myProject).autoPopupMemberLookup(this.myEditor, null);
                return;
            }
            if (!this.isFinished()) {
                this.calcResults(true);
            }
        }
        this.nextTab();
    }

    private void unblockDocument() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
    }

    private void calcResults(final boolean isQuick) {
        String variableName;
        TextResult value;
        if (this.myProcessor != null && this.myCurrentVariableNumber >= 0 && (value = this.getVariableValue(variableName = this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber))) != null && value.getText().length() > 0 && !this.myProcessor.process((Object)variableName, (Object)value.getText())) {
            this.finishTemplateEditing(false);
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                BitSet calcedSegments = new BitSet();
                int maxAttempts = (TemplateState.this.myTemplate.getVariableCount() + 1) * 3;
                do {
                    String variableName;
                    int i;
                    --maxAttempts;
                    calcedSegments.clear();
                    for (i = TemplateState.this.myCurrentVariableNumber + 1; i < TemplateState.this.myTemplate.getVariableCount(); ++i) {
                        variableName = TemplateState.this.myTemplate.getVariableNameAt(i);
                        int segmentNumber = TemplateState.this.myTemplate.getVariableSegmentNumber(variableName);
                        if (segmentNumber < 0) continue;
                        Expression expression = TemplateState.this.myTemplate.getExpressionAt(i);
                        Expression defaultValue = TemplateState.this.myTemplate.getDefaultValueAt(i);
                        String oldValue = TemplateState.this.getVariableValue(variableName).getText();
                        TemplateState.this.recalcSegment(segmentNumber, isQuick, expression, defaultValue);
                        TextResult value = TemplateState.this.getVariableValue(variableName);
                        assert (value != null) : "name=" + variableName + "\ntext=" + TemplateState.access$2300(TemplateState.this).getTemplateText();
                        String newValue = value.getText();
                        if (newValue.equals(oldValue)) continue;
                        calcedSegments.set(segmentNumber);
                    }
                    for (i = 0; i < TemplateState.this.myTemplate.getSegmentsCount(); ++i) {
                        if (calcedSegments.get(i)) continue;
                        variableName = TemplateState.this.myTemplate.getSegmentName(i);
                        String newValue = TemplateState.this.getVariableValue(variableName).getText();
                        int start = TemplateState.this.mySegments.getSegmentStart(i);
                        int end = TemplateState.this.mySegments.getSegmentEnd(i);
                        TemplateState.this.replaceString(newValue, start, end, i);
                    }
                } while (!calcedSegments.isEmpty() && maxAttempts >= 0);
            }
        });
    }

    private void recalcSegment(int segmentNumber, boolean isQuick, Expression expressionNode, Expression defaultValue) {
        Result result;
        String oldValue = this.getExpressionString(segmentNumber);
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        ExpressionContext context = this.createExpressionContext(start);
        if (isQuick) {
            result = expressionNode.calculateQuickResult(context);
        } else {
            TextResult text;
            result = expressionNode.calculateResult(context);
            if (expressionNode instanceof ConstantNode && result instanceof TextResult && (text = (TextResult)result).getText().length() == 0 && defaultValue != null) {
                result = defaultValue.calculateResult(context);
            }
            if (result == null && defaultValue != null) {
                result = defaultValue.calculateResult(context);
            }
        }
        if (result == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        PsiElement element = psiFile.findElementAt(start);
        if (result.equalsToText(oldValue, element)) {
            return;
        }
        String newValue = result.toString();
        if (newValue == null) {
            newValue = "";
        }
        if (element != null) {
            newValue = ((LiteralEscaper)LanguageLiteralEscapers.INSTANCE.forLanguage(element.getLanguage())).getEscapedText(element, newValue);
        }
        this.replaceString(newValue, start, end, segmentNumber);
        if (result instanceof RecalculatableResult) {
            this.shortenReferences();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            ((RecalculatableResult)result).handleRecalc(psiFile, this.myDocument, this.mySegments.getSegmentStart(segmentNumber), this.mySegments.getSegmentEnd(segmentNumber));
        }
    }

    private void replaceString(String newValue, int start, int end, int segmentNumber) {
        String oldText = ((Object)this.myDocument.getCharsSequence().subSequence(start, end)).toString();
        if (!oldText.equals(newValue)) {
            int segmentNumberWithTheSameStart = this.mySegments.getSegmentWithTheSameStart(segmentNumber, start);
            this.mySegments.setNeighboursGreedy(segmentNumber, false);
            this.myDocument.replaceString(start, end, (CharSequence)newValue);
            int newEnd = start + newValue.length();
            this.mySegments.replaceSegmentAt(segmentNumber, start, newEnd);
            this.mySegments.setNeighboursGreedy(segmentNumber, true);
            if (segmentNumberWithTheSameStart != -1) {
                this.mySegments.replaceSegmentAt(segmentNumberWithTheSameStart, newEnd, newEnd + this.mySegments.getSegmentEnd(segmentNumberWithTheSameStart) - this.mySegments.getSegmentStart(segmentNumberWithTheSameStart));
            }
        }
    }

    public void previousTab() {
        if (this.isFinished()) {
            return;
        }
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int previousVariableNumber = this.getPreviousVariableNumber(oldVar);
        if (previousVariableNumber >= 0) {
            this.focusCurrentHighlighter(false);
            this.calcResults(false);
            this.doReformat(null);
            this.setCurrentVariableNumber(previousVariableNumber);
            this.focusCurrentExpression();
            this.currentVariableChanged(oldVar);
        }
    }

    public void nextTab() {
        if (this.isFinished()) {
            return;
        }
        this.unblockDocument();
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int nextVariableNumber = this.getNextVariableNumber(oldVar);
        if (nextVariableNumber == -1) {
            this.calcResults(false);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    TemplateState.this.reformat(null);
                }
            });
            this.finishTemplateEditing(false);
            return;
        }
        this.focusCurrentHighlighter(false);
        this.calcResults(false);
        this.doReformat(null);
        this.setCurrentVariableNumber(nextVariableNumber);
        this.focusCurrentExpression();
        this.currentVariableChanged(oldVar);
    }

    private void lockSegmentAtTheSameOffsetIfAny() {
        this.mySegments.lockSegmentAtTheSameOffsetIfAny(this.getCurrentSegmentNumber());
    }

    private ExpressionContext createExpressionContext(final int start) {
        return new ExpressionContext(){

            public Project getProject() {
                return TemplateState.this.myProject;
            }

            public Editor getEditor() {
                return TemplateState.this.myEditor;
            }

            public int getStartOffset() {
                return start;
            }

            public int getTemplateStartOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getStartOffset();
            }

            public int getTemplateEndOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getEndOffset();
            }

            public <T> T getProperty(Key<T> key) {
                return (T)TemplateState.this.myProperties.get(key);
            }
        };
    }

    public void gotoEnd(boolean brokenOff) {
        this.calcResults(false);
        this.doReformat(null);
        this.finishTemplateEditing(brokenOff);
    }

    public void gotoEnd() {
        this.gotoEnd(false);
    }

    private void finishTemplateEditing(boolean brokenOff) {
        if (this.myTemplate == null) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        int offset = -1;
        if (endSegmentNumber >= 0) {
            offset = this.mySegments.getSegmentStart(endSegmentNumber);
        } else if (!this.myTemplate.isSelectionTemplate() && !this.myTemplate.isInline()) {
            offset = this.myTemplateRange.getEndOffset();
        }
        if (offset >= 0) {
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        this.myEditor.getSelectionModel().removeSelection();
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        if (selStart >= 0 && selEnd >= 0) {
            this.myEditor.getSelectionModel().setSelection(this.mySegments.getSegmentStart(selStart), this.mySegments.getSegmentStart(selEnd));
        }
        this.fireBeforeTemplateFinished();
        Editor editor = this.myEditor;
        int oldVar = this.myCurrentVariableNumber;
        this.setCurrentVariableNumber(-1);
        this.currentVariableChanged(oldVar);
        ((TemplateManagerImpl)TemplateManager.getInstance(this.myProject)).clearTemplateState(editor);
        this.fireTemplateFinished(brokenOff);
        this.myListeners.clear();
        this.myProject = null;
    }

    private int getNextVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber + 1; i < this.myTemplate.getVariableCount(); ++i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber - 1; i >= 0; --i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkIfTabStop(int currentVariableNumber) {
        Expression expression = this.myTemplate.getExpressionAt(currentVariableNumber);
        if (expression == null) {
            return false;
        }
        String variableName = this.myTemplate.getVariableNameAt(currentVariableNumber);
        if ((this.myPredefinedVariableValues == null || !this.myPredefinedVariableValues.containsKey(variableName)) && this.myTemplate.isAlwaysStopAt(currentVariableNumber)) {
            return true;
        }
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            return false;
        }
        int start = this.mySegments.getSegmentStart(segmentNumber);
        ExpressionContext context = this.createExpressionContext(start);
        Result result = expression.calculateResult(context);
        if (result == null) {
            return true;
        }
        LookupElement[] items = expression.calculateLookupItems(context);
        return items != null && items.length > 1;
    }

    private IntArrayList initEmptyVariables() {
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        IntArrayList indices = new IntArrayList();
        block0: for (int i = 0; i < this.myTemplate.getSegmentsCount(); ++i) {
            int length = this.mySegments.getSegmentEnd(i) - this.mySegments.getSegmentStart(i);
            if (length != 0 || i == endSegmentNumber || i == selStart || i == selEnd) continue;
            String name = this.myTemplate.getSegmentName(i);
            for (int j = 0; j < this.myTemplate.getVariableCount(); ++j) {
                if (!this.myTemplate.getVariableNameAt(j).equals(name)) continue;
                Expression e = this.myTemplate.getExpressionAt(j);
                String marker = "a";
                if (e instanceof MacroCallNode) {
                    marker = ((MacroCallNode)e).getMacro().getDefaultValue();
                }
                int start = this.mySegments.getSegmentStart(i);
                int end = start + marker.length();
                this.myDocument.insertString(start, (CharSequence)marker);
                this.mySegments.replaceSegmentAt(i, start, end);
                indices.add(i);
                continue block0;
            }
        }
        return indices;
    }

    private void restoreEmptyVariables(IntArrayList indices) {
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            this.myDocument.deleteString(this.mySegments.getSegmentStart(index), this.mySegments.getSegmentEnd(index));
        }
    }

    private void initTabStopHighlighters() {
        for (int i = 0; i < this.myTemplate.getVariableCount(); ++i) {
            String variableName = this.myTemplate.getVariableNameAt(i);
            int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
            if (segmentNumber < 0) continue;
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(segmentNumber, false, false);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        if (endSegmentNumber >= 0) {
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(endSegmentNumber, false, true);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
    }

    private RangeHighlighter getSegmentHighlighter(int segmentNumber, boolean isSelected, boolean isEnd) {
        TextAttributes attributes = isSelected ? new TextAttributes(null, null, Color.red, EffectType.BOXED, 0) : new TextAttributes();
        TextAttributes endAttributes = new TextAttributes();
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        RangeHighlighter segmentHighlighter = isEnd ? this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6001, endAttributes, HighlighterTargetArea.EXACT_RANGE) : this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        segmentHighlighter.setGreedyToLeft(true);
        segmentHighlighter.setGreedyToRight(true);
        return segmentHighlighter;
    }

    private void focusCurrentHighlighter(boolean toSelect) {
        int segmentNumber;
        RangeHighlighter newSegmentHighlighter;
        if (this.isFinished()) {
            return;
        }
        if (this.myCurrentVariableNumber >= this.myTabStopHighlighters.size()) {
            return;
        }
        RangeHighlighter segmentHighlighter = this.myTabStopHighlighters.get(this.myCurrentVariableNumber);
        if (segmentHighlighter != null && (newSegmentHighlighter = this.getSegmentHighlighter(segmentNumber = this.getCurrentSegmentNumber(), toSelect, false)) != null) {
            this.myEditor.getMarkupModel().removeHighlighter(segmentHighlighter);
            this.myTabStopHighlighters.set(this.myCurrentVariableNumber, newSegmentHighlighter);
        }
    }

    private void reformat(RangeMarker rangeMarkerToReformat) {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        if (file != null) {
            CodeStyleManager style = CodeStyleManager.getInstance((Project)this.myProject);
            for (TemplateOptionalProcessor optionalProcessor : (TemplateOptionalProcessor[])Extensions.getExtensions(TemplateOptionalProcessor.EP_NAME)) {
                optionalProcessor.processText(this.myProject, this.myTemplate, this.myDocument, this.myTemplateRange, this.myEditor);
            }
            if (this.myTemplate.isToReformat()) {
                try {
                    int endVarOffset;
                    PsiElement marker;
                    int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
                    RangeMarker rangeMarker = null;
                    if (endSegmentNumber >= 0 && (marker = style.insertNewLineIndentMarker(file, endVarOffset = this.mySegments.getSegmentStart(endSegmentNumber))) != null) {
                        rangeMarker = this.myDocument.createRangeMarker(marker.getTextRange());
                    }
                    int startOffset = rangeMarkerToReformat != null ? rangeMarkerToReformat.getStartOffset() : this.myTemplateRange.getStartOffset();
                    int endOffset = rangeMarkerToReformat != null ? rangeMarkerToReformat.getEndOffset() : this.myTemplateRange.getEndOffset();
                    style.reformatText(file, startOffset, endOffset);
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
                    PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
                    if (rangeMarker != null && rangeMarker.isValid()) {
                        this.mySegments.replaceSegmentAt(endSegmentNumber, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                        this.myDocument.deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            } else if (this.myTemplate.isToIndent() && !this.myTemplateIndented) {
                this.smartIndent(this.myTemplateRange.getStartOffset(), this.myTemplateRange.getEndOffset());
                this.myTemplateIndented = true;
            }
        }
    }

    private void smartIndent(int startOffset, int endOffset) {
        char ch;
        int indentLineNum;
        int startLineNum = this.myDocument.getLineNumber(startOffset);
        int endLineNum = this.myDocument.getLineNumber(endOffset);
        if (endLineNum == startLineNum) {
            return;
        }
        int lineLength = 0;
        for (indentLineNum = startLineNum; indentLineNum >= 0 && (lineLength = this.myDocument.getLineEndOffset(indentLineNum) - this.myDocument.getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
        }
        if (indentLineNum < 0) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        CharSequence text = this.myDocument.getCharsSequence();
        for (int i = 0; i < lineLength && ((ch = text.charAt(this.myDocument.getLineStartOffset(indentLineNum) + i)) == ' ' || ch == '\t'); ++i) {
            buffer.append(ch);
        }
        if (buffer.length() == 0) {
            return;
        }
        String stringToInsert = buffer.toString();
        for (int i = startLineNum + 1; i <= endLineNum; ++i) {
            this.myDocument.insertString(this.myDocument.getLineStartOffset(i), (CharSequence)stringToInsert);
        }
    }

    public void addTemplateStateListener(TemplateEditingListener listener) {
        this.myListeners.add(listener);
    }

    private void fireTemplateFinished(boolean brokenOff) {
        TemplateEditingListener[] listeners;
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener : listeners = this.myListeners.toArray(new TemplateEditingListener[this.myListeners.size()])) {
            listener.templateFinished(this.myTemplate, brokenOff);
        }
    }

    private void fireBeforeTemplateFinished() {
        TemplateEditingListener[] listeners;
        for (TemplateEditingListener listener : listeners = this.myListeners.toArray(new TemplateEditingListener[this.myListeners.size()])) {
            listener.beforeTemplateFinished(this, this.myTemplate);
        }
    }

    private void fireWaitingForInput() {
        TemplateEditingListener[] listeners;
        for (TemplateEditingListener listener : listeners = this.myListeners.toArray(new TemplateEditingListener[this.myListeners.size()])) {
            listener.waitingForInput(this.myTemplate);
        }
    }

    private void currentVariableChanged(int oldIndex) {
        TemplateEditingListener[] listeners;
        for (TemplateEditingListener listener : listeners = this.myListeners.toArray(new TemplateEditingListener[this.myListeners.size()])) {
            listener.currentVariableChanged(this, this.myTemplate, oldIndex, this.myCurrentVariableNumber);
        }
        if (this.myCurrentSegmentNumber < 0) {
            this.releaseAll();
        }
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    void reset() {
        this.myListeners = new ArrayList<TemplateEditingListener>();
    }
}

