/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;

public class MissingWhileBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiWhileStatement)) {
            return;
        }
        PsiWhileStatement whileStatement = (PsiWhileStatement)psiElement;
        Document doc = editor.getDocument();
        PsiStatement body = whileStatement.getBody();
        if (body instanceof PsiBlockStatement) {
            return;
        }
        if (body != null && MissingWhileBodyFixer.startLine(doc, (PsiElement)body) == MissingWhileBodyFixer.startLine(doc, (PsiElement)whileStatement) && whileStatement.getCondition() != null) {
            return;
        }
        PsiJavaToken rParenth = whileStatement.getRParenth();
        assert (rParenth != null);
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

