/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import org.jetbrains.annotations.NonNls;

public class ReferenceTransferableData
implements TextBlockTransferableData,
Cloneable,
Serializable {
    private final ReferenceData[] myReferenceDatas;

    public ReferenceTransferableData(ReferenceData[] referenceDatas) {
        this.myReferenceDatas = referenceDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return ReferenceData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myReferenceDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            offsets[index++] = data.startOffset;
            offsets[index++] = data.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            data.startOffset = offsets[index++];
            data.endOffset = offsets[index++];
        }
        return index;
    }

    public ReferenceTransferableData clone() {
        ReferenceData[] newReferenceData = new ReferenceData[this.myReferenceDatas.length];
        for (int i = 0; i < this.myReferenceDatas.length; ++i) {
            newReferenceData[i] = (ReferenceData)this.myReferenceDatas[i].clone();
        }
        return new ReferenceTransferableData(newReferenceData);
    }

    public ReferenceData[] getData() {
        return this.myReferenceDatas;
    }

    public static class ReferenceData
    implements Cloneable,
    Serializable {
        @NonNls
        public static DataFlavor ourFlavor;
        public int startOffset;
        public int endOffset;
        public final String qClassName;
        public final String staticMemberName;

        public ReferenceData(int startOffset, int endOffset, String qClassName, String staticMemberDescriptor) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.qClassName = qClassName;
            this.staticMemberName = staticMemberDescriptor;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException();
            }
        }

        public static DataFlavor getDataFlavor() {
            if (ourFlavor != null) {
                return ourFlavor;
            }
            try {
                ourFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ReferenceData.class.getName(), "ReferenceData");
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return ourFlavor;
        }
    }
}

