/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.SelectImportedProjectsStep;
import java.io.File;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;
import org.jetbrains.idea.maven.wizards.MavenProjectImportStep;
import org.jetbrains.idea.maven.wizards.SelectProfilesStep;

public class MavenProjectImportProvider
extends ProjectImportProvider {
    public MavenProjectImportProvider(MavenProjectBuilder builder) {
        super((ProjectImportBuilder)builder);
    }

    public ModuleWizardStep[] createSteps(WizardContext wizardContext) {
        ProjectWizardStepFactory stepFactory = ProjectWizardStepFactory.getInstance();
        return new ModuleWizardStep[]{new MavenProjectImportStep(wizardContext), new SelectProfilesStep(wizardContext), new SelectImportedProjectsStep<MavenProject>(wizardContext){

            protected String getElementText(MavenProject project) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(project.getMavenId());
                String relPath = VfsUtil.getRelativePath((VirtualFile)project.getDirectoryFile(), (VirtualFile)((MavenProjectBuilder)this.getBuilder()).getRootDirectory(), (char)File.separatorChar);
                if (relPath.length() != 0) {
                    stringBuilder.append(" [").append(relPath).append("]");
                }
                return stringBuilder.toString();
            }

            public void updateDataModel() {
                super.updateDataModel();
                this.getWizardContext().setProjectName(((MavenProjectBuilder)this.getBuilder()).getSuggestedProjectName());
            }

            public String getHelpId() {
                return "reference.dialogs.new.project.import.maven.page3";
            }
        }, stepFactory.createProjectJdkStep(wizardContext), stepFactory.createNameAndLocationStep(wizardContext)};
    }
}

