/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.RunnerBundle;

public class MavenRunnerSettings
implements Cloneable {
    @NonNls
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    @NonNls
    public static final String USE_JAVA_HOME = "#JAVA_HOME";
    private boolean runMavenInBackground = true;
    @NotNull
    private String jreName = "";
    @NotNull
    private String vmOptions = "";
    private boolean skipTests = false;
    private Map<String, String> mavenProperties = new LinkedHashMap<String, String>();

    public boolean isRunMavenInBackground() {
        return this.runMavenInBackground;
    }

    public void setRunMavenInBackground(boolean runMavenInBackground) {
        this.runMavenInBackground = runMavenInBackground;
    }

    @NotNull
    public String getJreName() {
        if (StringUtil.isEmpty((String)this.jreName)) {
            this.jreName = this.getDefaultJdkName();
        }
        String string = this.jreName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenRunnerSettings.getJreName must not return null");
        }
        return string;
    }

    public void setJreName(@Nullable String jreName) {
        if (jreName != null) {
            this.jreName = jreName;
        }
    }

    @NotNull
    public String getVmOptions() {
        String string = this.vmOptions;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenRunnerSettings.getVmOptions must not return null");
        }
        return string;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        if (vmOptions != null) {
            this.vmOptions = vmOptions;
        }
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public Map<String, String> getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Map<String, String> mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    public List<Pair<String, String>> collectJdkNamesAndDescriptions() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getSdksOfType(this.getSdkType())) {
            String name = projectJdk.getName();
            result.add(new Pair((Object)name, (Object)name));
        }
        result.add(new Pair((Object)USE_INTERNAL_JAVA, (Object)RunnerBundle.message("maven.java.internal", new Object[0])));
        result.add(new Pair((Object)USE_JAVA_HOME, (Object)RunnerBundle.message("maven.java.home.env", new Object[0])));
        return result;
    }

    private SdkType getSdkType() {
        return JavaSdk.getInstance();
    }

    public String getDefaultJdkName() {
        Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType(this.getSdkType());
        if (recent == null) {
            return USE_INTERNAL_JAVA;
        }
        return recent.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerSettings that = (MavenRunnerSettings)o;
        if (this.runMavenInBackground != that.runMavenInBackground) {
            return false;
        }
        if (this.skipTests != that.skipTests) {
            return false;
        }
        if (!this.jreName.equals(that.jreName)) {
            return false;
        }
        if (this.mavenProperties != null ? !((Object)this.mavenProperties).equals(that.mavenProperties) : that.mavenProperties != null) {
            return false;
        }
        return this.vmOptions.equals(that.vmOptions);
    }

    public int hashCode() {
        int result = this.runMavenInBackground ? 1 : 0;
        result = 31 * result + this.jreName.hashCode();
        result = 31 * result + this.vmOptions.hashCode();
        result = 31 * result + (this.skipTests ? 1 : 0);
        result = 31 * result + (this.mavenProperties != null ? ((Object)this.mavenProperties).hashCode() : 0);
        return result;
    }

    public MavenRunnerSettings clone() {
        try {
            MavenRunnerSettings clone = (MavenRunnerSettings)super.clone();
            clone.mavenProperties = MavenRunnerSettings.cloneMap(this.mavenProperties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static <K, V> Map<K, V> cloneMap(Map<K, V> source) {
        LinkedHashMap<K, V> clone = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }
}

