/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.misc.AntPsiUtil;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;

public class AntCreatePresetDefFix
extends BaseIntentionAction {
    private final AntStructuredElement myUndefinedElement;
    private final AntFile myFile;

    public AntCreatePresetDefFix(AntStructuredElement undefinedElement) {
        this(undefinedElement, null);
    }

    public AntCreatePresetDefFix(AntStructuredElement undefinedElement, AntFile file) {
        this.myUndefinedElement = undefinedElement;
        this.myFile = file;
    }

    @NotNull
    public String getFamilyName() {
        String i18nName = AntBundle.message("intention.create.presetdef.family.name", new Object[0]);
        String string = i18nName == null ? "Create presetdef" : i18nName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreatePresetDefFix.getFamilyName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getText() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(this.getFamilyName());
        builder.append(" '");
        builder.append(this.myUndefinedElement.getSourceElement().getName());
        builder.append('\'');
        if (this.myFile != null) {
            builder.append(' ');
            builder.append(AntBundle.message("text.in.the.file", this.myFile.getName()));
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreatePresetDefFix.getText must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreatePresetDefFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreatePresetDefFix.invoke must not be null");
        }
        AntStructuredElement element = this.myUndefinedElement;
        AntProject antProject = this.myFile == null ? element.getAntProject() : this.myFile.getAntProject();
        AntElement anchor = this.myFile == null ? AntPsiUtil.getSubProjectElement(element) : (AntElement)PsiTreeUtil.getChildOfType((PsiElement)antProject, AntStructuredElement.class);
        XmlTag se = element.getSourceElement();
        XmlTag projectTag = antProject.getSourceElement();
        XmlTag presetDef = projectTag.createChildTag("presetdef", projectTag.getNamespace(), null, false);
        presetDef.setAttribute("name", se.getName());
        presetDef = (XmlTag)(anchor == null ? projectTag.add((PsiElement)presetDef) : projectTag.addBefore((PsiElement)presetDef, (PsiElement)anchor.getSourceElement()));
        ((Navigatable)presetDef).navigate(true);
        if (this.myFile != null) {
            element.getAntFile().clearCaches();
        }
    }
}

