/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.introspection.impl;

import com.intellij.lang.ant.misc.AntStringInterner;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntTypeDefinitionImpl
implements AntTypeDefinition {
    private static final AntTypeId ourJavadocId = new AntTypeId("javadoc");
    private static final AntTypeId ourUnzipId = new AntTypeId("unzip");
    private AntTypeId myTypeId;
    private final Set<String> myExtensionPoints;
    private String myClassName;
    private boolean myIsTask;
    private boolean myIsAllTaskContainer;
    private boolean myIsProperty;
    private PsiElement myDefiningElement;
    private boolean myIsOutdated;
    private final Map<String, AntAttributeType> myAttributes;
    private String[] myAttributesArray;
    private final Map<AntTypeId, String> myNestedClassNames;
    private AntTypeId[] myNestedElementsArray;

    public AntTypeDefinitionImpl(AntTypeDefinitionImpl base) {
        this(base.getTypeId(), base.getClassName(), base.isTask(), base.isAllTaskContainer(), new HashMap<String, AntAttributeType>(base.myAttributes), new HashMap<AntTypeId, String>(base.myNestedClassNames));
    }

    public AntTypeDefinitionImpl(AntTypeId id, String className, boolean isTask, boolean isAllTaskContainer) {
        this(id, className, isTask, isAllTaskContainer, new HashMap<String, AntAttributeType>(), new HashMap<AntTypeId, String>());
    }

    public AntTypeDefinitionImpl(AntTypeId id, String className, boolean isTask, boolean isAllTaskContainer, @NonNls @NotNull Map<String, AntAttributeType> attributes, Map<AntTypeId, String> nestedElements) {
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/ant/psi/introspection/impl/AntTypeDefinitionImpl.<init> must not be null");
        }
        this(id, className, isTask, isAllTaskContainer, attributes, nestedElements, null);
    }

    public AntTypeDefinitionImpl(AntTypeId id, String className, boolean isTask, boolean allTaskContainer, @NonNls @NotNull Map<String, AntAttributeType> attributes, Map<AntTypeId, String> nestedElements, PsiElement definingElement) {
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/ant/psi/introspection/impl/AntTypeDefinitionImpl.<init> must not be null");
        }
        this(id, className, isTask, allTaskContainer, attributes, nestedElements, Collections.emptySet(), definingElement);
    }

    public AntTypeDefinitionImpl(AntTypeId id, String className, boolean isTask, boolean isAllTaskContainer, @NonNls @NotNull Map<String, AntAttributeType> attributes, Map<AntTypeId, String> nestedElements, Set<String> extensionPoints, PsiElement definingElement) {
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/ant/psi/introspection/impl/AntTypeDefinitionImpl.<init> must not be null");
        }
        this.myIsOutdated = false;
        this.myTypeId = id;
        this.myExtensionPoints = extensionPoints;
        this.setClassName(className);
        this.myIsTask = isTask;
        this.myIsAllTaskContainer = isAllTaskContainer;
        attributes.put("id", AntAttributeType.STRING);
        this.myAttributes = attributes;
        this.myNestedClassNames = nestedElements;
        this.myDefiningElement = definingElement;
    }

    @Override
    public boolean isOutdated() {
        return this.myIsOutdated;
    }

    @Override
    public void setOutdated(boolean isOutdated) {
        this.myIsOutdated = isOutdated;
    }

    @Override
    public final AntTypeId getTypeId() {
        return this.myTypeId;
    }

    @Override
    public final void setTypeId(AntTypeId id) {
        this.myTypeId = id;
    }

    @Override
    public final String getClassName() {
        return this.myClassName;
    }

    @Override
    public final boolean isTask() {
        return this.myIsTask;
    }

    @Override
    public boolean isAllTaskContainer() {
        return this.myIsAllTaskContainer;
    }

    @Override
    public boolean isProperty() {
        return this.myIsProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public final String[] getAttributes() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myAttributesArray == null || this.myAttributesArray.length != this.myAttributes.size()) {
            this.myAttributesArray = this.myAttributes.keySet().toArray(new String[this.myAttributes.size()]);
        }
        // MONITOREXIT : object
        if (this.myAttributesArray != null) return this.myAttributesArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/introspection/impl/AntTypeDefinitionImpl.getAttributes must not return null");
    }

    @Override
    public final AntAttributeType getAttributeType(String attr) {
        for (int i = 0; i < attr.length(); ++i) {
            if (Character.isLowerCase(attr.charAt(i))) continue;
            return this.myAttributes.get(attr.toLowerCase(Locale.US));
        }
        return this.myAttributes.get(attr);
    }

    public final Map<String, AntAttributeType> getAttributesMap() {
        return this.myAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AntTypeId[] getNestedElements() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myNestedElementsArray == null || this.myNestedElementsArray.length != this.myNestedClassNames.size()) {
                this.myNestedElementsArray = this.myNestedClassNames.keySet().toArray(new AntTypeId[this.myNestedClassNames.size()]);
            }
            return this.myNestedElementsArray;
        }
    }

    public final Map<AntTypeId, String> getNestedElementsMap() {
        return this.myNestedClassNames;
    }

    @Override
    public boolean isExtensionPointType(ClassLoader loader, String className) {
        if ("java.lang.Object".equals(className)) {
            return false;
        }
        if (this.myExtensionPoints.contains(className)) {
            return true;
        }
        try {
            return this.isExtensionPointType(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isExtensionPointType(Class<?> aClass) {
        Class<?>[] interfaces;
        if (aClass == null || "java.lang.Object".equals(aClass.getName())) {
            return false;
        }
        if (this.myExtensionPoints.contains(aClass.getName())) {
            return true;
        }
        for (Class<?> iface : interfaces = aClass.getInterfaces()) {
            if (!this.isExtensionPointType(iface)) continue;
            return true;
        }
        return this.isExtensionPointType(aClass.getSuperclass());
    }

    @Override
    @Nullable
    public final String getNestedClassName(AntTypeId id) {
        String nsPrefix = id.getNamespacePrefix();
        if (nsPrefix == null) {
            String name = id.getName();
            if (name.equals("javadoc2")) {
                return this.myNestedClassNames.get(ourJavadocId);
            }
            if (name.equals("unwar") || name.equals("unjar")) {
                return this.myNestedClassNames.get(ourUnzipId);
            }
        }
        return this.myNestedClassNames.get(id);
    }

    @Override
    public final void registerNestedType(AntTypeId id, String taskClassName) {
        this.myNestedClassNames.put(id, taskClassName);
    }

    @Override
    public final void unregisterNestedType(AntTypeId typeId) {
        this.myNestedClassNames.remove(typeId);
    }

    @Override
    public final PsiElement getDefiningElement() {
        return this.myDefiningElement;
    }

    public final void setDefiningElement(PsiElement element) {
        this.myDefiningElement = element;
    }

    public final void setIsTask(boolean isTask) {
        this.myIsTask = isTask;
    }

    public final void setIsProperty(boolean isProperty) {
        this.myIsProperty = isProperty;
    }

    public final void setClassName(String className) {
        this.myClassName = AntStringInterner.intern(className);
    }
}

