/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.misc.AntStringInterner;
import com.intellij.lang.ant.misc.PsiElementWithValueSetSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntNameIdentifier;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntElementFactory;
import com.intellij.lang.ant.psi.impl.AntElementImpl;
import com.intellij.lang.ant.psi.impl.AntNameIdentifierImpl;
import com.intellij.lang.ant.psi.impl.AntTypeDefImpl;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SpinAllocator;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.StringSetSpinAllocator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntStructuredElementImpl
extends AntElementImpl
implements AntStructuredElement {
    private static final AntNameIdentifier ourNullIdentifier = new AntNameIdentifierImpl(null, null){

        @Override
        @NonNls
        public String getIdentifierName() {
            return "AntNullIdentifier";
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    protected volatile AntTypeDefinition myDefinition;
    private boolean myDefinitionCloned;
    private volatile AntNameIdentifier myIdElement;
    private volatile AntNameIdentifier myNameElement;
    @NonNls
    private volatile String myNameElementAttribute;
    private int myLastFoundElementOffset = -1;
    private AntElement myLastFoundElement;
    private volatile boolean myIsImported;
    private StringSetHolder myComputingAttrValue;
    protected volatile boolean myInGettingChildren;
    @NonNls
    private static final String ANTLIB_NS_PREFIX = "antlib:";
    @NonNls
    private static final String ANTLIB_XML = "antlib.xml";
    private static final Pattern $$_PATTERN = Pattern.compile("\\$\\$");
    private AntElement[] myLastProcessedChildren;

    private AntStructuredElementImpl(AntElement parent, XmlTag sourceElement, @NonNls String nameElementAttribute) {
        super(parent, (XmlElement)sourceElement);
        this.myNameElementAttribute = AntStringInterner.intern(nameElementAttribute);
        this.getIdElement();
        this.getNameElement();
        this.invalidateAntlibNamespace();
    }

    public AntStructuredElementImpl(AntElement parent, XmlTag sourceElement) {
        this(parent, sourceElement, "name");
    }

    public AntStructuredElementImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        this(parent, sourceElement, nameElementAttribute);
        this.myDefinition = definition;
        AntTypeId id = new AntTypeId(sourceElement.getName());
        if (definition != null) {
            if (!definition.getTypeId().equals(id)) {
                this.myDefinition = new AntTypeDefinitionImpl((AntTypeDefinitionImpl)this.myDefinition);
                this.myDefinition.setTypeId(id);
                this.myDefinitionCloned = true;
            }
        } else {
            AntFile file = this.getAntFile();
            if (file != null) {
                String className;
                AntTypeDefinition targetDef = file.getTargetDefinition();
                String string = className = targetDef != null ? targetDef.getNestedClassName(id) : null;
                if (className != null) {
                    this.myDefinition = file.getBaseTypeDefinition(className);
                }
            }
        }
    }

    public AntStructuredElementImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        this(parent, sourceElement, definition, "name");
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntStructuredElement(this);
    }

    @Override
    @NotNull
    public XmlTag getSourceElement() {
        XmlTag xmlTag = (XmlTag)super.getSourceElement();
        if (xmlTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getSourceElement must not return null");
        }
        return xmlTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntStructuredElement[");
            builder.append(this.getSourceElement().getName());
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public String getName() {
        if (this.hasNameElement()) {
            return this.computeAttributeValue(this.getNameElement().getIdentifierName());
        }
        if (this.hasIdElement()) {
            return this.computeAttributeValue(this.getIdElement().getIdentifierName());
        }
        XmlTag sourceElement = this.getSourceElement();
        return sourceElement != null ? sourceElement.getName() : super.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.setName must not be null");
        }
        try {
            if (this.hasNameElement()) {
                this.getNameElement().setIdentifierName(name);
            } else if (this.hasIdElement()) {
                this.getIdElement().setIdentifierName(name);
            }
            AntStructuredElementImpl antStructuredElementImpl = this;
            return antStructuredElementImpl;
        }
        finally {
            this.clearCaches();
        }
    }

    @Override
    public boolean canRename() {
        return super.canRename() && (this.hasNameElement() || this.hasIdElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement findElementAt(int offset) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (offset != this.myLastFoundElementOffset || this.myLastFoundElement != null && !this.myLastFoundElement.isValid()) {
                PsiElement foundElement = super.findElementAt(offset);
                if (foundElement == null) {
                    return null;
                }
                this.myLastFoundElement = (AntElement)foundElement;
                this.myLastFoundElementOffset = offset;
            }
            return this.myLastFoundElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntTypeDefinition getTypeDefinition() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntTypeDefinition currentDef;
            if (this.myDefinition != null && !this.myDefinitionCloned && this.myDefinition.isOutdated() && (currentDef = this.getAntFile().getBaseTypeDefinition(this.myDefinition.getClassName())) != null) {
                this.myDefinition = currentDef;
            }
            return this.myDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCustomType(AntTypeDefinition def) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntTypeDefinition definition = this.getTypeDefinition();
            if (definition != null) {
                if (!this.myDefinitionCloned) {
                    this.myDefinition = definition = new AntTypeDefinitionImpl((AntTypeDefinitionImpl)definition);
                    this.myDefinitionCloned = true;
                }
                definition.registerNestedType(def.getTypeId(), def.getClassName());
            }
            this.getAntFile().registerCustomType(def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCustomType(AntTypeDefinition def) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntTypeId typeId;
            String registeredClassName;
            if (this.myDefinition != null && this.myDefinitionCloned && (registeredClassName = this.myDefinition.getNestedClassName(typeId = def.getTypeId())) != null && registeredClassName.equals(def.getClassName())) {
                this.myDefinition.unregisterNestedType(typeId);
            }
            this.getAntFile().unregisterCustomType(def);
        }
    }

    @Override
    public boolean hasImportedTypeDefinition() {
        return this.myIsImported;
    }

    void setImportedTypeDefinition(boolean imported) {
        this.myIsImported = imported;
    }

    @Override
    @Nullable
    public PsiFile findFileByName(String name) {
        return this.findFileByName(name, "");
    }

    @Override
    @Nullable
    public PsiFile findFileByName(String name, @Nullable String baseDir) {
        String fileName;
        if (name == null) {
            return null;
        }
        AntFile antFile = this.getAntFile();
        if (antFile == null) {
            return null;
        }
        VirtualFile vFile = antFile.getContainingPath();
        if (vFile == null) {
            return null;
        }
        String projectPath = vFile.getPath();
        String dir = baseDir;
        if (dir == null) {
            AntProject project = antFile.getAntProject();
            String string = dir = project == null ? null : project.getBaseDir();
        }
        if (dir != null && dir.length() > 0) {
            projectPath = new File(projectPath, dir).getAbsolutePath();
        }
        if ((fileName = this.computeAttributeValue(name)) == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(projectPath, fileName);
        }
        if ((vFile = LocalFileSystem.getInstance().findFileByPath(file.getAbsolutePath().replace(File.separatorChar, '/'))) == null) {
            return null;
        }
        return antFile.getViewProvider().getManager().findFile(vFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String computeAttributeValue(String value) {
        if (value == null || value.indexOf(36) < 0) {
            return value;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (!(value == null || this.myComputingAttrValue != null && this.myComputingAttrValue.contains(value))) {
                try {
                    if (this.myComputingAttrValue == null) {
                        this.myComputingAttrValue = new StringSetHolder();
                    }
                    AntConfigurationBase antConfig = AntConfigurationBase.getInstance(this.getProject());
                    this.myComputingAttrValue.add(value);
                    Set<Pair<PsiElement, String>> set = PsiElementWithValueSetSpinAllocator.alloc();
                    String string = this.computeAttributeValue(value, set, antConfig);
                    PsiElementWithValueSetSpinAllocator.dispose(set);
                    return string;
                    {
                        catch (Throwable throwable) {
                            try {
                                PsiElementWithValueSetSpinAllocator.dispose(set);
                                throw throwable;
                            }
                            catch (SpinAllocator.AllocatorExhaustedException e) {
                                String string2 = this.computeAttributeValue(value, new HashSet<Pair<PsiElement, String>>(), antConfig);
                                this.myComputingAttrValue.remove(value);
                                if (this.myComputingAttrValue.size() == 0) {
                                    this.myComputingAttrValue.dispose();
                                    this.myComputingAttrValue = null;
                                }
                                return string2;
                            }
                        }
                    }
                }
                finally {
                    this.myComputingAttrValue.remove(value);
                    if (this.myComputingAttrValue.size() == 0) {
                        this.myComputingAttrValue.dispose();
                        this.myComputingAttrValue = null;
                    }
                }
            }
            return null;
        }
    }

    @Override
    public boolean hasNameElement() {
        return this.getNameElement() != ourNullIdentifier;
    }

    @Override
    public boolean hasIdElement() {
        return this.getIdElement() != ourNullIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<String> getFileReferenceAttributes() {
        List<String> list;
        AntTypeDefinition typeDef = this.getTypeDefinition();
        if (typeDef == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getFileReferenceAttributes must not return null");
            return list;
        }
        String[] attribs = typeDef.getAttributes();
        if (attribs.length == 0) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getFileReferenceAttributes must not return null");
            return list;
        }
        ArrayList<String> fileRefAttributes = new ArrayList<String>(attribs.length);
        for (String attrib : attribs) {
            if (typeDef.getAttributeType(attrib) != AntAttributeType.FILE) continue;
            fileRefAttributes.add(attrib);
        }
        list = fileRefAttributes;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getFileReferenceAttributes must not return null");
    }

    @Override
    public boolean isTypeDefined() {
        AntTypeDefinition def = this.getTypeDefinition();
        return def != null && def.getDefiningElement() instanceof AntTypeDefImpl;
    }

    @Override
    public boolean isPresetDefined() {
        AntTypeDefinition def = this.getTypeDefinition();
        return def != null && def.getClassName().startsWith("AntPresetDef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myIdElement = null;
            this.myNameElement = null;
            this.myLastFoundElementOffset = -1;
            this.myLastFoundElement = null;
            this.myLastProcessedChildren = null;
            this.invalidateAntlibNamespace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntElement lightFindElementAt(int offset) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (offset == this.myLastFoundElementOffset) {
                return this.myLastFoundElement;
            }
        }
        return super.lightFindElementAt(offset);
    }

    public int getTextOffset() {
        if (this.hasNameElement()) {
            return this.getNameElement().getTextOffset();
        }
        if (this.hasIdElement()) {
            return this.getIdElement().getTextOffset();
        }
        return super.getTextOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AntElement[] getChildrenInner() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (!this.myInGettingChildren) {
                AntElement[] antElementArray;
                this.myInGettingChildren = true;
                try {
                    ArrayList<AntElement> children = new ArrayList<AntElement>();
                    if (this.hasIdElement()) {
                        children.add(this.getIdElement());
                    }
                    if (this.hasNameElement()) {
                        children.add(this.getNameElement());
                    }
                    for (PsiElement element : this.getSourceElement().getChildren()) {
                        AntElement antElement;
                        if (!(element instanceof XmlElement) || (antElement = AntElementFactory.createAntElement(this, (XmlElement)element)) == null) continue;
                        children.add(antElement);
                    }
                    int count = children.size();
                    antElementArray = count > 0 ? children.toArray(new AntElement[count]) : AntElement.EMPTY_ARRAY;
                    this.myInGettingChildren = false;
                }
                catch (Throwable throwable) {
                    this.myInGettingChildren = false;
                    throw throwable;
                }
                return antElementArray;
            }
            return AntElement.EMPTY_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntElement[] getChildren() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        AntElement[] antElementArray = this.fixUndefinedElements(super.getChildren());
        // MONITOREXIT : object
        if (antElementArray != null) return antElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getChildren must not return null");
    }

    private AntElement[] fixUndefinedElements(AntElement[] elements) {
        if (this.myLastProcessedChildren == elements) {
            return elements;
        }
        this.myLastProcessedChildren = elements;
        if (this.isValid()) {
            for (int i = 0; i < elements.length; ++i) {
                XmlTag sourceElement;
                AntStructuredElement se;
                AntElement element = elements[i];
                if (!(element instanceof AntStructuredElement) || !element.isValid() || (se = (AntStructuredElement)element).getTypeDefinition() != null || (se = (AntStructuredElement)AntElementFactory.createAntElement(this, (XmlElement)(sourceElement = se.getSourceElement()))) == null || se.getTypeDefinition() == null) continue;
                elements[i] = se;
            }
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AntNameIdentifier getIdElement() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myIdElement == null) {
            XmlAttributeValue valueElement;
            XmlAttribute idAttr;
            this.myIdElement = ourNullIdentifier;
            XmlTag se = this.getSourceElement();
            if (se.isValid() && (idAttr = se.getAttribute("id", null)) != null && (valueElement = idAttr.getValueElement()) != null) {
                AntNameIdentifierImpl identifier = new AntNameIdentifierImpl((AntElement)this, valueElement);
                this.myIdElement = identifier;
                this.getAntProject().registerRefId(identifier.getIdentifierName(), this);
            }
        }
        AntNameIdentifier antNameIdentifier = this.myIdElement;
        // MONITOREXIT : object
        if (antNameIdentifier != null) return antNameIdentifier;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getIdElement must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AntNameIdentifier getNameElement() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myNameElement == null) {
            XmlAttributeValue valueElement;
            XmlAttribute nameAttr;
            this.myNameElement = ourNullIdentifier;
            XmlTag se = this.getSourceElement();
            if (se.isValid() && (nameAttr = se.getAttribute(this.myNameElementAttribute, null)) != null && (valueElement = nameAttr.getValueElement()) != null) {
                this.myNameElement = new AntNameIdentifierImpl((AntElement)this, valueElement);
            }
        }
        AntNameIdentifier antNameIdentifier = this.myNameElement;
        // MONITOREXIT : object
        if (antNameIdentifier != null) return antNameIdentifier;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntStructuredElementImpl.getNameElement must not return null");
    }

    @NonNls
    protected String getNameElementAttribute() {
        return this.myNameElementAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeAttributeValue(String value, final Set<Pair<PsiElement, String>> elementStack, final AntConfigurationBase antConfig) {
        Pair resolveStackEntry = new Pair((Object)this, (Object)value);
        elementStack.add((Pair<PsiElement, String>)resolveStackEntry);
        try {
            int startProp = 0;
            AntFile self = this.getAntFile();
            AntFile antFile = antConfig.getEffectiveContextFile(self);
            while ((startProp = value.indexOf("${", startProp)) >= 0) {
                String string;
                if (startProp > 0 && value.charAt(startProp - 1) == '$') {
                    startProp += 2;
                    continue;
                }
                int endProp = value.indexOf(125, startProp + 2);
                if (endProp <= startProp + 2) {
                    startProp += 2;
                    continue;
                }
                final String prop = value.substring(startProp + 2, endProp);
                final Ref resolvedValueRef = new Ref(null);
                final Ref shouldReturnOriginalValue = new Ref((Object)Boolean.FALSE);
                antFile.processAllProperties(prop, new Processor<AntProperty>(){

                    public boolean process(AntProperty antProperty) {
                        String resolvedValue = antProperty.getValue(prop);
                        if (resolvedValue == null) {
                            return true;
                        }
                        if (elementStack.contains(new Pair((Object)antProperty, (Object)resolvedValue))) {
                            shouldReturnOriginalValue.set((Object)Boolean.TRUE);
                        } else {
                            resolvedValueRef.set((Object)((AntStructuredElementImpl)((Object)antProperty)).computeAttributeValue(resolvedValue, elementStack, antConfig));
                        }
                        return false;
                    }
                });
                if (((Boolean)shouldReturnOriginalValue.get()).booleanValue()) {
                    string = value;
                    return string;
                }
                if (resolvedValueRef.get() == null) {
                    startProp += 2;
                    continue;
                }
                if (((String)resolvedValueRef.get()).equals(value)) {
                    string = value;
                    return string;
                }
                StringBuilder builder = StringBuilderSpinAllocator.alloc();
                try {
                    String substituted;
                    builder.append(value, 0, startProp);
                    builder.append((String)resolvedValueRef.get());
                    if (endProp < value.length() - 1) {
                        builder.append(value, endProp + 1, value.length());
                    }
                    if (!(substituted = builder.toString()).equals(value)) {
                        value = substituted;
                        continue;
                    }
                    startProp += 2;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                }
            }
            if (value.indexOf("$$") >= 0) {
                String string = $$_PATTERN.matcher(value).replaceAll("\\$");
                return string;
            }
            String string = value;
            return string;
        }
        finally {
            elementStack.remove(resolveStackEntry);
        }
    }

    private String getNamespace() {
        return this.getSourceElement().getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAntlibNamespace() {
        AntFile file = this.getAntFile();
        if (file == null) {
            return;
        }
        ClassLoader loader = file.getClassLoader();
        if (loader == null) {
            return;
        }
        String ns = this.getNamespace();
        if (!ns.startsWith(ANTLIB_NS_PREFIX)) {
            return;
        }
        AntElement parent = this.getAntParent();
        if (!(this instanceof AntProject) && parent instanceof AntStructuredElementImpl && ns.equals(((AntStructuredElementImpl)parent).getNamespace())) {
            return;
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(ns.substring(ANTLIB_NS_PREFIX.length()).replace('.', '/'));
            builder.append('/');
            builder.append(ANTLIB_XML);
            InputStream antlibStream = loader.getResourceAsStream(builder.toString());
            if (antlibStream != null) {
                AntTypeDefImpl.loadAntlibStream(antlibStream, this, ns);
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private static final class StringSetHolder {
        @NotNull
        private Set<String> mySet;
        private boolean myShouldDispose = true;

        public StringSetHolder() {
            try {
                this.mySet = StringSetSpinAllocator.alloc();
            }
            catch (SpinAllocator.AllocatorExhaustedException e) {
                this.mySet = new HashSet<String>();
                this.myShouldDispose = false;
            }
        }

        public boolean contains(String str) {
            return this.mySet.contains(str);
        }

        public int size() {
            return this.mySet.size();
        }

        public boolean add(String s) {
            return this.mySet.add(s);
        }

        public boolean remove(String s) {
            return this.mySet.remove(s);
        }

        public void dispose() {
            if (this.myShouldDispose) {
                StringSetSpinAllocator.dispose(this.mySet);
            }
        }
    }
}

