/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.lang.ant.config.impl.AntInstallationClassLoaderHolder;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.ClassLoaderHolder;
import com.intellij.lang.ant.config.impl.SinglePathEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StringProperty;
import com.intellij.util.containers.Convertor;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class AntInstallation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.impl.AntInstallation");
    public static final StringProperty HOME_DIR = new StringProperty("homeDir", "");
    public static final AbstractProperty<String> NAME = new StringProperty("name", "");
    public static final ListProperty<AntClasspathEntry> CLASS_PATH = ListProperty.create((String)"classpath");
    public static final Comparator<AntInstallation> NAME_COMPARATOR = new Comparator<AntInstallation>(){

        @Override
        public int compare(AntInstallation antInstallation, AntInstallation antInstallation1) {
            return String.CASE_INSENSITIVE_ORDER.compare(antInstallation.getName(), antInstallation1.getName());
        }
    };
    public static final Convertor<AntInstallation, AntReference> REFERENCE_TO_ANT = new Convertor<AntInstallation, AntReference>(){

        public AntReference convert(AntInstallation antInstallation) {
            return antInstallation.getReference();
        }
    };
    public static final AbstractProperty<String> VERSION = new StringProperty("version", AntBundle.message("ant.unknown.version.string.presentation", new Object[0]));
    @NonNls
    private static final String PROPERTY_VERSION = "VERSION";
    private final ClassLoaderHolder myClassLoaderHolder;
    @NonNls
    public static final String PATH_TO_ANT_JAR = "lib/ant.jar";
    @NonNls
    public static final String LIB_DIR = "lib";
    @NonNls
    public static final String ANT_JAR_FILE = "ant.jar";
    @NonNls
    public static final String VERSION_RESOURCE = "org/apache/tools/ant/version.txt";
    public static final Externalizer<AntInstallation> EXTERNALIZER = new Externalizer<AntInstallation>(){

        public AntInstallation readValue(Element dataElement) throws InvalidDataException {
            AntInstallation antInstallation = new AntInstallation();
            antInstallation.readExternal(dataElement);
            return antInstallation;
        }

        public void writeValue(Element dataElement, AntInstallation antInstallation) throws WriteExternalException {
            antInstallation.myProperties.writeExternal(dataElement);
        }
    };
    private final ExternalizablePropertyContainer myProperties;

    public AntReference getReference() {
        return new AntReference.BindedReference(this);
    }

    private void readExternal(Element dataElement) throws InvalidDataException {
        this.myProperties.readExternal(dataElement);
        File antJar = new File((String)HOME_DIR.get((AbstractProperty.AbstractPropertyContainer)this.myProperties), PATH_TO_ANT_JAR);
        this.updateVersion(antJar);
    }

    void updateVersion(File antJar) {
        if (antJar.exists()) {
            try {
                Properties antProps = AntInstallation.loadProperties(antJar);
                VERSION.set(this.getProperties(), (Object)antProps.getProperty(PROPERTY_VERSION));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    AntInstallation() {
        this(new ExternalizablePropertyContainer());
        AntInstallation.registerProperties(this.myProperties);
    }

    private AntInstallation(ExternalizablePropertyContainer properties) {
        this.myProperties = properties;
        this.myClassLoaderHolder = new AntInstallationClassLoaderHolder((AbstractProperty.AbstractPropertyContainer)this.myProperties);
    }

    public String getName() {
        return (String)NAME.get((AbstractProperty.AbstractPropertyContainer)this.myProperties);
    }

    public void setName(String name) {
        NAME.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)name);
    }

    public String getVersion() {
        return (String)VERSION.get((AbstractProperty.AbstractPropertyContainer)this.myProperties);
    }

    public String getHomeDir() {
        return (String)HOME_DIR.get((AbstractProperty.AbstractPropertyContainer)this.myProperties);
    }

    public AbstractProperty.AbstractPropertyContainer getProperties() {
        return this.myProperties;
    }

    public ClassLoader getClassLoader() {
        return this.myClassLoaderHolder.getClassloader();
    }

    public void updateClasspath() {
        this.myClassLoaderHolder.updateClasspath();
    }

    public static AntInstallation fromHome(String homePath) throws ConfigurationException {
        File antHome = new File(homePath);
        String antPath = "'" + antHome.getAbsolutePath() + "'";
        AntInstallation.checkExists(antHome, AntBundle.message("path.to.ant.does.not.exist.error.message", antPath));
        File lib = new File(antHome, LIB_DIR);
        AntInstallation.checkExists(lib, AntBundle.message("lib.directory.not.found.in.ant.path.error.message", antPath));
        File antJar = new File(lib, ANT_JAR_FILE);
        AntInstallation.checkExists(antJar, AntBundle.message("ant.jar.not.found.in.directory.error.message", lib.getAbsolutePath()));
        if (antJar.isDirectory()) {
            throw new ConfigurationException(AntBundle.message("ant.jar.is.directory.error.message", antJar.getAbsolutePath()));
        }
        try {
            Properties properties = AntInstallation.loadProperties(antJar);
            AntInstallation antInstallation = new AntInstallation();
            HOME_DIR.set(antInstallation.getProperties(), (Object)antHome.getAbsolutePath());
            String versionProp = properties.getProperty(PROPERTY_VERSION);
            NAME.set(antInstallation.getProperties(), (Object)AntBundle.message("apache.ant.with.version.string.presentation", versionProp));
            VERSION.set(antInstallation.getProperties(), (Object)versionProp);
            antInstallation.addClasspathEntry(new AllJarsUnderDirEntry(lib));
            return antInstallation;
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static Properties loadProperties(File antJar) throws MalformedURLException, ConfigurationException {
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = new UrlClassLoader(Collections.singletonList(antJar.toURL()), null).getResourceAsStream(VERSION_RESOURCE);
            properties.load(stream);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ConfigurationException(AntBundle.message("cant.read.from.ant.jar.error.message", antJar.getAbsolutePath()));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return properties;
    }

    private void addClasspathEntry(AntClasspathEntry entry) {
        CLASS_PATH.getModifiableList(this.getProperties()).add(entry);
    }

    private static void checkExists(File file, String message) throws ConfigurationException {
        if (!file.exists()) {
            throw new ConfigurationException(message);
        }
    }

    private static void registerProperties(ExternalizablePropertyContainer container) {
        container.registerProperty((StringProperty)NAME);
        container.registerProperty(HOME_DIR);
        container.registerProperty(CLASS_PATH, "classpathItem", SinglePathEntry.EXTERNALIZER);
        container.registerProperty((StringProperty)VERSION);
    }

    public static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }
    }
}

