/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.MoveAction;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.projectView.Form;
import com.intellij.uiDesigner.projectView.FormMoveProvider;
import com.intellij.uiDesigner.projectView.FormNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class FormMergerTreeStructureProvider
implements TreeStructureProvider {
    private final Project myProject;

    public FormMergerTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    public Collection<AbstractTreeNode> modify(AbstractTreeNode parent, Collection<AbstractTreeNode> children, ViewSettings settings) {
        ProjectViewNode[] copy;
        if (parent.getValue() instanceof Form) {
            return children;
        }
        boolean formsFound = false;
        for (AbstractTreeNode node : children) {
            PsiFile file;
            if (!(node.getValue() instanceof PsiFile) || (file = (PsiFile)node.getValue()).getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
            formsFound = true;
            break;
        }
        if (!formsFound) {
            return children;
        }
        LinkedHashSet<AbstractTreeNode> result = new LinkedHashSet<AbstractTreeNode>(children);
        for (ProjectViewNode element : copy = children.toArray(new ProjectViewNode[children.size()])) {
            List<PsiFile> forms;
            PsiClass aClass;
            String qName;
            if (!(element.getValue() instanceof PsiClass) || (qName = (aClass = (PsiClass)element.getValue()).getQualifiedName()) == null) continue;
            try {
                forms = FormClassIndex.findFormsBoundToClass(this.myProject, qName);
            }
            catch (ProcessCanceledException e) {
                continue;
            }
            Collection<BasePsiNode<? extends PsiElement>> formNodes = FormMergerTreeStructureProvider.findFormsIn(children, forms);
            if (formNodes.isEmpty()) continue;
            Collection<PsiFile> formFiles = FormMergerTreeStructureProvider.convertToFiles(formNodes);
            ArrayList<BasePsiNode<? extends PsiElement>> subNodes = new ArrayList<BasePsiNode<? extends PsiElement>>();
            subNodes.add((BasePsiNode)element);
            subNodes.addAll(formNodes);
            result.add((AbstractTreeNode)new FormNode(this.myProject, new Form(aClass, formFiles), settings, subNodes));
            result.remove(element);
            result.removeAll(formNodes);
        }
        return result;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataId) {
        block4: {
            block6: {
                block5: {
                    if (selected == null) break block4;
                    if (!Form.DATA_KEY.is(dataId)) break block5;
                    ArrayList<Form> result = new ArrayList<Form>();
                    for (AbstractTreeNode node : selected) {
                        if (!(node.getValue() instanceof Form)) continue;
                        result.add((Form)node.getValue());
                    }
                    if (!result.isEmpty()) {
                        return result.toArray(new Form[result.size()]);
                    }
                    break block4;
                }
                if (!PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) break block6;
                for (AbstractTreeNode node : selected) {
                    if (!(node.getValue() instanceof Form)) continue;
                    return new MyDeleteProvider(selected);
                }
                break block4;
            }
            if (!MoveAction.MoveProvider.DATA_KEY.is(dataId)) break block4;
            for (AbstractTreeNode node : selected) {
                if (!(node.getValue() instanceof Form)) continue;
                return new FormMoveProvider();
            }
        }
        return null;
    }

    private static Collection<PsiFile> convertToFiles(Collection<BasePsiNode<? extends PsiElement>> formNodes) {
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (BasePsiNode<? extends PsiElement> treeNode : formNodes) {
            psiFiles.add((PsiFile)treeNode.getValue());
        }
        return psiFiles;
    }

    private static Collection<BasePsiNode<? extends PsiElement>> findFormsIn(Collection<AbstractTreeNode> children, List<PsiFile> forms) {
        if (children.isEmpty() || forms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BasePsiNode<? extends PsiElement>> result = new ArrayList<BasePsiNode<? extends PsiElement>>();
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>(forms);
        for (AbstractTreeNode child : children) {
            BasePsiNode treeNode;
            if (!(child instanceof BasePsiNode) || !psiFiles.contains((treeNode = (BasePsiNode)child).getValue())) continue;
            result.add((BasePsiNode<? extends PsiElement>)treeNode);
        }
        return result;
    }

    private static class MyDeleteProvider
    implements DeleteProvider {
        private final PsiElement[] myElements;

        public MyDeleteProvider(Collection<AbstractTreeNode> selected) {
            this.myElements = MyDeleteProvider.collectFormPsiElements(selected);
        }

        public void deleteElement(DataContext dataContext) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            DeleteHandler.deletePsiElement((PsiElement[])this.myElements, (Project)project);
        }

        public boolean canDeleteElement(DataContext dataContext) {
            return DeleteHandler.shouldEnableDeleteAction((PsiElement[])this.myElements);
        }

        private static PsiElement[] collectFormPsiElements(Collection<AbstractTreeNode> selected) {
            HashSet<Object> result = new HashSet<Object>();
            for (AbstractTreeNode node : selected) {
                if (node.getValue() instanceof Form) {
                    Form form = (Form)node.getValue();
                    result.add(form.getClassToBind());
                    result.addAll(Arrays.asList(form.getFormFiles()));
                    continue;
                }
                if (!(node.getValue() instanceof PsiElement)) continue;
                result.add((PsiElement)node.getValue());
            }
            return result.toArray(new PsiElement[result.size()]);
        }
    }
}

